/*******************
** Eldarea MUDLib **
********************
**
** std/player/viewcmd.c - player view command handling
**
** CVS DATA
** $Date: 2001/02/01 09:25:40 $
** $Revision: 1.4 $
**
** CVS History
**
** $Log: viewcmd.c,v $
** Revision 1.4  2001/02/01 09:25:40  elatar
** clock header moved
**
** Revision 1.3  2000/12/11 13:25:05  elatar
** new view handling with P_VISION
**
** Revision 1.2  2000/12/01 16:25:15  elatar
** color handling adapted
** blind, deaf, bland properties and methods moved to living/senses
** equipment-command changed
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

#define NEED_PROTOTYPES

#include <thing/properties.h>
#include <container.h>
#include <player/color.h>
#include <living/put_and_get.h>

#undef NEED_PROTOTYPES

#include <properties.h>
#include <wizlevels.h>
#include <defines.h>
#include <ansi.h>
#include <units.h>
#include <clock.h>
#include <color.h>

private static string last_det;

string CountUp(string *foo);
private mixed* examine_parse(string str, string fun);
private static string colorize_details(string str, object what);

void create()
{
  Set(P_BRIEF, SAVE, F_MODE);
}

int _toggle_brief(string str)
{
  int brief;

  if (query_verb()=="kurz")
    brief=1;
  else if (query_verb()=="blindflug")
    brief=2;
  else {
    if (str!=0) {
      if (str=="immer") brief=-1;
      else {
        notify_fail("Entweder nur 'lang' oder 'lang immer'.\n");
        return 0;
      }
    } else brief=0;
  }
  if (brief>0 && str) {
    notify_fail("Bitte kein Argument angeben.\n");
    return 0;
  }
  SetProp(P_BRIEF, brief);
  write("Du bist nun "+(brief<0?"immer ":"")+"im "+
        (brief>0?(brief==1?"Kurzmodus.\n":"Blindflug.\n"):"Langmodus.\n"));
  return 1;
}

object *spec_inventory(object pl)
{
  int i;
  object *inv,*ret;
  ret=({});
  for(inv=all_inventory(pl);sizeof(inv);inv=inv[1..])
    if(!inv[0]->IsMoney()) ret+= ({ inv[0] });
  return ret;
}


int _inventory(string str) {
  int i,j;
  object *inv,*ActArms,*ActWeap,*Aload,*Arms,*Weap,*Trash, *Geld;
  mixed s, text, extra;
  string s1, s2;

  notify_fail("Benutzung: i[nventur] [-[rsmgan]]\n");

  if (str && ((strlen(str)<=1) || (str[0..0]!="-")))
    return 0;

  if (str)
      str = str[1..];
  else str="";
  
  if (strstr(str,"m")>-1) 
      extra="m";
  else 
      extra="";
  if (strstr(str,"n")>-1) extra+="n";

  if(QueryProp(P_TTY) == "ansi" || QueryProp(P_TTY) == "vt100") {
      s1 = ANSI_BOLD;
      s2 = ANSI_NORMAL;
  }
  else s1 = s2 = "";

  inv = all_inventory(ME);

  if (str && strstr(str,"g")>-1)  
      inv -= filter_objects(inv, "IsMoney");

  if (str && strstr(str,"a")>-1)  
      inv -= filter_objects(inv, "QueryProp", P_AUTOLOADOBJ);

  if (str && strstr(str,"r")>-1)
    s = make_invlist(this_player(),inv,extra);
  else if (str && strstr(str,"s")>-1)
    s = efun::implode(sort_array(efun::explode(make_invlist(this_player(),inv,extra),"\n"),#'>),"\n");
  else {
    ActArms = ({});
    ActWeap = ({});
    Aload = ({});
    Arms = ({});
    Weap = ({});
    Trash = ({});
    Geld = ({});
    for (j=sizeof(inv),i=0;i<j;i++)
      if(inv[i]->id("\ngeld") && inv[i]->QueryProp(P_AMOUNT)) {
	     inv[i]->SetProp(U_REQ,inv[i]->QueryProp(P_AMOUNT));
          Geld += ({ inv[i]->name(WEN,0) });
      }
      else if (inv[i]->QueryProp(P_WORN))
        ActArms += ({ inv[i] });
      else if (inv[i]->QueryProp(P_WIELDED))
        ActWeap += ({ inv[i] });
      else if (inv[i]->QueryProp(P_AUTOLOADOBJ) || inv[i]->_query_autoloadobj())
        Aload += ({ inv[i] });
      else if (inv[i]->id("waffe"))
        Weap += ({ inv[i] });
      else if (inv[i]->id("ruestung"))
        Arms += ({ inv[i] });
      else Trash += ({ inv[i] });
    s = "";
    if (sizeof(Geld))
      s += s1+"Zahlungsmittel:"+s2+
        break_string("\nDu hast "+ME->CountUp(Geld)+" bei Dir.", 0,"  ",BS_IND_FIRST);
    if (sizeof(ActWeap) &&
       (text = efun::implode(sort_array(efun::explode(
               make_invlist(this_player(),ActWeap,extra),"\n"),#'>),"\n"))!="")
      s += s1+"Aktive Waffe:"+s2+break_string(text, 0,"  ",BS_IND_FIRST);
    if (sizeof(ActArms) &&
       (text = efun::implode(sort_array(efun::explode(
               make_invlist(this_player(),ActArms,extra),"\n"),#'>),"\n"))!="")
      s += s1+"Aktive Ruestung(en):"+s2+break_string(text, 0,"  ",BS_IND_FIRST);
    if (sizeof(Aload) &&
       (text = efun::implode(sort_array(efun::explode(
               make_invlist(this_player(),Aload,extra),"\n"),#'>),"\n"))!="")
      s += s1+"Autoload:"+s2+break_string(text, 0,"  ",BS_IND_FIRST);
    if (sizeof(Weap) &&
       (text = efun::implode(sort_array(efun::explode(
               make_invlist(this_player(),Weap,extra),"\n"),#'>),"\n"))!="")
      s += s1+"Waffe(n):"+s2+break_string(text, 0,"  ",BS_IND_FIRST);
    if (sizeof(Arms) &&
       (text = efun::implode(sort_array(efun::explode(
               make_invlist(this_player(),Arms,extra),"\n"),#'>),"\n"))!="")
      s += s1+"Ruestung(en):"+s2+break_string(text, 0,"  ",BS_IND_FIRST);
    if (sizeof(Trash) &&
       (text = efun::implode(sort_array(efun::explode(
               make_invlist(this_player(),Trash,extra),"\n"),#'>),"\n"))!="")
      s += s1+"Sonstiges:"+s2+break_string(text, 0, "  ",BS_IND_FIRST);
  }

  if (s=="" || !s)
    write("Du traegst zur Zeit nichts bei Dir.\n");
  else
    ME->More(s[0..<2]);
  return 1;
}

#define AlleCoinmaster ({({"Wunderland","/obj/coinmaster_WL"})})

static int geld(string str) {
	string * x;
	mapping* coins;
	int* values, i, j, flag;
	object* geld,* coin;
	mixed* CMS;
	float f;

	if (str) {
		notify_fail("Zum Zaehlen des Geldes bitte nur 'geld' tippen.\n");
		return 0;
	}

	str="Du untersuchst Deine monetaere Situation:\n";
	CMS=AlleCoinmaster;
	coins=map_array(CMS, lambda( ({ 'x }),
		({ #'call_other, ({ #'[, 'x, 1 }), "query_coins" }) ));
	geld=filter_array(all_inventory(), lambda(
		({ 'x }) , ({ #'&&, ({ #'call_other, 'x, "id", "\ngeld" }),
							({ #'call_other, 'x, "QueryProp", P_AMOUNT }) }) ));
	map_array(geld, lambda(
		({ 'x }) , ({ #'call_other, 'x, "SetProp", U_REQ, 
			({ #'call_other, 'x, "QueryProp", P_AMOUNT }) }) ));
	for (i=0; i<sizeof(CMS); i++) {
		str+="\nIn "+CMS[i][0]+"-Waehrung besitzt Du";
		f=(float)call_other(CMS[i][1], "QueryMoney", this_object());
		if (f==0) {
			str+=" nichts.\n";
			continue;
		}
		str+=":\n";
		values=sort_array(m_indices(coins[i]), #'>);
		for (j=sizeof(values); j--;) {
			coin=filter_array(geld,
				lambda( ({ 'x, 'y }), ({ #'call_other, 'x, "id", 'y }) ),
				coins[i][values[j]][3]);
			if (!sizeof(coin)) {
				str+=(str[<1]=='\n'?"K":"k")+"eine "+coins[i][values[j]][2];
			} else {
				str+=(str[<1]=='\n'?capitalize(coin[0]->name(WEN,0)):coin[0]->name(WEN,0));
			}
			if (j>=2) str+=", ";
			else if (j==1) str+=" und ";
			else str+=".\n";
		}
		str+="Du ueberschlaegst im Kopf und denkst: Also";
		flag=((int)f!=values[<1])+1;
		f=f/(float)values[<1];
		x=efun::explode(" "+f, ".");
		if (sizeof(x)>1) x[1]=x[1][0..2];
		str+=implode(x, ",");
		str+=" "+coins[i][values[<1]][flag]+".\n";
	}
	write(str);
	return 1;
}

void smart_log(string myname, string str);

varargs int _examine(string str, int mode) 
{
  string desc, s, daytime;
  mixed* erg;
  object env;
  int see;

  see = this_player()->CanSee();
  if (member_array(str, ({"tageszeit","tag","nacht","zeit","sonne","mond",
        "sterne","himmel"}))>=0) 
  {
    if (!see) 
      return 1;
    
    env = environment(this_player());
    last_det=str;
    if (env && (s = env->GetDetail(str))) 
    {
      s=break_string(s);
      if (IS_LEARNING(ME)) s=colorize_details(s, env);
      write(s);
      return 1;
    }
    if (!s) 
    {
      daytime=UHR->GetLighting();
      if (env->QueryProp(P_INDOORS)) 
      {
        if (!(desc=env->QueryProp(P_SEE_LIGHT)))
          write("So etwas koennt Ihr hier drinnen nicht erkennen.\n");
        else if (!stringp(desc))
          write(sprintf("Es ist gerade %s.\n",daytime));
        else
          write(break_string(efun::implode(efun::explode(desc,
            "&&"),daytime)));
        return 1;
      }
      write(sprintf("Es ist gerade %s.\n",daytime));
      return 1;
    }
  }

  if (!see) 
    return 1;

  notify_fail("Was wollt Ihr untersuchen?\n");
  if (!str) {
    if (!last_det || last_det=="") return 0;
    str=last_det;
    write("(Ihr wollt wohl '"+str+"' untersuchen.)\n");
  }
  erg=examine_parse(str, "GetDetail");
  if (!erg) 
    return 0;
  if (!stringp(erg[1])) 
    erg[1]=erg[0]->long(str);
  if (see!=2)
  {
    write("Ihr koennt das nicht so genau erkennen.\n");  
    return 1;
  }
  erg[1]=break_string(erg[1]);
  if (IS_LEARNING(ME)) erg[1]=colorize_details(erg[1], erg[0]);
  write(erg[1]);

  if (interactive(erg[0]) && erg[0]!=ME)
    tell_object(erg[0], capitalize(ME->name(WER))+
        " betrachtet Euch eingehend.\n");
  last_det=str;
  return 1;
}

varargs int look_into(string str,int mode)
{
  object *found_obs;

  if(!ME->CanSee()) return 1;
  notify_fail("Wo wollt Ihr denn reinschauen ?\n");
  found_obs = select_objects(str, 0, 2);
  if (!found_obs)
  {
    if (environment() &&
        (environment()->GetDetail(str)||environment()->GetDoorDesc(str)))
      notify_fail("Da koennt Ihr so nicht reinsehen.\n");
      return 0;
  }
  return _examine(str, mode);
}

/* Gebe die Umgebung des aktiven Spielers zurueck, lasse dabei  */
/* rekursiv geschachtelte Raeume zu.                            */
/* Wenn allow_short 0 ist, so wird immer die long-descr benutzt */
varargs string env_descr(int allow_short, int pure_short)
{
  object env;
  int brief;

  env = environment(ME);

  if(!env)
    return "Du schwebst im Nichts ... Du siehst nichts, rein gar nichts ...\n";

  if (!allow_short) {
    if (IS_LEARNING(ME)) return colorize_details(env->int_long(ME, ME), env);
    return env->int_long(ME,ME);
  }
  if (pure_short) return env->get_pure_short(ME,ME);
  if ((brief=QueryProp(P_BRIEF))<=0) {
    if (IS_LEARNING(ME)) return colorize_details(env->int_long(ME, ME), env);
    return env->int_long(ME,ME);
  }
  if (brief>=2) return "";
  return env->int_short(ME,ME);
}

int _look(string str)
{
  string s;
  string d1,d2;
  int i;

  if(!str)
  {
    if(!ME->CanSee()) return 1;
    write(env_descr());
    return 1;
  }
  if (sscanf(str,"%s %s %s %s",s,d1,d2,d1)==4 || sscanf(str,"%s %s %s",s,d1,d2)==3)
    i=_examine(str);
  else {
    if (sscanf(str,"%s an",s)) str=s;
    if (sscanf(str,"in %s",s)) i=look_into(s);
    else i=_examine(str);
  }
  if (i) last_det=str;
  return i;
}

// Diese Fun findet ein Obj, welches mit einer komplexen Syntax beschrieben
// wurde (zB ein Detail an einem Object oder ein Object in einem Behaelter)
// Returnwert: ({ obj, string Detailbeschreibung }) oder NULL
// Detailbeschreibung ist nur gesetzt, wenn ein Detail referenziert wurde.
// Wird NULL geliefert, so wurde notify_fail sinnvoll gesetzt.
// det_fun ist die Funktion fuer zu verwendende Details (zB GetDetail).
private mixed* examine_parse(string str, string det_fun) {
	string was, wo, praep, det;
	int nr, nr2, raum;
	object ob, ob2, env, *obs;
	str=implode(efun::explode(str, " ")-({""}), " "); // Multiblanks entfernen
	if ((sscanf(str,"%s %d %s %s", was, nr, praep, wo)==4 ||
		sscanf(str,"%s %s %s", was, praep, wo)==3) &&
		member_array(praep, ({"an","in","auf","von","vom","am"}))!=-1) {
		if (nr>0) was+=" "+nr;
		ob=present(wo);
		if (!ob && wo=="raum") ob=environment();
		if (!ob) {
			notify_fail(capitalize(wo)+"? So etwas findet Ihr hier nicht.\n");
			return 0;
		}
                if (ob && ob==environment()) raum=1;
                else wo=0;
		if (praep=="in" && (ob->QueryProp(P_CONTAINER) || raum)) {
			if (ob->QueryProp(P_CNT_STATUS)!=CNT_STATUS_OPEN) {
				// Ich hoffe die Flags werden nie gaendert. So ist auch
				// bei nichtvorhandensein der Prop das Obj offen.
				notify_fail(capitalize(ob->name(WER,1))+" ist geschlossen.\n");
				return 0;
			}
			ob2=present(was, ob);
			if (!ob2) {
				if (raum) { // Noch Raumdetails pruefen (unt det in raum)
					if (det=call_other(ob, det_fun, was, wo))
						return ({ ob, det });
					notify_fail("So etwas seht Ihr hier nicht.\n");
				} else notify_fail("So etwas ist nicht in "+ob->name(WEM,1)+".\n");
				return 0;
			}
			return ({ ob2, 0 });
		}
		if (praep=="auf" && ob->QueryProp(P_TRAY)) {
			ob2=present(was, ob);
			if (!ob2) {
				notify_fail("So etwas ist nicht auf "+ob->name(WEM,1)+".\n");
				return 0;
			}
			return ({ ob2, 0 });
		}
		if (det=call_other(ob, det_fun, was)) return ({ ob, det });
		notify_fail("So etwas koennt Ihr "+
			(raum ? "hier" : ((wo=ob->name(WEM,1)) ? "an "+wo : "dort"))+
			" nicht entdecken.\n");
		return 0;
	}
	// Triviale Syntaxen pruefen
	// Erst reale Objecte
	obs=select_objects(str, 0, 2); // Object suchen; erst in uns, dann env
	if (nr=sizeof(obs)) {
		for (nr2=0; nr2<nr; nr2++) {
			if (!obs[nr2]->short() && !obs[nr2]->QueryProp(P_PLURAL)) {
				obs[nr2]=0; // unsichtbare entfernen
				continue;
			}
			env=environment(obs[nr2]);
			if (env==environment() || env=ME || environment()==obs[nr2])
				return ({ obs[nr2], 0 });
		}
		obs-=({0});
		if (sizeof(obs)) {
			notify_fail("Da kommt Ihr so nicht nah genug heran.\n");
			return 0;
		}
	}
	// Jetzt Details suchen...
	if (det=call_other(environment(), det_fun, str)) // Raumdetail
		return ({ environment(), det });
	obs=all_inventory(environment())+spec_inventory(ME); // Det in Raum oder uns
	for (nr=sizeof(obs), nr2=0; nr2<nr; nr2++)
		if (det=call_other(obs[nr2], det_fun, str)) return ({ obs[nr2], det });
	if (det=environment()->GetDoorDesc(str))
		return ({ environment(), det });
	notify_fail("So etwas koennt Ihr hier nicht finden.\n");
	return 0;
}

// Funktion sucht nach Auftreten von Schluesselworten von P_(SPECIAL_)DETAILS
// des Objektes what im String str und faerbt entsprechend
private static string colorize_details(string str, object what) {
	int i;
	string* dets, *strs;
	mapping map;
	map=what->QueryProp(P_DETAILS);
	if (mappingp(map)) dets=m_indices(map);
	else dets=({});
	if (!sizeof(dets)) return str;
	dets=regexp(dets, "^[a-zA-Z0-9 ]*$"); // Alles raus ausser normale Woerter
	dets+=map_array(dets, #'capitalize); // Auch Grossschreibweise
	strs=regexplode(str, implode(dets,"|"));
	i=sizeof(strs);
	if (i<=1) return str; // Keine Matches
	if (!(--i&1)) i--; // i muss ungerade sein
	for (; i>0; i-=2) strs[i]=colorize(strs[i], CG_DETAILS);
	return implode(strs, "");
}

/* Riechen und Lauschen, je nach Flag */
int _smell(string str, int sound) {
	mixed msg, *erg;
	string me, other, was, verb, verb2, prop1, prop2, det_fun;
	if (sound) {
		if (!ME->CanHear()) return 1;
		prop1=P_SOUND;
		prop2=P_SOUND_DETAILS;
		verb="lausch";
		verb2="hoer";
		det_fun="GetSoundDetail";
	} else {
		if (member_array(query_verb(),({"riech","rieche"}))==-1) return 0;
		if (!ME->CanSmell()) return 1;
		prop1=P_SMELL;
		prop2=P_SMELL_DETAILS;
		verb2=verb="riech";
		det_fun="GetSmellDetail";
	}
	if (!str) { // Also einfach so im Raum mal...
		msg=funcall(environment()->QueryProp(prop1));
		if (!msg && m_sizeof(environment()->QueryProp(prop2))) {
			// Schauen, obsn Detail gibt...
			if (verb=="lausch") msg="Wem oder was willst Du lauschen?";
			else msg="Wen oder was willst Du riechen?";
		}
	} else { // An Object riechen/lauschen
		str=lower_case(str);
		if (sscanf(str,"an %s", was)==1) str=was;
		else if (sscanf(str,"am %s", was)==1) str=was;
		was=0;
		erg=examine_parse(str, det_fun);
		if (!erg) {
			erg=examine_parse(str, "GetDetail"); // Gibts evt ein Det dazu?
			if (!erg) return 0;
			erg[1]="Du "+verb2+"st nichts besonderes.\n"; // dann sinnvolle Msg
		}
		if (erg[1]) {
			msg=erg[1];
			if (erg[0]==environment()) was="irgendetwas";
			else if (erg[0]==ME) was="sich selbst";
			else was=erg[0]->name(WEM);
		} else {
			msg=funcall(erg[0]->QueryProp(prop1));
			if (erg[0]!=ME) was=erg[0]->name(WEM);
			else was="sich selbst";
		}
	}
	if (stringp(msg)) me=msg;
	else if (pointerp(msg)) {
		me=msg[0];
		other=msg[1];
	} else me="Du "+verb2+"st nichts besonderes.\n";
	if (!other) {
		if (was) other=capitalize(ME->name(WER))+" "+verb+"t an "+was+".\n";
		else other=capitalize(ME->name(WER))+" "+verb+"t umher.\n";
	}
	write(break_string(parse_mess(me)));
	if (erg && interactive(erg[0]) && erg[0]!=ME) {
		say(break_string(parse_mess(other)),
			erg[0]);
		tell_object(erg[0], capitalize(ME->name(WER))+" "+verb+"t an Dir.\n");
	} else say(break_string(parse_mess(other)));
	return 1;
}

int _sound(string str) {
	if (member_array(query_verb(), ({"hoer","hoere","lausch","lausche",
		"horch","horche"}))==-1) return 0;
	return _smell(str, 1);
}

int _read(string str) {
	mixed* erg, msg;
	string me, other, was;
	if (member_array(query_verb(), ({"lies","les","lese"}))==-1) return 0;
	if (!ME->CanSee()) return 1;
	notify_fail("Was willst Du denn lesen?\n");
	if (!str) return 0;
	str=lower_case(str);
	erg=examine_parse(str, "GetReadDetail");
	if (!erg) {
		if (examine_parse(str, "GetDetail"))
			notify_fail("Das kannst Du nicht lesen.\n");
		return 0;
	}
	if (erg[1]) {
		msg=erg[1];
		if (erg[0]==environment()) was="irgendetwas";
		else if (erg[0]==ME) was="an sich selbst";
		else was=erg[0]->name(WEN);
	} else {
		msg=funcall(erg[0]->QueryProp(P_READ_MSG));
		if (erg[0]!=ME) was=erg[0]->name(WEN);
		else was="an sich selbst";
	}
	if (stringp(msg)) me=msg;
	else if (pointerp(msg)) {
		me=msg[0];
		other=msg[1];
	} else {
		notify_fail("Du findest dort nichts zum Lesen.\n");
		return 0;
	}
	if (!other && was)
		other=capitalize(ME->name(WER))+" liest "+was+".\n";
	write(break_string(parse_mess(me)));
	if (interactive(erg[0]) && erg[0]!=ME) {
		say(break_string(parse_mess(other)),
			erg[0]);
		tell_object(erg[0], capitalize(ME->name(WER))+" liest an Dir.\n");
	} else say(break_string(parse_mess(other)));
	return 1;
}

// Idee fuer 'wegs' aus Gums Gtool
int _wegs(string str) {
	object* p;
	string* w;
	int i;
	if (str) {
		notify_fail("Keine Argumente bei 'wegs' erlaubt.\n");
		return 0;
	}
	p=users();
	w=({});
	for (i=sizeof(p); i--;) {
		if (!p[i]->QueryProp(P_NAME)) continue; // Unfertigfes Spielerobj
		if (p[i]->QueryProp(P_INVIS)) continue;
		str=p[i]->QueryProp(P_AWAY);
		if (!stringp(str)) continue;
		w+=({ sprintf("  %:-14s: %:-60s\n", p[i]->name(WER), str) });
	}
	if (!(i=sizeof(w))) {
		write("Es ist niemand als abwesend gekennzeichnet.\n");
		return 1;
	}
	w=sort_array(w, #'>);
	write("Abwesend "+(i>1?"sind":"ist")+":\n"+implode(w, ""));
	return 1;
}

// Idee fuer 'idles' aus Gums Gtool
int _idles(string str) {
	object* p;
	string* s;
	int i, j;
	if (str) {
		notify_fail("Keine Argumente bei 'wegs' erlaubt.\n");
		return 0;
	}
	p=users();
	s=({});
	for (i=sizeof(p); i--;) {
		if (!p[i]->QueryProp(P_NAME)) continue; // Unfertigfes Spielerobj
		if (p[i]->QueryProp(P_INVIS)) continue;
		j=query_idle(p[i]);
		if (j<60) continue;
		if (j<=3600)
			s+=({ sprintf("  %:-14s: %:3d:%:02d:%:02d\n", p[i]->name(WER),
				j/3600, (j%=3600, j/60), (j%60, j)) });
	}
	if (!(i=sizeof(s))) {
		write("Es ist zur Zeit niemand idle.\n");
		return 1;
	}
	s=sort_array(s, #'>);
	write("Es "+(i>1?"sind":"ist")+" gerade idle:\n"+implode(s, ""));
	return 1;
}

int _equipment(string str)
{
  mapping armours;
  int i,j;
  string * lines, * ind,* list,txt;
  
  if (str)  
  {
    notify_fail("'ausruestung' akzeptiert keine Argumente.\n");
    return 0;
  }
  armours=QueryProp(P_ARMOURS);
  lines=({});
  txt="|";
  for (i=0;i<sizeof(ind=m_indices(armours));i++)
  {
    list=({});
    for (j=0;j<4 && armours[ind[i],j]!=0;j++)
      list+=({armours[ind[i],j]->name()});
    if (sizeof(list))
      txt+=break_string(implode(list,", ")+".",
                 74,ind[i]+": ",BS_FOR_COMM);
    else
      txt+=sprintf("%:74-s\n",ind[i]+": keine");
  }

  txt=implode(explode(txt,"\n")," |\n| ");  
            
  printf(
    "+--- Ausruestung -----------------------------------------------------------+\n"
    "|                                                                           |\n"
    "| Waffe(n):     %s |\n"
    "%s\n"
    "|                                                                           |\n"
    "+---------------------------------------------------------------------------+\n"
    ,sprintf("%:59-s",sizeof(QueryProp(P_WEAPONS))?
                        implode(map_objects(QueryProp(P_WEAPONS),"name"),", "):"keine")
    ,txt
    );
}

static string *_query_localcmds()
{
  return
    ({({"i","_inventory",0,0}),
      ({"inv","_inventory",0,0}),
      ({"inventur","_inventory",0,0}),
      ({"ausruestung","_equipment",0,0}),
      ({"geld","geld",0,0}),
      ({"schau","_look",0,0}),
      ({"unt","_examine",0,0}),
      ({"untersuch","_examine",0,0}),
      ({"untersuche","_examine",0,0}),
      ({"betracht","_examine",0,0}),
      ({"betrachte","_examine",0,0}),
      ({"betr","_examine",0,0}),
      ({"kurz","_toggle_brief",0,0}),
      ({"blindflug", "_toggle_brief",0,0}),
      ({"lang","_toggle_brief",0,0}),
      ({"hoer","_sound",1,0}),
      ({"horch","_sound",1,0}),
      ({"lausch","_sound",1,0}),
      ({"riech","_smell",1,0}),
      ({"lies","_read",0,0}),
      ({"les","_read",1,0}),
      ({"wegs","_wegs",0,1}),
      ({"idles","_idles",0,1}),
      });
}
