/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: post.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
//
// STD/POST.C -- Standard-Post
//
// Author: Loco@MorgenGrauen
//
// based on Wunderland Mudlib
//
// $Log: post.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:13  en
// MUDLib CVS Preperation
//

inherit "std/room";

#include "/mail/post.h"
#include <properties.h>

#pragma strong_types

void create() {
  ::create();
  SetProp(P_INT_SHORT,"Postamt");
  SetProp(P_INT_LONG,"Dies ist ein Testpostamt.\n"
    "Von hier aus kannst Du Briefe an Deine Mitspieler schicken und Briefe von "
    "ihnen lesen. Wenn Du das willst, tippe 'post' oder 'mail', "
    "bzw. 'mail <spieler>'.");
  SetProp(P_LIGHT, 1);
  SetProp(P_INDOORS, 1);
  AddCmd("post","do_mail");
  AddCmd("mail","do_mail");
}

int do_mail(string str) {
  object mailer;
  if(this_interactive()!=this_player())
    return 0;
  mailer=clone_object(MAILER);
  mailer->SetOfficeName(QueryProp(P_INT_SHORT));
  mailer->do_mail(str);
  return 1;
}
