/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: pub.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// M.D. MUDlib
// basierend auf der Wunderland MUDlib
//
// /STD/PUB.C --- Das Standardobjekt fuer gastronomische Einrichtungen
//
// $Log: pub.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:13  en
// MUDLib CVS Preperation
//
// Revision 1.2  1999/09/07 12:03:42  Largo
// BS_STDLEN entfernt
//
// Revision 1.1  1999/08/05 00:04:51  Largo
// Initial revision
//

#pragma strong_types

inherit "std/room";
inherit "std/trade";

#include <rooms.h>
#include <properties.h>
#include <defines.h>

private static mixed* food;
private static mixed* drink;

void create()
{
	room::create();

	SetProp(P_LIGHT, 1);
	SetProp(P_INDOORS, 1);
	SetProp(P_INT_SHORT, "Ein Lokal");
	SetProp(P_INT_LONG, "Der Magier, der diesen Pub erschuf, war leider zu faul,"
		" eine Beschreibung dafuer herzustellen.");
	SetProp(P_COINMASTER, "/obj/coinmaster_WL");
	SetProp(P_TRADER_NEEDED, 0);

	AddCmd("menue", "menue");
	AddCmd("kauf|kaufe|bestell|bestelle", "bestelle");

	food  = ({});
	drink = ({});

	AddItem("/obj/listenbuch", REFRESH_REMOVE);
}

void AddFood(string Name, mixed Ids, int Price, int Heal, mixed Function)
{
	if (!stringp(Name) || !strlen(Name) || !intp(Heal)) return;
	if (!intp(Price) || (Price < 1)) return;
	if (!pointerp(Ids) && (!stringp(Ids) || !strlen(Ids))) return;
	if (!stringp(Function) && !closurep(Function) && !pointerp(Function)) return;
	if (pointerp(Function) && (sizeof(Function) != 2)) return;

	if (stringp(Ids)) Ids = ({Ids});

	food += ({({Name, Ids, Price, Heal, Function})});
}

void AddDrink(string Name, mixed Ids, int Price, int Heal, int Alk, int Soak, mixed Function)
{
	if (!stringp(Name) || !strlen(Name) || !intp(Alk)) return;
	if (!intp(Soak) || !intp(Price) || (Price < 1) || !intp(Heal)) return;
	if (!pointerp(Ids) && (!stringp(Ids) || !strlen(Ids))) return;
	if (!stringp(Function) && !closurep(Function) && !pointerp(Function)) return;
	if (pointerp(Function) && (sizeof(Function) != 2)) return;

	if (stringp(Ids)) Ids = ({Ids});

	drink += ({({Name, Ids, Price, Heal, Alk, Soak, Function})});
}

int menue(string arg)
{
	int i;
	mixed *items, *tmp1, *tmp2;
	object CoinMaster;

	CoinMaster = GetActiveCM();

	if (!objectp(CoinMaster))
	{
		tell_object(this_player(), "Ein Fehler ist aufgetreten. Bitte benachrichtige"
			" einen Magier!\n");

		return 1;
	}

	items = ({});

	tmp1 = filter(drink, lambda(({'x}), ({#'>, ({#'[, 'x, 4}), 0})));
	tmp2 = drink - tmp1;

	if (sizeof(tmp2))
	{
		items += ({({"Alkoholfreie Getraenke"})});

		for (i = sizeof(tmp2); i--;) items += ({({tmp2[i][0], tmp2[i][2]})});
	}

	if (sizeof(tmp1))
	{
		if (sizeof(items)) items += ({({0})});

		items += ({({"Alkoholhaltige Getraenke"})});

		for (i = sizeof(tmp1); i--;) items += ({({tmp1[i][0], tmp1[i][2]})});
	}

	if (sizeof(food))
	{
		if (sizeof(items)) items += ({({0})});

		items += ({({"Speisen"})});

		for (i = sizeof(food); i--;) items += ({({food[i][0], food[i][2]})});
	}

	this_player()->More(MakePriceList("Preisliste", "#", 3, items, 0));

	return 1;
}

static mixed* CheckCash(int price, string traderstr)
{
	object CoinMaster;
	mixed* zahl;

	CoinMaster = GetActiveCM();

	if (!objectp(CoinMaster))
	{
		tell_object(this_player(), "Ein Fehler ist aufgetreten. Bitte benachrichtige"
			" einen Magier!\n");

		return 0;
	}

	zahl = CoinMaster->PayCash(this_player(), price);

	if (!pointerp(zahl))
	{
		tell_object(this_player(), break_string(sprintf("Das wuerde %s kosten, und"
			" Du hast %s.", CostStr(price), (CoinMaster->QueryMoney(this_player()) < 1 ?
			"leider garnix" : "nur " + CostStr(CoinMaster->QueryMoney(this_player())))),
			0, traderstr + " sagt: "));

		return 0;
	}

	return zahl;
}

static int drink_drink(mixed a_drink, string traderstr)
{
	int heal, price, soak, strength, nsoak, nalc;
	object CoinMaster;
	mixed *zahl;

	price    = a_drink[2];
	heal     = a_drink[3];
	strength = a_drink[4];
	soak     = a_drink[5];

	zahl = CheckCash(price, traderstr);

	if (!pointerp(zahl)) return 1;

	nsoak = this_player()->QueryProp(P_DRINK) + soak;
	nalc = this_player()->QueryProp(P_ALCOHOL) + strength;

	if (nsoak > this_player()->QueryProp(P_MAX_DRINK))
	{
		tell_object(this_player(), "Nee, so viel kannst Du momentan echt nicht trinken.\n");
		return 1;
	}
	else	if (nalc > this_player()->QueryProp(P_MAX_ALCOHOL))
		{
			tell_object(this_player(), "So ein Pech, Du hast alles verschuettet.\n");
			return 1;
		}

	this_player()->drink_soft(soak);
	this_player()->drink_alcohol(strength);
	this_player()->heal_self(heal);

	CoinMaster = GetActiveCM();

	CoinMaster->DoPurchase(zahl, this_player());

	if(!zahl[1] || !mappingp(zahl[1]) || !m_sizeof(zahl[1]))
		tell_object(this_player(), break_string(sprintf("Du bezahlst %s.",
			SpecCostStr(zahl[0]))));
	else
		tell_object(this_player(), break_string(sprintf("Du bezahlst %s und"
			" bekommst %s zurueck.", SpecCostStr(zahl[0]), SpecCostStr(zahl[1]))));

	if (closurep(a_drink[6])) funcall(a_drink[6]);
	else
	{
		if (stringp(a_drink[6]) && function_exists(a_drink[6], this_object()))
			call_other(this_object(), a_drink[6],0);
		else
		{
			tell_object(this_player(), break_string(parse_mess(a_drink[6][0])));
			tell_room(this_object(), break_string(parse_mess(a_drink[6][1])),
				({this_player()}));
		}
	}

	return 1;
}

static int eat_food(mixed a_food, string traderstr)
{
	int heal, price, nfood;
	object CoinMaster;
	mixed *zahl;

	price    = a_food[2];
	heal     = a_food[3];

	zahl = CheckCash(price, traderstr);

	if (!pointerp(zahl)) return 1;

	nfood = this_player()->QueryProp(P_FOOD) + heal;
	
	if (nfood > this_player()->QueryProp(P_MAX_FOOD))
	{
		tell_object(this_player(), "Das ist viel zu viel fuer Dich! Wie waers mit etwas leichterem?\n");
		return 1;
	}
	
	this_player()->eat_food(heal);
	this_player()->heal_self(heal);

	CoinMaster = GetActiveCM();

	CoinMaster->DoPurchase(zahl, this_player());

	if(!zahl[1] || !mappingp(zahl[1]) || !m_sizeof(zahl[1]))
		tell_object(this_player(), break_string(sprintf("Du bezahlst %s.",
			SpecCostStr(zahl[0]))));
	else
		tell_object(this_player(), break_string(sprintf("Du bezahlst %s und"
			" bekommst %s zurueck.", SpecCostStr(zahl[0]), SpecCostStr(zahl[1]))));

	if (closurep(a_food[4])) funcall(a_food[4]);
	else
	{
		if (stringp(a_food[4]) && function_exists(a_food[4], this_object()))
			call_other(this_object(), a_food[4],0);
		else
		{
			tell_object(this_player(), break_string(parse_mess(a_food[4][0])));
			tell_room(this_object(), break_string(parse_mess(a_food[4][1])),
				({this_player()}));
		}
	}

	return 1;
}

int bestelle(string arg)
{
	int i, found;
	object trader;
	string traderstr;

	if (QueryProp(P_TRADER_NEEDED))
	{
		if (!(trader = FindTrader()))
		{
			QueryProp(P_TRADER_GENDER) == FEMALE ?
				notify_fail("Hier ist keine Haendlerin, die Dir was verkaufen koennte.\n") :
				notify_fail("Hier ist kein Haendler, der Dir was verkaufen koennte.\n");

			return 0;
		}
		else	if (this_player() && trader->IsEnemy(this_player()))
			{
				QueryProp(P_TRADER_GENDER) == FEMALE ?
					notify_fail("Deine Feindin wird Dir kaum etwas verkaufen.\n") :
					notify_fail("Dein Feind wird Dir kaum etwas verkaufen.\n");

				return 0;
			}

		traderstr = capitalize(trader->name(WER, 2));
	}
	else	if (QueryProp(P_TRADER_GENDER) == FEMALE) traderstr = "Die Haendlerin";
		else traderstr = "Der Haendler";

	i     = 0;
	found = -1;

	notify_fail(break_string("Was willst Du denn ueberhaupt bestellen?",
		0, traderstr + " fragt: "));

	if (!stringp(arg) || !strlen(arg)) return 0;

	arg = lower_case(arg);

	notify_fail(break_string("Tut mir leid, das fuehren wir nicht! Wir sind ein"
		" anstaendiges Lokal!", 0, traderstr+" meint: ", BS_FOR_COMM));

	while ((i < sizeof(drink)) && (found < 0))
	{
		found = member_array(arg, drink[i][1]);

		i++;
	}

	if (found >= 0) return drink_drink(drink[--i], traderstr);

	if (!sizeof(food)) return 0;

	i = 0;

	while ((i < sizeof(food)) && (found < 0))
	{
		found = member_array(arg, food[i][1]);

		i++;
	}

	if (found >= 0) return eat_food(food[--i], traderstr);

	return 0;
}

mixed QueryDrinks()
{
	return drink + ({});
}

mixed QueryFood()
{
	return food + ({});
}
