/*******************
** Eldarea MUDLib **
********************
**
** /std/room - basic room object
**
** CVS DATA
** $Date: 2001/02/08 16:03:50 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: room.c,v $
** Revision 1.3  2001/02/08 16:03:50  elatar
** changed message() to varargs
**
** Revision 1.2  2000/12/04 11:14:54  elatar
** message() implemented
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

inherit "std/thing/properties";
inherit "std/thing/language";
inherit "std/room/moving";
inherit "std/room/restrictions";
inherit "std/room/description";
inherit "std/room/exits";
inherit "std/room/commands";
inherit "std/room/items";
inherit "std/room/newdoors";
inherit "std/room/doors";

#define NEED_PROTOTYPES

#include <thing/properties.h>
#include <config.h>
#include <properties.h>
#include <rooms.h>
#include <wizlevels.h>
#include <moving.h>
#include <defines.h>
#include <doors.h>
#include <doorroom.h>
#include <functionlist.h>

void _create() {
  seteuid(getuid(this_object()));
  properties::create();
  restrictions::create();
  description::create();
  exits::create();
  items::create();
  commands::create();
  newdoors::create();
  doors::create();

  SetProp(P_NAME,0);
  SetProp(P_NAME_ADJ,({}));
  Set(P_LONG,0);
  Set(P_TRANSPARENT,0);
  Set(P_ADJECTIVES,({}));
  Set(P_IDS,({}));
  Set(P_WEIGHT,PROTECTED,F_MODE);
  Set(P_TOTAL_WEIGHT,PROTECTED,F_MODE);
  Set(" clean counter ",2);
}

void maybe_replace_program() {
  string *list, first;
  object first_ob;

  first_ob=find_object(first=(list=inherit_list(this_object()))[1]);
  if(object_name()=="/std/room" ||
      !(first_ob=find_object(first=(list=inherit_list(this_object()))[1])) ||
      (sizeof(list)!=1+sizeof(inherit_list(first_ob))) ||
      (1!=sizeof(list=functionlist(this_object(),
				   RETURN_FUNCTION_NAME|NAME_INHERITED))) ||
      list[0]!="create")
    return;
  replace_program(first);
}

void create() {
  maybe_replace_program();
  _create();
}

private static int check_clean_count() {
  int cc;
  if(sizeof(map_objects(all_inventory(), "QueryProp", P_TRANSPORT)-({0})))
    return 0; // Nix machen, wenn Transporter im Raum
  cc=Query(" clean counter ");
  if (--cc<=0)
    return 1;
  Set(" clean counter ",cc);
  return 0;
}
  
int clean_up(int arg) {
  mixed itema;
  object me;
  
  if(arg>1) return 1; // better not ;)
  if (Query(" never clean ")) return 0;

  // if there are any item we have produced ourselfes check them

  if(pointerp(itema = QueryProp(P_ITEMS))) {
    mixed names;
    int i;
    i = sizeof(names = all_inventory(this_object()));
    while(i--) {
      if (query_once_interactive(names[i])) {
	Set(" clean counter ",2);
	return 1;
      }
      if(objectp(names[i])) names[i] = load_name(names[i]);
    }
    
    for(i = sizeof(itema)-1; i >= 0; i--) {
      // Semantik:
      // 1. Wenn RITEM_OBJECT ein array ist, kann evtl ge'clean'ed werden.
      // 2. Wenn es ein REFRESH_NONE Item ist und es entweder nicht mehr
      //    existiert oder nicht in diesem Raum ist, kein clean_up (es
      //    wuerde beim neuladen des Raumes ja wieder erzeugt;
      //    falls es aber hier ist, wird es mitvernichtet, dann ists ok)
      // 3. Wenn es ein REFRESH_DESTRUCT ist und noch existiert, aber nicht
      //    hier ist, KEIN clean_up.
      if (!pointerp(itema[i][RITEM_OBJECT]) &&
	  ((itema[i][RITEM_REFRESH] == REFRESH_NONE && (!itema[i][RITEM_OBJECT]
          || environment(itema[i][RITEM_OBJECT])!=this_object())) ||
	  (itema[i][RITEM_REFRESH] == REFRESH_DESTRUCT &&
	  itema[i][RITEM_OBJECT] && environment(itema[i][RITEM_OBJECT]) !=
          this_object())))
	return 1;
      names -= (pointerp(itema[i][RITEM_FILE]) ?
		itema[i][RITEM_FILE] : ({ itema[i][RITEM_FILE] }));
    } // end for

    // if there are objects left in the room do not clean up but try again later
    if(sizeof(names) && !check_clean_count())
      return 1;
  }
  else // is there any object lying around?
    if(first_inventory() && !check_clean_count())
      return 2;
  
  me = this_object();
  me->remove(); // mit late binding !
  if(me) destruct(me); // auf jeden fall sterben !
}

void init() {
  Set(" clean counter ",2);
  exits::init();
  commands::init();
  description::init();
  newdoors::init();
  doors::init();
}

void reset() {
  if(object_name()=="/std/room")
    return;
  items::reset();
  newdoors::reset();
  doors::reset();
}

/** Didnt know a better place, didnt want to create a new module *sigh* */
varargs void message(int flags, mixed msg, mixed exclude)
{
  object * lv;
  int i;
  
  if (!pointerp(exclude))
    exclude=({exclude});
    
  lv=filter_array(all_inventory(),#'living);
  lv-=exclude;
  
  for (i=sizeof(lv);i-->0;)
    lv[i]->message(flags, msg);
}

///////////////////// Query/Setmethoden ///////////////////////

static int _query_noget() {
  return 1;
}


