/*******************
** Eldarea MUDLib **
********************
**
** td/room/description.c - room description handling
**
** CVS DATA
** $Date: 2001/02/22 12:30:22 $
** $Revision: 1.7 $
**
** longdesc
**
** CVS History
**
** $Log: description.c,v $
** Revision 1.7  2001/02/22 12:30:22  elatar
** daytime lights default changed (last time hopefully)
** door descriptions removed from long()
**
** Revision 1.6  2001/02/08 16:04:14  elatar
** implemented dusk and dawn sequences
**
** Revision 1.5  2001/01/31 13:42:20  elatar
** process_string() replaced by funcall()
**
** Revision 1.4  2001/01/31 13:12:27  elatar
** clock include changed
**
** Revision 1.3  2000/12/04 11:07:54  elatar
** new color handling adapted
**
** Revision 1.2  1999/11/08 16:26:34  elatar
** just adapted
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

inherit "std/container/description";

#define NEED_PROTOTYPES

#include <properties.h>
#include <defines.h>
#include <wizlevels.h>
#include <doorroom.h>
#include <doors.h>
#include <thing/details.h>
#include <clock.h>
#include <color.h>
#include <living/comm.h>

private static mapping door_details;
private static int first, last;

void create() 
{
  description::create();
  door_details = ([ ]);
  SetProp(P_INT_SHORT, "<namenloser Raum>");
  SetProp(P_INT_LONG, 0);
  SetProp(P_INT_LONG_NIGHT, 0);
  SetProp(P_INT_LONG_ILUM, 0);
  SetProp(P_ROOM_MSG, ({ ({}), ({}) }) );
  SetProp(P_DAYTIME_LIGHTS,({3,4,3,1}));
}

void init() 
{
  mixed roommsg;
  if(find_call_out("WriteRoomMessage") == -1)
    if ((roommsg = QueryProp(P_ROOM_MSG)) && sizeof(roommsg[0])) 
    {
      first = 0;
      last = 0;
      call_out("WriteRoomMessage", 0);
    }
}

// dusk and dawn sequences. these functions are called by the mud clock
void DuskDawn(int zone, int state, int seq)
{
  string * sequence;
  
  if (zone!=QueryProp(P_TIMEZONE))
    return;
    
  if (state)
    sequence = QueryProp(P_DUSK_SEQ);
  else
    sequence = QueryProp(P_DAWN_SEQ);

  if (pointerp(sequence) && sizeof(sequence)==7 && stringp(sequence[seq]))
    this_object()->message(MSG_OPTIC,break_string(sequence[seq]));
}

/* Random messages in rooms */

void AddRoomMessage(mixed mesg, int delay) 
{
  mixed roommsg;

  if (delay <= 0) return;
  if (delay < 15) delay = 15;

  if (!pointerp(mesg)) mesg = ({mesg});

  roommsg = QueryProp(P_ROOM_MSG);

  if (assoc(delay, roommsg[0]) == -1)
    roommsg = insert_alist(delay, mesg, roommsg);
  else
    roommsg[1][assoc(delay, roommsg[0])] += ({mesg});
  SetProp(P_ROOM_MSG, roommsg);
}

void RemoveRoomMessage(mixed arg) 
{
  mixed roommsg;
  int pos, i;
  
  if (!sizeof(roommsg = QueryProp(P_ROOM_MSG))) return;

  if (!arg) 
  {
    SetProp(P_ROOM_MSG, ({ ({}), ({}) }));
    return;
  }

  if (intp(arg)) 
  {
    if ((pos = assoc(arg, roommsg[0])) == -1) return;
    roommsg[0] -= ({roommsg[0][pos]});
    roommsg[1] -= ({roommsg[1][pos]});
    SetProp(P_ROOM_MSG, roommsg);
    return;
  }
  
  if (!pointerp(arg)) arg = ({arg});
  for (i = sizeof(roommsg[1])-1; i >= 0; --i) 
  {
    roommsg[1][i] -= arg;
    if (!sizeof(roommsg[1][i])) {
      roommsg[0] -= ({roommsg[0][i]});
      roommsg[1] -= ({roommsg[1][i]});
    }
  }
  SetProp(P_ROOM_MSG, roommsg);
}

static void _out_msg(int delay, mixed roommsg, int t) 
{
  int tmp;
  mixed *entry, msg;

  if ((tmp = t/delay)>0 && (last<(tmp *= delay)) && (tmp<=t)) 
  {
    entry = roommsg[1][assoc(delay, roommsg[0])];
    msg = entry[random(sizeof(entry))];
    tell_room(ME, break_string( funcall(msg) ) );
  }
}

static void WriteRoomMessage() 
{
  int *delays, nc, i, t, tmp;
  mixed roommsg;

  t = time()-first;
  while(remove_call_out("WriteRoomMessage") != -1);

  if(!(roommsg = QueryProp(P_ROOM_MSG)) || !sizeof(delays = roommsg[0]))
    return;

  if(!first) 
  {
    call_out("WriteRoomMessage", delays[0]);
    first = t;
    return;
  }

  map_array(delays, #'_out_msg, roommsg, t);

  for (i = sizeof(delays)-1, nc = delays[0], tmp = 0; i>=0; --i) 
  {
    if ((tmp = ((t+nc)/delays[i]))>0 && t<(tmp *= delays[i]) && tmp<(t+nc))
      nc = tmp-t;
  }

  last = t;
  if (sizeof(filter_array(all_inventory(), #'interactive)))
    call_out("WriteRoomMessage", nc);
}

void exit() 
{
  if(sizeof(filter_array(all_inventory(), #'query_once_interactive)))
    return;
  while (remove_call_out("WriteRoomMessage")!=-1);
}

/* abartiges Door-Detail handling */


void AddDoorDetail(mixed *keys, string *adj, mixed descr) 
{
  int i,j;
  mixed oldadj;

  if(stringp(adj)) adj=({adj});
  if(!adj||!pointerp(adj)) adj=({});
  if(!pointerp(keys)) keys=({keys});
  for(i=sizeof(keys)-1;i>=0;i--)
    if(!(oldadj=door_details[keys[i]]))
      door_details += ([ keys[i] : ([ descr : adj ]) ]);
    else
      if(!(oldadj=door_details[keys[i]][descr]))
	door_details[keys[i]] += ([ descr : adj ]);
      else
	door_details[keys[i]][descr]+=adj;
}

void RemoveDoorDetail(mixed *keys) 
{
  int i;

  if(!keys)
    door_details = ([ ]);
  else if(stringp(keys))
    door_details = m_delete(door_details, keys);
  else
    for(i=sizeof(keys)-1;i>=0;i--)
      door_details = m_delete(door_details, keys[i]);
}

private string MatchDoorDetail(string key) 
{
  int i;
  string *adj,*line,det;
  mapping descrs;
  if(!sizeof((line=efun::explode(key," ")-({}))))
    return 0;
  key=line[<1];
  if(sizeof(line)>1)
    adj=line[0..<2];
  if(!(descrs=door_details[key]))
    return 0;
  line=m_indices(descrs);
  if(!adj||!sizeof(adj))
    return funcall(line[0]);
  for(;sizeof(line);line=line[1..]) {
      for(i=0;i<sizeof(adj);i++)
	if(member_array(adj[i],descrs[line[0]])<0)
	  break;
      if(i==sizeof(adj))
	return funcall(line[0]);
    }
  return 0;
}

// einzig sinnvolle Funktion (aufgerufen von player/viewcmd
string GetDoorDesc(string key) 
{
  int i;
  mixed idx, ds;
  string detail;
  // alte Tueren (NewDoors)
  if(detail=MatchDoorDetail(key))
    return detail;
  // neue Tueren
  if(mappingp(ds=(mapping)QueryProp(P_DOORS)) &&
    i=sizeof(idx=m_indices(ds)))
    for(;i--;)
      if(member(QueryDoorProp(idx[i], P_IDS), key)!=-1)
        return QueryDoorLong(idx[i]);
  return 0;
}

/*
 * new id handling. Details must be handled here, too, so
 * they are found from the player ob.
 */
varargs int id(string str, int lvl) 
{
  int i;
  mixed idx;
  // Vom Container
  if(::id(str))
    return 1;
  // Von den NewDoors/AddDoorDetail und aehnl. Mist
  if(door_details[str])
    return 1;
  // Neue Tueren
  if(i=sizeof(idx=m_indices((mapping)QueryProp(P_DOORS))))
    for(;i--;)
      if(member(QueryDoorProp(idx[i], P_IDS), str)!=-1)
        return 1;
  return 0;
}

///////////////////////////// Raum Aussehen ///////////////////////////////

string int_long(mixed viewer,mixed viewpoint) 
{
  string descr, x_descr;
  int i, l;

  if(l=IS_LEARNING(viewer))
    descr = (string)viewer->colorize("[" + object_name(ME) + "]\n", CG_PATH);
  else
    descr = "";

  x_descr = 0;

  if(UHR->IsNight()) 
  {
    if ( l = QueryInternalLight() 
      && QueryProp(P_LIGHT) < l)
      x_descr = funcall(QueryProp(P_INT_LONG_ILUM));
    if(!x_descr)
      x_descr = funcall(QueryProp(P_INT_LONG_NIGHT));
  }

  if(!x_descr)
     x_descr = funcall(QueryProp(P_INT_LONG));

  if(x_descr)
    descr += x_descr;

  descr = break_string(descr);

  if (i=viewer->QueryProp(P_SHOW_EXITS))
    descr += viewer->colorize((string)ME->GetExits(viewer, i>1),CG_EXITS);

  if(!l)
    x_descr = (string) make_invlist(viewer,
      sort_array(all_inventory()-({ viewpoint }), lambda( ({ 'x, 'y }),
        ({ #'-, ({ #'living, 'y }), ({ #'living, 'x }) }) )));
  else
    x_descr = (string) make_invlist(viewer, all_inventory()-({ viewpoint }));

  if ( x_descr != "" )
    descr += x_descr;

  if( environment() && QueryProp(P_TRANSPARENT) )
    descr += "Ausserhalb seht Ihr:\n"+environment()->int_short(viewer,ME);

  return descr;
}

string show_long() {
  return int_long(this_player(),this_player());
}

string get_pure_short(mixed viewer,mixed viewpoint) {
  string descr;

  descr = funcall(QueryProp(P_INT_SHORT))||"";

  if(IS_LEARNING(viewer))
    descr += (string)viewer->colorize("[" + object_name(ME) + "]\n",CG_PATH);
  else
    descr += ". ";

  if (viewer->QueryProp(P_SHOW_EXITS))
    descr+=GetExits(viewer, 1);

  if(descr[<1]!='\n')
    descr+="\n";

  return descr;
}

string int_short(mixed viewer, mixed viewpoint) {
  string descr, inv_descr;
  int i, l;

  descr = funcall( QueryProp(P_INT_SHORT) )||"";

  if(l=IS_LEARNING(viewer))
    descr += ". "+(string)viewer->colorize("["+object_name(ME)+"]\n",CG_PATH);
  else
    descr += ".\n";

  if((i=viewer->QueryProp(P_SHOW_EXITS)) ||
    (environment(viewer) == ME && viewer->QueryProp(P_BRIEF)))
      descr += (string)ME->GetExits(viewer, i>1);

  if(!l)
    inv_descr = (string) make_invlist(viewer,
      sort_array(all_inventory()-({ viewpoint }), lambda( ({ 'x, 'y }),
        ({ #'-, ({ #'living, 'y }), ({ #'living, 'x }) }) )));
  else
    inv_descr = (string) make_invlist(viewer, all_inventory()-({ viewpoint }));

  if( inv_descr != "" )
    descr += inv_descr;

  return descr;
}

//////////////////////// Query/Setmethoden ///////////////////////////////

static mapping _set_door_details(mapping arg) {
  if (mappingp(arg))
    return door_details = arg;
}

static mapping _query_door_details() {
  return door_details;
}

mixed _set_int_short(mixed arg)
{
  if (stringp(arg))
  {
    if (arg[<1] == '.') arg = arg[0..<2];
  }
  return Set(P_INT_SHORT, arg);
}

string * _query_dusk_seq()
{
  string * seq;
  
  if (!seq = Query(P_DUSK_SEQ))
    if (!QueryProp(P_INDOORS))
      return ({
        "Langsam beginnt der Himmel im Osten heller zu werden."
       ,"Stueck fuer Stueck verblassen die Sterne am Firmament, waehrend "
        "allein der Morgenstern nur noch heller zu strahlen scheint."
       ,"Vom Osten her beginnt sich der Himmel violett zu faerben, der "
        "Morgenstern ist als einziger verblieben."
       ,"Schliesslich verblasst auch der Morgenstern, und der Himmel wird "
        "immer heller."
       ,"Fern im Osten schiebt sich die feuerrote Sonne langsam ueber den "
        "Horizont."
       ,"Langsam steigt die Sonne am Himmel empor und ihre Strahlen tasten "
        "sich durchs Land."
       ,"Schliesslich steht die Sonne hoch am Himmel und taucht das gesamte "
        "Land in ihr helles und warmes Licht."
        });
  return seq;
}

string * _query_dawn_seq()
{
  string * seq;
  
  if (!seq = Query(P_DAWN_SEQ))
    if (!QueryProp(P_INDOORS))
      return ({
        "Die Schatten um Euch werden laenger und laenger, als die Sonne "
        "langsam tiefer sinkt."
       ,"Die letzen Strahlen der Sonne tauchen den Himmel in Schattierungen "
        "von leuchtendem Orange bis zu einem tiefen Violett."
       ,"Unaufhaltsam verschwindet die blutrote Sonne langsam im Westen "
        "hinter dem Horizont."
       ,"Die roetliche Faerbung des Himmels laesst nach, als dieser immer "
        "dunkler wird."
       ,"Hell leuchtend geht der Abendstern am immer dunkler werdenden Himmel "
        "auf."
       ,"Immer mehr Sterne erscheinen funkelnd am Firmament."
       ,"schliesslich ist tiefblaue der Himmel von Myriaden von glitzernden "
        "Sternen uebersaet."
      });
  return seq;
}
