/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: doors.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
//
// STD/ROOM/DOORS.C
//
// $Revision: 1.1.1.1 $
//
// $Log: doors.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/07/31 23:39:45  Largo
// Initial revision
//

#pragma strong_types

#include <properties.h>
#include <defines.h>
#include <events.h>
#include <doors.h>

#define NEED_PROTOTYPES

#include <thing/properties.h>
#include <language.h>

// Defines mit global/handler/door.c abgleichen!
#define DDEST  0 // Tuerpfad als String
#define DSTATE 1 // Status als Int
#define DFLAGS 2 // Flags als Int
#define DPROPS 3 // Tuer-Properties als Mapping
#define DDIR   4 // Exitrichtung (zur Ausgabe) als String
#define DEMSGS 5 // Exit-Messages als Array
#define DAMSGS 6 // Actor-Messages als Mapping ([Event-Typ: *Msgs])

// Variablen
private static mapping doors; // DIE Tueren-Variable

// Prototypen Funktionen aus /std/room/exits.c
static string _MakePath(string str);
varargs void AddExit(mixed cmd, mixed room, mixed dest, mixed msgs);

// Eigne Prototypen
static mixed _set_doors(mixed value);
static mixed _query_doors();

void create() {
  if(object_name()=="/std/room/doors")
    return;
  doors=([]);
  Set(P_DOORS, #'_set_doors, F_SET_METHOD);
  Set(P_DOORS, #'_query_doors, F_QUERY_METHOD);
}

public string QueryPathDoor(string path) {
  mixed idx;
  int i;
  if(stringp(path) && (i=sizeof(doors))) {
    for(idx=m_indices(doors);i--;)
      if(doors[idx[i], DDEST]==path)
        return idx[i];
  }
  return (string)0;
}

static void add_door(string cmd, string dest, int state, int flags,
  mixed props, string dir, mixed msgs) {
  string ggs;
  mixed idx;
  int i, gstate;
  if(!stringp(cmd) || !strlen(cmd) || 
     !stringp(dest) || !strlen(dest) ||
     !intp(state) || !intp(flags) ||
     (props && !mappingp(props)))
    return;
  dest=_MakePath(dest);
  // ggf. Defaultwerte setzen
  if(!mappingp(props))
    props = ([ P_NAME     : "Tuer",
               P_NAME_ADJ : 0,
               P_DESCR    : "ohne Beschreibung",
               P_LONG     : "Eine @@e Tuer ohne jegliche Beschreibung.",
               P_GENDER   : FEMALE,
               P_ARTICLE  : ART_AUTO,
               P_IDS      : ({"tuer"}) ]);
  // Tuerstatus anpassen, wenn es bereits ein Gegenstueck gibt
  if(find_object(dest) &&
    stringp(ggs=dest->QueryPathDoor(object_name(this_object())))) {
    if((gstate=(int)dest->QueryDoorStatus(ggs))&DS_OPEN) {
      state|=DS_OPEN;
      AddExit(cmd, dest, dir, msgs);
    }
    else if(state&DS_OPEN) {
      state^=DS_OPEN;
    }
    if(gstate&DS_LOCKED && flags&DF_LOCKABLE)
      state|=DS_LOCKED;
    else if(state&DS_LOCKED)
      state^=DS_LOCKED;
    if(gstate&DS_DESTRUCTED && flags&DF_DESTRUCTABLE)
      state|=DS_DESTRUCTED;
    else if(state&DS_DESTRUCTED)
      state^=DS_DESTRUCTED;
  }
  // Ansonsten setzen wir selbst ein paar Sachen
  else {
    if(state&DS_OPEN) AddExit(cmd, dest, dir, msgs);
  }
  doors += ([cmd : dest; state; flags; props; dir; msgs; 0 ]);
}

public varargs void AddDoor(mixed cmds, string dest, int state, int flags,
  mixed props, string dir, mixed msgs) {
  if(stringp(cmds))
    add_door(cmds, dest, state, flags, props, dir, msgs);
  if(pointerp(cmds) && sizeof(cmds))
    map(cmds, #'add_door, dest, state, flags, props, dir, msgs);
}

private string make_dadj(string adj, int gen, int casus, int demon) {
  int i;
  string *ret;
  if(!stringp(adj))
    return "";
  if(lower_case(adj)[<1]!='e') adj+="e";
  if(demon)
    return ({
      ({ adj, adj+"n", adj+"n", adj     }),
      ({ adj, adj+"n", adj+"n", adj+"n" }),
      ({ adj, adj+"n", adj+"n", adj     }) })[gen%3][casus];
  else
    return ({
      ({ adj+"s", adj+"n", adj+"n", adj+"s" }),
      ({ adj+"r", adj+"n", adj+"n", adj+"n" }),
      ({ adj,     adj+"n", adj+"n", adj }) })[gen%3][casus];
}

private string door_article(int casus, int gender) {
  return ({ ({ "das ", "des ", "dem ", "das " }),
            ({ "der ", "des ", "dem ", "den " }),
            ({ "die ", "der ", "der ", "die " }) })
         [gender % 3][casus];
}

private string door_suffix(int casus, int gender) {
  return ({ ({ "",  "es", "em", ""   }),
            ({ "",  "es", "em", "en" }),
            ({ "e", "er", "er", "e"  }) })
            [gender % 3][casus];
}

private string door_iarticle(int casus, int gender) {
  return "ein"+ door_suffix(casus, gender) + " ";
}

private string dstate_string(string cmd) {
  if(!stringp(cmd) || !member(doors,cmd))
    return "<?>";
  if(doors[cmd, DSTATE]&DS_OPEN)
    return "geoeffnet";
  else if(doors[cmd, DSTATE]&DS_DESTRUCTED)
    return "zerstoert";
  else if(doors[cmd, DSTATE]&DS_DESTRUCTED)
    return "aufgebrochen";
  else if(doors[cmd, DSTATE]&DS_LOCKED)
    return "abgeschlossen";
  else
    return "geschlossen";
}

public varargs string QueryDoorName(string cmd, int casus, int modus) {
  mapping props;
  mixed nadj, adj;
  string tmp;
  int k, i, demon;
  if(!stringp(cmd) || !strlen(cmd) || !member(doors, cmd))
    return (string)0;
  props=doors[cmd, DPROPS];
  if(!stringp(props[P_NAME]) && !pointerp(props[P_NAME]))
    return 0;
  switch(props[P_ARTICLE]) {
    default:
    case ART_NONE:
      tmp = ""; break;
    case ART_AUTO:
      if(modus&NAME_DEF) {
        tmp = door_article(casus, props[P_GENDER]);
        demon=1;
      }
      else
        tmp = door_iarticle(casus, props[P_GENDER]);
      break;
    case ART_DEF:
      tmp = door_article(casus, props[P_GENDER]); demon=1; break;
    case ART_INDEF:
      tmp = door_iarticle(casus, props[P_GENDER]); break;
  }
  if(stringp(nadj=props[P_NAME_ADJ]))
    tmp+=make_dadj(nadj, props[P_GENDER], casus, demon)+" ";
  else if(pointerp(nadj) && k=sizeof(nadj)) {
    for(i=0;i<k;i++)
      tmp+=make_dadj(nadj[i], props[P_GENDER], casus, demon)+" ";
  }
  if(pointerp(props[P_NAME]))
    tmp+=props[P_NAME][casus];
  else
    tmp+=props[P_NAME];
  if(modus&NAME_DESCR && stringp(props[P_DESCR]))
    tmp=tmp+" "+props[P_DESCR];
  return tmp;
}

public string QueryDoorLong(string cmd) {
  string ret;
  if(!stringp(cmd) || !member(doors, cmd))
    return (string)0;
  if(stringp(ret=doors[cmd, DPROPS][P_LONG]))
    return implode(efun::explode(ret, "@@"), dstate_string(cmd));
  return (string)0;
}

public string QueryAllDoorLong() {
  mixed idx;
  string *tuer, tmp;
  int i;

  if(i=sizeof(doors)) {
    for(tuer=({}), idx=m_indices(doors);i--;)
      if(tmp=QueryDoorName(idx[i], WER, NAME_INDEF|NAME_DESCR))
        tuer+= ({tmp+" ("+dstate_string(idx[i])+")"});
    if(sizeof(tuer)>2)
      return capitalize(implode(tuer[0..<2], ", ")+" und "+tuer[<1]+".");
    else
      return capitalize(implode(tuer, " und ")+".");
  }
  return (string)0;
}

public int QueryDoorStatus(string cmd) {
  if(!stringp(cmd))
    return 0;
  return doors[cmd, DSTATE];
}

public int SetDoorStatus(string cmd, int state) {
  if(!stringp(cmd) || !intp(state) || !member(doors, cmd))
    return 0;
  doors[cmd, DSTATE]=state;
  return 1;
}

public int QueryDoorFlags(string cmd) {
  if(!stringp(cmd))
    return 0;
  return doors[cmd, DFLAGS];
}

public int SetDoorFlags(string cmd, int flags) {
  if(!stringp(cmd) || !intp(flags) || !member(doors, cmd))
    return 0;
  doors[cmd, DFLAGS]=flags;
  return 1;
}

public mixed QueryDoorProp(string cmd, string prop) {
  mapping props;
  if(!stringp(cmd) || !stringp(prop) || !mappingp(props=doors[cmd, DPROPS]))
    return 0;
  return props[prop];
}

public int SetDoorProp(string cmd, string prop, mixed value) {
  if(!stringp(cmd) || !stringp(prop) || !member(doors, cmd))
    return 0;
  doors[cmd, DPROPS][prop]=value;
  return 1;
}

public int SetDoorEventMsgs(string cmd, string etype, mixed msgs) {
  if(!stringp(cmd) || !stringp(etype) || !pointerp(msgs) || 
    !sizeof(msgs) || !member(doors,cmd))
    return 0;
  if(!mappingp(doors[cmd, DAMSGS]))
    doors[cmd, DAMSGS]=([etype:msgs]);
  else
    doors[cmd, DAMSGS]+=([etype:msgs]);
  return 1;
}

public mixed QueryDoorEventMsgs(string cmd, string etype) {
  mixed mess, ret;
  if(!stringp(cmd) || !stringp(etype) || !mappingp(mess=doors[cmd, DAMSGS]))
    return 0;
  if(pointerp(ret=mess[etype]))
    return (ret+({0,0,0}))[0..2];
  return ({0,0,0});
}

// Vom add_action() - NICHT direkt aufrufen!
int open_door(string argl) {
  mapping ret;
  mixed idx, dest, args;
  string tuer, key, verb;
  int i, demon;
  object kob;
  if(!stringp(argl) ||
    !(i=sizeof(args=efun::explode(lower_case(argl), " ")-({""}))) ||
    !query_verb())
    return 0;
  notify_fail("Was willst Du mit womit oeffnen?\n");
  if(i>3)
    return 0;
  tuer=args[0];
  if(i>2) {
    if(args[1]!="mit")
      return 0;
    else
      key=args[2];
  }
  if(i=sizeof(idx=m_indices(doors))) {
    notify_fail("Hier ist kein '"+tuer+"', was Du oeffnen koenntest.\n");
    for(;i--;) {
      if(member(doors[idx[i], DPROPS][P_IDS], tuer)!=-1) {
        if(doors[idx[i], DSTATE]&DS_OPEN) {
          notify_fail(capitalize(QueryDoorName(idx[i],WER,NAME_DEF))+
            " ist doch schon offen.\n");
          continue;
        }
        dest=doors[idx[i], DDEST];
        dest=(stringp(dest)?load_object(dest):0);
        if(stringp(key)) {
          if(!objectp(kob=present(key,this_player()))) {
            tell_object(this_player(), "Du besitzt kein '"+key+"'.\n");
            return 1;
          }
          if(!(doors[idx[i], DSTATE]&DS_LOCKED)) {
            tell_object(this_player(), capitalize(
              QueryDoorName(idx[i],WER,NAME_DEF))+
              " ist nicht abgeschlossen.\n");
            return 1;
          }
          ret=send_event(ET_DOOR_UNLOCK, ([
                E_DOOR      : idx[i],
                E_DOOR_ROOM : this_object(),
                E_DOOR_DEST : dest,
                E_DOOR_ACTOR: this_player(),
                E_DOOR_KEY  : kob,
                E_DOOR_MSGS : QueryDoorEventMsgs(idx[i], ET_DOOR_UNLOCK)]),
                ({this_object(), dest}), EM_SIMPLE);
          if(!mappingp(ret) || !ret[E_HANDLED])
            return 0;
        }
        ret=send_event(ET_DOOR_OPEN, ([
              E_DOOR      : idx[i],
              E_DOOR_ROOM : this_object(),
              E_DOOR_DEST : dest,
              E_DOOR_ACTOR: this_player(),
              E_DOOR_MSGS : QueryDoorEventMsgs(idx[i], ET_DOOR_OPEN)]),
              ({this_object(), dest}), EM_SIMPLE);
        return (mappingp(ret)?ret[E_HANDLED]:0);
      }
    }
  }
  return 0;
}

// vom add_action()
int close_door(string argl) {
  mapping ret;
  mixed idx, dest, args;
  string tuer, key, verb;
  int i, demon;
  object kob;
  if(!stringp(argl) ||
    !(i=sizeof(args=efun::explode(lower_case(argl), " ")-({""}))) ||
    !(verb=query_verb()))
    return 0;
  notify_fail("Was willst Du mit womit schliessen?\n");
  if(i>4)
    return 0;
  if(i==2) {
    if(args[1]=="ab" || args[1]=="zu")
      notify_fail("Womit willst Du das denn abschliessen?\n");
    else if(args[1]=="auf")
      notify_fail("Womit willst Du das denn aufschliessen?\n");
    else
      notify_fail("WAS willst Du MIT WAS (ab)schliessen?\n");
    return 0;
  }
  tuer=args[0];
  if(i>1) {
    if(args[1]!="mit")
      return 0;
    else
      key=args[2];
    if(verb[0..2]=="ver") demon=1;
  }
  if(i==4 && (args[3]=="ab" || args[3]=="zu"))
    demon=1;
  if(i==4 && args[3]=="auf")
    demon=2;
  notify_fail("Schliesse WAS mit WAS ab/zu/auf?\n");
  if(!demon && i==4) 
    return 0;
  if(i=sizeof(idx=m_indices(doors))) {
    notify_fail("Hier ist kein '"+tuer+"', was Du schliessen koenntest.\n");
    for(;i--;) {
      if(member(doors[idx[i], DPROPS][P_IDS], tuer)!=-1) {
        // geschlossen und kein Schluessel angegeben?
        if(!(doors[idx[i], DSTATE]&DS_OPEN) && !stringp(key)) {
          notify_fail(capitalize(QueryDoorName(idx[i],WER,NAME_DEF))+
            " ist doch schon geschlossen.\n");
          continue;
        }
        dest=doors[idx[i], DDEST];
        dest=(stringp(dest)?load_object(dest):0);
        if(doors[idx[i], DSTATE]&DS_OPEN && !demon) {
          ret=send_event(ET_DOOR_CLOSE, ([
                E_DOOR      : idx[i],
                E_DOOR_ROOM : this_object(),
                E_DOOR_DEST : dest,
                E_DOOR_ACTOR: this_player(),
                E_DOOR_MSGS : QueryDoorEventMsgs(idx[i], ET_DOOR_CLOSE)]),
                ({this_object(), dest}), EM_SIMPLE);
           if(!mappingp(ret) || !ret[E_HANDLED])
             return 0;
        }
        if(!stringp(key))
          return 1;
        if(!objectp(kob=present(key,this_player()))) {
          tell_object(this_player(), "Du besitzt kein '"+key+"'.\n");
          return 1;
        }
        if(demon<2)
          ret=send_event(ET_DOOR_LOCK, ([
                E_DOOR      : idx[i],
                E_DOOR_ROOM : this_object(),
                E_DOOR_DEST : dest,
                E_DOOR_ACTOR: this_player(),
                E_DOOR_KEY  : kob,
                E_DOOR_MSGS : QueryDoorEventMsgs(idx[i], ET_DOOR_LOCK)]),
                ({this_object(), dest}), EM_SIMPLE);
        else
          ret=send_event(ET_DOOR_UNLOCK, ([
                E_DOOR      : idx[i],
                E_DOOR_ROOM : this_object(),
                E_DOOR_DEST : dest,
                E_DOOR_ACTOR: this_player(),
                E_DOOR_KEY  : kob,
                E_DOOR_MSGS : QueryDoorEventMsgs(idx[i], ET_DOOR_LOCK)]),
                ({this_object(), dest}), EM_SIMPLE);
        return (mappingp(ret)?ret[E_HANDLED]:0);
      }
    }
  }
  return 0;
}

void init() {
  if(object_name()=="/std/room/doors")
    return;
  add_action("open_door", "oeffne");
  add_action("close_door", "schliess");
  add_action("close_door", "schliesse");
  add_action("close_door", "verschliess");
  add_action("close_door", "verschliesse");
}

void reset() {
  mixed idx, dest;
  int i, flags, state;
  if((object_name()=="/std/room/doors") || !mappingp(doors))
    return;
  if(i=sizeof(idx=m_indices(doors)))
    for(;i--;) {
      flags=doors[idx[i], DFLAGS];
      // Im Reset laden wir die Nachbarraeume nicht!
      dest=(stringp(doors[idx[i], DDEST])?find_object(doors[idx[i], DDEST]):0);
      if(QueryDoorStatus(idx[i])&DS_DESTRUCTED) {
        if(flags&DF_AUTO_RENEW)
          send_event(ET_DOOR_RENEW, ([
            E_DOOR      : idx[i],
            E_DOOR_ROOM : this_object(),
            E_DOOR_DEST : dest,
            E_DOOR_ACTOR: 0,
            E_DOOR_MSGS : QueryDoorEventMsgs(idx[i], ET_DOOR_RENEW)]),
            ({this_object(), dest}), EM_SIMPLE);
        else
          continue;
      }
      if(QueryDoorStatus(idx[i])&DS_DESTRUCTED) continue;
      if(QueryDoorStatus(idx[i])&DS_BROKEN && 
        (flags&DF_AUTO_RENEW || flags&DF_AUTO_REPAIR))
          send_event(ET_DOOR_REPAIR, ([
            E_DOOR      : idx[i],
            E_DOOR_ROOM : this_object(),
            E_DOOR_DEST : dest,
            E_DOOR_ACTOR: 0,
            E_DOOR_MSGS : QueryDoorEventMsgs(idx[i], ET_DOOR_REPAIR)]),
            ({this_object(), dest}), EM_SIMPLE);
      if(QueryDoorStatus(idx[i])&DS_OPEN) {
        if(flags&DF_AUTO_CLOSE)
          send_event(ET_DOOR_CLOSE, ([
            E_DOOR      : idx[i],
            E_DOOR_ROOM : this_object(),
            E_DOOR_DEST : dest,
            E_DOOR_ACTOR: 0,
            E_DOOR_MSGS : QueryDoorEventMsgs(idx[i], ET_DOOR_CLOSE)]),
            ({this_object(), dest}), EM_SIMPLE);
      }
      if(!(QueryDoorStatus(idx[i])&DS_OPEN)) {
        if(flags&DF_AUTO_OPEN)
          send_event(ET_DOOR_OPEN, ([
            E_DOOR      : idx[i],
            E_DOOR_ROOM : this_object(),
            E_DOOR_DEST : dest,
            E_DOOR_ACTOR: 0,
            E_DOOR_MSGS : QueryDoorEventMsgs(idx[i], ET_DOOR_OPEN)]),
            ({this_object(), dest}), EM_SIMPLE);
      }
      state=QueryDoorStatus(idx[i]);
      if(!(state&DS_OPEN) && !(state&DS_LOCKED) && flags&DF_AUTO_LOCK &&
        !(state&DS_BROKEN))
          send_event(ET_DOOR_LOCK, ([
            E_DOOR      : idx[i],
            E_DOOR_ROOM : this_object(),
            E_DOOR_DEST : dest,
            E_DOOR_ACTOR: 0,
            E_DOOR_MSGS : QueryDoorEventMsgs(idx[i], ET_DOOR_LOCK)]),
            ({this_object(), dest}), EM_SIMPLE);
    }
}

//////////////// Set/Query-Methoden ////////////////////

static mixed _set_doors(mixed value) {
  if(!mappingp(value)) return 0;
  return doors=value;
}

static mixed _query_doors() {
  return doors;
}

