/*******************
** Eldarea MUDLib **
********************
**
** std/room/exit.c - room exit functions
**
** CVS DATA
** $Date: 2001/02/01 09:26:09 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: exits.c,v $
** Revision 1.3  2001/02/01 09:26:09  elatar
** move event handling slightly changed
**
** Revision 1.2  2000/12/04 11:20:04  elatar
** Wizexits removed
** Complete exits and exit-handling rewritten
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

/*
 * Exits of the room (obvious ones, doors, and special ones)
 * we define the following function for easy reference:
 * GetExits() - return a string containing an "Obvious Exits" Statement
 *
 * The exits are implemented as properties P_EXITS
 * They are stored locally (_set_xx, _query_xx)
 * as mapping to speed up the routines in this module.
 *
 */

#pragma strong_types

#define NEED_PROTOTYPES

#include <config.h>
#include <thing/properties.h>
#include <properties.h>
#include <moving.h>
#include <defines.h>
#include <doorroom.h>
#include <wizlevels.h>
#include <events.h>
#include <room/exits.h>
#include <events.h>

#define DB(x) if(find_player("elatar")) tell_object(find_player("elatar"), x+"\n")

void create() 
{
  SetProp(P_EXITS, ([]) );
}

static string _MakePath(string str)  
{ 
  string pref,name,rest; 
  string *comp; comp = explode(object_name(this_object()), "/"); 
  switch(str[0])  { 
    case '.': 
    str = "/"+implode(comp[0..<2], "/")+"/"+str; break; 
    case '~': 
    str = "/"+comp[0]+"/"+(comp[0]=="d"?comp[1]+"/":"") 
      +getuid(this_object())+str[1..]; 
    break; 
  } 
  return MASTER->_get_path(str, getuid(this_object())); 
}

varargs void AddExit(string dir, mixed exit)
{
  mapping exits;
  
  if (!stringp(dir))
    return;
    
  if (stringp(exit))
  {
    exit=([EX_DEST:exit]);
  }
  else if (!mappingp(exit))
    return;
  exit[EX_DEST]=_MakePath(exit[EX_DEST]);
  if (!member(exit,EX_DIST))
    exit[EX_DIST]=5;
  if (!member(exit,EX_ECHO))
    exit[EX_ECHO]=50;
  if (!member(exit,EX_FLAGS))
    exit[EX_FLAGS]=!EXF_INACTIVE;
  if (!member(exit,EX_MAXSIZE))
    exit[EX_MAXSIZE]=-1;
  if (!exit[EX_METHODS])
    exit[EX_METHODS]=M_GO|M_FLY|M_FLOAT;
  
  exits=Query(P_EXITS);
  exits[dir]=exit;
  Set(P_EXITS,exits);
}

void RemoveExit(mixed dir) 
{
  mapping exita;

  if(!dir)
    Set(P_EXITS, ([]) );

  if(!pointerp(dir))
    dir = ({ dir });

  for(exita=Query(P_EXITS);sizeof(dir);dir=dir[1..])
    m_delete(exita,dir[0]);

  Set(P_EXITS, exita);
}

static string ShortExitString(string *exits, int wiz_exits) {
  int i;

  if (!exits || !sizeof(exits)) 
  {
    if (!wiz_exits) 
      return "Keine Ausgaenge.\n";
    return "";
  }
  if ((i = member_array("norden", exits)) != -1) exits[i] = "n";
  if ((i = member_array("osten", exits)) != -1) exits[i] = "o";
  if ((i = member_array("sueden", exits)) != -1) exits[i] = "s";
  if ((i = member_array("westen", exits)) != -1) exits[i] = "w";
  if ((i = member_array("nordwesten", exits)) != -1) exits[i] = "nw";
  if ((i = member_array("suedwesten", exits)) != -1) exits[i] = "sw";
  if ((i = member_array("nordosten", exits)) != -1) exits[i] = "no";
  if ((i = member_array("suedosten", exits)) != -1) exits[i] = "so";
  if ((i = member_array("oben", exits)) != -1) exits[i] = "ob";
  if ((i = member_array("unten", exits)) != -1) exits[i] = "u";

  return (wiz_exits ? "Magierausgaenge: " : "Ausgaenge: ") + implode(exits, ", ") + ".\n";
}

varargs string GetExits(object viewer, int short) 
{
  int n;
  string *numbers;
  string *indices;
  string retstring;
  mapping exits;

  if (QueryProp(P_DOOR_INFOS))
    call_other(DOOR_MASTER, "init_doors");

  retstring = "";
  numbers = ({"zwei","drei","vier","fuenf","sechs","sieben","acht"});
  exits=Query(P_EXITS)||([]);
  indices = m_indices(exits);

  indices = filter(indices,lambda(
    ({'x}),({#'!,({#'&,({#'[,({#'[,exits,'x}),EX_FLAGS}),EXF_HIDDEN})})) );

  if (short)
    retstring = ShortExitString(indices, 0);
  else {
    switch (n = sizeof(indices)) {
      case 0:
        retstring = "Es gibt keine sichtbaren Ausgaenge.\n";
        break;
      case 1:
        retstring = "Es gibt einen sichtbaren Ausgang: "+indices[0]+".\n";
        break;
      case 2: case 3: case 4: case 5: case 6: case 7: case 8:
        retstring = "Es gibt "+numbers[n-2]+" sichtbare Ausgaenge: ";
        break;
      default:
        retstring = "Es gibt viele sichtbare Ausgaenge: ";
    }

    indices=sort_array(indices, #'>);

    if (n > 1)
      retstring += implode(indices[0..n-2], ", ") + " und " + indices[n-1] + ".\n";
  }

  return break_string(retstring);
}

// Hier werden _alle_ Exits 'behandelt'
int _normalfunction(string str) 
{
  string destroom, how, dir, *ind, *verbs, et;
  mixed * msgs;
  mapping map, ret;
  int i, method;

  if (str && str!="")
  {
    // Schleichen
    if ( sscanf(str,"%s %s",how,dir)==2 
      && -1!=member_array(how,({"leise","heimlich","still"})) )
    {
      method=M_SNEAK;
      str=dir;
    }
    if ( sscanf(str,"nach %s",dir)==1 );
    else
      dir=str;
    switch(query_verb())
    {
      case "gehe":
      case "geh":
        notify_fail("In diese Richtung koennt Ihr nicht gehen.\n");
        method|=M_GO;
        break;  
      case "schwebe":
      case "schweb":
        notify_fail("In diese Richtung koennt Ihr nicht schweben.\n");
        method|=M_FLOAT;
        break;  
      case "fliege":
      case "flieg":
        notify_fail("In diese Richtung koennt Ihr nicht fliegen.\n");
        method|=M_FLY;
        break;  
      case "klettere":
      case "kletter":
        notify_fail("In diese Richtung koennt Ihr nicht klettern.\n");
        method|=M_CLIMB;
        break;  
      case "schwimme":
      case "schwimm":
        notify_fail("In diese Richtung koennt Ihr nicht schwimmen.\n");
        method|=M_SWIM;
        break;  
      case "tauche":
      case "tauch":
        notify_fail("In diese Richtung koennt Ihr nicht tauchen.\n");
        method|=M_DIVE;
        break;  
      case "krieche":
      case "kriech":
        notify_fail("In diese Richtung koennt Ihr nicht kriechen.\n");
        method|=M_CRAWL;
        break;  
      case "schleiche":
      case "schleich":
        method|=M_SNEAK;
      default:
        return 0;
        break;          
    }
  }
  else if(!dir && !stringp(dir = query_verb()))
    return 0;
  else
  {
    if (this_player()->QueryProp(P_MOVE_METHOD))
      method|=this_player()->QueryProp(P_MOVE_METHOD);
    else
      method|=M_GO;
  }

  dir = lower_case(dir);

  map = Query(P_EXITS);

  if (member(map,dir))
    destroom = map[dir][EX_DEST];

  ind=m_indices(map);
  for (i=0;!destroom && i<sizeof(ind);i++)
  {
    if ( pointerp(map[ind[i]][EX_CMDS])
      && -1!=member(map[ind[i]][EX_CMDS],dir) )
    {
      dir=ind[i];
      destroom=map[dir][EX_DEST];
    } 
  }
  
  if (!destroom)
    return 0;
  // inaktive exits abfangen
  if (map[dir][EX_FLAGS]&EXF_INACTIVE)
    return 0;
    
  // Methode testen
  if (!(map[dir][EX_METHODS]&method))
   return 0;
    
  // testfunc testen
  if ( map[dir][EX_TESTFUNC] 
    && call_other(this_object(),
                  map[dir][EX_TESTFUNC],
                  copy_mapping(map[dir]),
                  method) )
    return -1;
  // guards testen
  if (pointerp(map[dir][EX_GUARDS]))
  {
    map[dir][EX_GUARDS]-=({0});
    map[dir][EX_GUARDS]=filter_array(map[dir][EX_GUARDS],
                                      #'present,this_object());
    for (i=sizeof(map[dir][EX_GUARDS]);i-->0;)
    {
      if (call_other(map[dir][EX_GUARDS][i],
                     "ObserveExit",
                     copy_mapping(map[dir]),
                     method))
        return -1;
    }
  }
    
  if ( map[dir][EX_MAXSIZE]!=-1 
    && map[dir][EX_MAXSIZE]<this_player()->QueryProp(P_SIZE) )
  {
    if (!map[dir][EX_SIZEFAILMSG])
      write("Du bist zu gross, um durch diesen Ausgang zu gehen.\n");
    else
      write(map[dir][EX_SIZEFAILMSG]);
    return 1;
  }

  verbs=({map[dir][EX_S_VERB],map[dir][EX_D_VERB],map[dir][EX_P_VERB]});
  msgs=({map[dir][EX_S_MSG],map[dir][EX_D_MSG],map[dir][EX_P_MSG]});

  if(member_array(dir,({"sueden","suedwesten","westen","nordwesten",
    "norden","nordosten","osten","suedosten",}))!=-1)
    str=" &verb nach "+capitalize(dir)+".";
  else if ( member_array(dir,({"oben","unten"}) ) != -1 )
    str=" &verb nach "+dir+".";
  else
    str=" &verb "+dir+".";
  if (!stringp(msgs[0]) && msgs[0]!=-1)
  {
    msgs[0]="&Name"+str;
  }
  if (!stringp(msgs[1]) && msgs[1]!=-1)
    msgs[1]="&Name &verb herein.";
  if (!stringp(msgs[2]) && msgs[2]!=-1)
    msgs[2]="Ihr"+str;

  if (!MOVE_OK == this_player()->move(destroom, method, msgs, verbs))
    return 0;
  else if ( map[dir][EX_FUNC] && ret[E_HANDLED])
    call_other(this_object(),map[dir][EX_FUNC],copy_mapping(map[dir]),method,ret);
  return 1;
}

static int toggle_exits(string str) {
  int ex;
  
  if(!str) {
    if(!this_player()->CanSee())
      return 1;
    write(GetExits(this_player()));
    return 1;
  }

  notify_fail("'"+query_verb()+"' was?\n");
  switch (str) {
    default: return 0;
    case "aus": ex=0; break;
    case "kurz": ex=1;
    case "auto": ex++;
  }

  this_player()->SetProp(P_SHOW_EXITS, ex);

  if(ex>1)
    write("Die Ausgaenge werden automatisch und verkuerzt angezeigt.\n");
  else if(!ex)
    write("Die Ausgaenge werden nicht mehr automatisch angezeigt.\n");
  else
    write("Die Ausgaenge werden automatisch angezeigt.\n");
  return 1;
}

void init() {
  // Alle Eingaben gehen erstmal an _normalfunction()
  add_action("_normalfunction","",1);
  add_action("toggle_exits", "exits");
  add_action("toggle_exits", "ausgang");
  add_action("toggle_exits", "ausgaenge");
  add_action("toggle_exits", "aus");
}

/////////////////// Query() / Set() Methoden ////////////////////

static mapping _set_exits(mapping map)  
{ 
  if(mappingp(map)) 
    return Set(P_EXITS, map); 
} 
 
static mapping _query_exits()  
{ 
  if((!previous_object() || object_name(previous_object())!=DOOR_MASTER) && 
     QueryProp(P_DOOR_INFOS)) 
    call_other(DOOR_MASTER, "init_doors"); 
 
  return filter(Query(P_EXITS), lambda( ({ 'k, 'a }), ({
    #'stringp, ({ #'[, 'a, 0 }) }) ));
} 
