/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: items.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// STD/ROOM/ITEMS.C -- creating extra items in room
//
// Basierend auf Morgengrauen MUDlib
//
// $Revision: 1.1.1.1 $
//
// $Log: items.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//
// Revision 1.10  1999/07/28 22:02:10  Gum
// neue funktion: RemoveItem
//
// Revision 1.9  1999/07/18 15:43:08  Holger
// Kleinigkeiten optimiert
//
// Revision 1.8  1999/04/13 14:51:36  Holger
// clean_double() Test vereinfacht (load_name)
//
// Revision 1.7  1999/02/22 08:21:21  Fiona
// removable_ob() bestimmt Unsichtbarkeit jetzt korrekt (PLURAL)  (Elric)
//
// Revision 1.6  1998/11/27 10:13:46  Fiona
// AddItem behandelt Units nun korrekt (andere move-Methode)
//
// Revision 1.5  1998/06/26 23:37:27  Gum
// kleine aenderungen am header
//
// Revision 1.4  1998/04/01 15:57:47  Holger
// Die Ueberpruefung in clean_double() ob ein Spieler anwesend ist
// konnt so nie gehen,. Gefixed!
//             

#pragma strong_types

#define NEED_PROTOTYPES

#include <thing/properties.h>
#include <defines.h>
#include <config.h>
#include <rooms.h>
#include <properties.h>
#include <moving.h>
#include <daemon.h>

void create() {
  SetProp(P_ITEMS, ({}));
  OBJECTD->QueryObject();  // querying general objects
}

/* Item handling */

varargs object AddItem(mixed filename, int refresh, mixed props) {
  string file;
  object ob;

  if(pointerp(filename)) {
    filename=map_array(filename, "_get_path", MASTER, "?");
    file = filename[random(sizeof(filename))];
  }
  else 
    file = filename = MASTER->_get_path(filename,"?");
  if(props==1)
    ob=load_object(file);
  else
    ob=clone_object(file);
  ob->move(this_object(), M_NO_ATTACK|M_NOCHECK);
  SetProp(P_ITEMS, QueryProp(P_ITEMS)
	  +({ ({ ob,        // RITEM_OBJECT
                 filename,  // RITEM_FILE
                 refresh    // RITEM_REFRESH
		 }) 
		+ ((mappingp(props) || props==1)?({ props }):({}))
		}));
  if(mappingp(props)) 
    walk_mapping(props, symbol_function("SetProp", ob)); 
  return ob;
}

varargs int RemoveItem(object obj, int method)
{
  int s;
  mixed m;

  if (!objectp(obj))
    return 0;

  s = sizeof(m = QueryProp(P_ITEMS));
  while (s--)
  {
    if (m[s][0] == obj)
    {
      m -= ({ m[s] });
      if (method)
      {
        obj->remove(method-1);
        if (objectp(obj)) destruct(obj);
      }
      SetProp(P_ITEMS, m);
      return 1;
    }
  }

  return 0;
}

private static mixed _do_refresh(mixed item) {
  string file;
  object ob;

  if(!pointerp(item) || item[RITEM_REFRESH] == REFRESH_NONE)
    return item;

  if(pointerp(item[RITEM_FILE])) 
    file = item[RITEM_FILE][random(sizeof(item[RITEM_FILE]))];
  else
    file = item[RITEM_FILE];

  switch(item[RITEM_REFRESH]) {
    case REFRESH_NONE:
      if(!item[RITEM_OBJECT]) return 0;
      break;
    case REFRESH_DESTRUCT:
      if(objectp(item[RITEM_OBJECT]))
        break; // sonst weiter
    case REFRESH_REMOVE:
      if(objectp(item[RITEM_OBJECT]) && environment(item[RITEM_OBJECT]) == ME)
        break; // sonst weiter
    default:
      if (sizeof(item)>RITEM_PROPS && item[RITEM_PROPS]==1)
        ob=load_object(file);
      else
        ob=clone_object(file);
      ob->move(ME,M_NOCHECK|M_NO_ATTACK);
  }

  if(ob) {
    item[RITEM_OBJECT] = ob;
    if(sizeof(item) > RITEM_PROPS && mappingp(item[RITEM_PROPS]))
      walk_mapping(item[RITEM_PROPS], symbol_function("SetProp", ob));
  }
  return item;
}

static mixed removeable_ob(object ob) {
  if( !living(ob) && !query_once_interactive(ob) &&
    (stringp(ob->short()) || ob->QueryProp(P_PLURAL)) )
    return ob;
  else
    return 0;
}

static int _sortfunc(mixed *a, mixed *b) {
  return a[0]<b[0];
}

void clean_double() {
  mixed *inh, *items;
  int i,j;
  string ident;
  object ob;
  
  inh=all_inventory(this_object());
  if (!pointerp(inh) || !sizeof(inh)) return;
  if (sizeof(filter_array(inh,#'interactive))) return;  // Spieler da?
  inh=filter_array(inh,#'removeable_ob)-({0});
  if (sizeof(inh)<10) return;
  items=Query(P_ITEMS);
  for (i=sizeof(items)-1;i>=0;i--) inh-=({items[i][0]});
  for (i=sizeof(inh)-1;i>=0;i--) {
    ob=inh[i];
    inh[i]=({load_name(ob), ob});
  }
  inh=sort_array(inh,#'_sortfunc);
  ident="";
  for (i=sizeof(inh)-1;i>=0;i--)
    if (ident!=inh[i][0]) {
      ident=inh[i][0];
      j=1;
    }
    else {
      j++;
      if (j>3 && inh[i][1]) {
        log_file("CLEAN_ROOM",sprintf("%s: %O in %O\n",dtime(time())[5..],inh[i][1],this_object()));
        catch(inh[i][1]->remove());
        if (inh[i][1])
          destruct(inh[i][1]);
      }
    }
}

// reset handling: check how the items should be refreshed.
void reset() {
  if(object_name(ME)=="/std/room/items")
    return;
  if(!pointerp(QueryProp(P_ITEMS)))
    SetProp(P_ITEMS, ({}));
  SetProp(P_ITEMS, map_array(QueryProp(P_ITEMS), #'_do_refresh)-({0}));
  funcall(#'clean_double);
}

// local property methods
static mixed _set_items(mixed arg)  {
  if(pointerp(arg)) return Set(P_ITEMS, arg);
}

