/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2000/12/04 11:20:35 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: newdoors.c,v $
** Revision 1.2  2000/12/04 11:20:35  elatar
** adapted to new exits
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// STD/ROOM/NEWDOORS.C -- new doors, managed by doormaster
//
// Basierend auf der MorgenGrauen MUDlib
//
// $Revision: 1.2 $
//
// $Log: newdoors.c,v $
// Revision 1.2  2000/12/04 11:20:35  elatar
// adapted to new exits
//
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//
// Revision 1.5  1999/07/18 15:43:48  Holger
// vormals doors.c -> umbenannt
// Kleinigkeiten optimiert
//
// Revision 1.4  1999/01/26 18:40:45  Holger
// NewDoor Manpage ausgeschnitten
//
// Revision 1.3  1998/08/11 16:32:37  Gum
// abgeschlossene tueren koennen jetzt auch aufgeschlossen werden
// anstatt nur mit schluessel geoeffnet
//

#pragma strong_types

#define NEED_PROTOTYPES

#include <config.h>
#include <thing/properties.h>
#include <properties.h>
#include <defines.h>
#include <doorroom.h>

// external prototypes
varargs void AddExit(string dir, mixed exit);
void RemoveExit(mixed cmd);

void create() {
  SetProp(P_DOOR_INFOS,0);
}

varargs int NewDoor(mixed cmds, string dest, mixed ids, mixed props) {
  if (!cmds || !dest) return 0;
  return call_other(DOOR_MASTER,"NewDoor",cmds,dest,ids,props);
}

void init() {
  mixed *info;
  string *cmds;
  int i,j;

  if (!pointerp(info=(mixed *)QueryProp(P_DOOR_INFOS)))
    return;

  add_action("oeffnen","oeffne");
  add_action("schliessen","schliesse");
  add_action("schliessen","schliess");

  for (i=sizeof(info);i--;) {
    cmds=(string *)(info[i][D_CMDS]);
    for (j=sizeof(cmds);j--;)
      add_action("go_door",cmds[j]);
    // Befehle IMMER anfuegen, gechecked wird sowieso erst beim Durchgehen.
  }
}

void reset() {
  if(object_name()!="/std/room/newdoors" && QueryProp(P_DOOR_INFOS))
    call_other(DOOR_MASTER,"reset_doors");
}

int oeffnen(string str, int silent) {
  if (!str || !QueryProp(P_DOOR_INFOS))
    return 0;
  return (int) call_other(DOOR_MASTER,"oeffnen",str,silent);
}

int schliessen (string str, int silent) {
  string *s;
  if (!str || !QueryProp(P_DOOR_INFOS))
    return 0;
  if (((s = (explode(str, " ") - ({ "" })))[<1] == "auf") && (sizeof(s) > 1))
    return (int) call_other(DOOR_MASTER, "oeffnen", implode(s[0..<2], " "), silent);
  return (int) call_other(DOOR_MASTER, "schliessen", str, silent);
}

varargs int go_door(string str) {
  if(!QueryProp(P_DOOR_INFOS))
    return 0;
  if (call_other(DOOR_MASTER,"go_door",query_verb()))
    return 1;
  return 0;
}

int set_doors(string *cmds,int open) {
  int j;
  
  if(!previous_object() || object_name(previous_object())!=DOOR_MASTER)
    return 0;
  // Andere sollen nicht rumpfuschen.
  if(!this_player() || environment(this_player())!=this_object())
    return 0;
  // Ist sowieso keiner da...
  if (!pointerp(cmds))
    return 0;
  if (open)
    /*AddExit(cmds, #'go_door)*/;
  else
    RemoveExit(cmds);
  for (j=sizeof(cmds)-1;j>=0;j--)
    add_action("go_door",cmds[j]);
}

