/*******************
** Eldarea MUDLib **
********************
**
** std/shells/filesys/primitives - file command primitives
**
** CVS DATA
** $Date: 2000/12/12 08:10:35 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: primitives.c,v $
** Revision 1.3  2000/12/12 08:10:35  elatar
** header changed
**
** Revision 1.2  2000/12/04 11:26:52  elatar
** bug when cp'ing with identical file arguments fixed
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

#include <defines.h>
#include <config.h>
#include "/std/sys_debug.h"

#define MAXLEN	20000

#define SET(var, bit)	(var |= (1<<bit))	// set bit in var
#define GET(var, bit)	(var & (1<<bit))	// test bit in var

#define EXEC	2		// file status (loadable)
#define WRITE	1		// writeable
#define READ	0		// readable

#define ERROR(msg, arg)		        (printf(msg, arg), -1)
#define ERROR2(msg, arg1, arg2)		(printf(msg, arg1, arg2), -1)

#define NO_READ			      "%s: no read permissions\n"
#define NO_WRITE		      "%s: no write permissions\n"
#define DOESNT_EXIST		  "%s: file doesn't exist\n"
#define ALREADY_EXISTS		"%s: file exists\n"
#define FILE_IS_DIR       "%s: file is directory\n"
#define FILES_EQUAL       "%s and %s are the same file\n"

// exists() -- returns if the file or directory exists
private int exists(string file)
{ int size; return (size = file_size(file)) >= 0 || size == -2; }

// access() -- checks the access rights for a file, returns bitfield
private int access(string file)
{
  int rights;
  // if(MASTER->valid_exec(file)) SET(rights, EXEC); not yet applicable
  if(MASTER->valid_write(file, getuid(ME))) SET(rights, WRITE);
  if(MASTER->valid_read(file, getuid(ME))) SET(rights, READ);
  return rights;
}

// cp_file() -- copies from to to
// overlong (50k) files will be split
static int cp_file(string from, string to)
{
  string bytes; int ptr, sz;
  sz=file_size(from);
  if(sz==-2) return ERROR(FILE_IS_DIR, from);
  if(sz==-1) return ERROR(DOESNT_EXIST, from);
  if(!GET(access(from), READ)) return ERROR(NO_READ, from);
  if(!GET(access(to), WRITE)) return ERROR(NO_WRITE, to);
  if (to==from) return ERROR2(FILES_EQUAL,to,from);
  if(exists(to)) rm(to);
  // copy empty files 
  if(!sz) { write_file(to, ""); return 1; }
  // copy normal&overlong
  do {
    bytes = read_bytes(from, ptr, MAXLEN); ptr += MAXLEN;
    write_file(to, bytes);
  }
  while(strlen(bytes) == MAXLEN);
  return 1;
}

// mv_file() -- moves file from to to
static int mv_file(string from, string to)
{
  if(!exists(from)) return ERROR(DOESNT_EXIST, from);
  if(!GET(access(from), READ)) return ERROR(NO_READ, from);
  if(!GET(access(from), WRITE)) return ERROR(NO_READ, from);
  if(!GET(access(to), WRITE)) return ERROR(NO_WRITE, to);
  rename(from, to);
  return 1;
}

// rm_file() -- removes file
static int rm_file(string file)
{
  if(!exists(file)) return ERROR(DOESNT_EXIST, file);
  if(!GET(access(file), WRITE)) return ERROR(NO_WRITE, file);
  rm(file);
  return 1;
}

// dir_file() -- makes or removes directory
static int dir_file(string file, int mk)
{
  if(mk && exists(file)) return ERROR(ALREADY_EXISTS, file);
  if(!mk && !exists(file)) return ERROR(DOESNT_EXIST, file);
  if(GET(access(file), WRITE)) 
    if((mk && !mkdir(file)) || (!mk && !rmdir(file)))
      return ERROR(NO_WRITE, file);
  return 1;
}

#define IGN_CASE	4	// ignore case
#define PUT_LNUM	16	// add line numbers
#define NO_MATCH	32	// reverse matched lines

// _put_line_number() -- adds a line number to line, taken from lines
// and adds offset
private string _put_line_number(string line, string *lines, int offset)
{ return sprintf("%4d %s", member(lines, line)+offset, line); }

// _copy_original() -- return original line from new in old 
private string _copy_original(string line, string *new, string *old)
{ return old[member(new, line)]; }

// grep_file() -- grep file for pattern
static mixed grep_file(string file, string rexpr, int flags)
{
  string *lines, *tmp, *tmp1, src, *result; int ptr, lno;
  if(!exists(file)) return ERROR(DOESNT_EXIST, file);
  if(!GET(access(file), READ)) return ERROR(NO_READ, file);
  result = ({});
  do {
    tmp1 = lines = explode(src = read_bytes(file, ptr, MAXLEN), "\n"); 
    ptr += MAXLEN + 1;
    if(flags & IGN_CASE) lines = map_array(lines, #'lower_case);
    tmp = regexp(lines, rexpr);
    if(flags & IGN_CASE) tmp = map_array(tmp, #'_copy_original, lines, tmp1);
    if(flags & NO_MATCH) tmp = lines - tmp;
    if(flags & PUT_LNUM) 
      tmp = map_array(tmp, #'_put_line_number, lines, lno);
    result += tmp;
    lno += sizeof(lines);
  }
  while(strlen(src) == MAXLEN);
  return result;
}

// upd_file() -- update a file
static int upd_file(string file, int dummy)
{
  object obj;
  if(!exists(file)) return ERROR(DOESNT_EXIST, file);
  if(!GET(access(file), WRITE)) return ERROR(NO_WRITE, file);
  if(!GET(access(file), READ)) return ERROR(NO_READ, file);
  if(objectp(obj = find_object(file)))
  {
    string err;
    if(dummy) return 1;
    if(err = catch(obj->remove()))
      ERROR("%s: remove error, hard destruct\n", file);
    if(objectp(obj)) destruct(obj);
  }
  else return 0;
  return 1;
}

