/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: telnetneg.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland MUDlib
//
// std/shells/filesys/telnetneg.c -- Verwaltung von Telnet-Negotiations
//
// Basierend auf Morgengrauen MUDlib
//
// Das Original wurde von Marcus@Tapp zur Verfuegung gestellt.
// Angepasst fuer die MG-Mudlib von Ringor@MG
//
// $Log: telnetneg.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//
// Revision 1.2  1999/09/07 18:20:21  Fiona
// Hauptcode nach secure verschoben
//
// Revision 1.1  1999/09/07 16:52:44  Fiona
// Initial revision
//

private variables inherit "/secure/telnetneg";

#pragma strict_types

#define NEED_PROTOTYPES

#include <properties.h>
#include <thing/properties.h>
#include <defines.h>
#include <telnet.h>

// Am Ende des Prompts immer ein EOR senden
static void modify_prompt() {
  string text;
  if (function_exists("renew_prompt", this_object()))
    this_object()->renew_prompt();
  else {
    if (!(text = QueryProp(P_PROMPT)) || text == "")
      text = "> ";
                
    if (mappingp(TN) && mappingp(TN["received"]) &&
      (TN["received"][TELOPT_EOR, 1] == DO))
      set_prompt(lambda(({}),
        ({ #'efun::binary_message,
           ({ #'+, ({ #'to_array, text }),
           ({ #'({, IAC, EOR }) }) })), this_object());
    else
      set_prompt(text, this_object());
  }
}

// for base.c only
static void startup_telnet_negs() {
  mapping sent, recd;
  mixed optargs;
  int i;
  mixed *xx;

  Set(P_TTY_TYPE, 0); // avoid ANY mistakes...
  TN = (mapping) previous_object()->query_telnet_neg(); // from login.c
  Terminals = (string*) previous_object()->query_terminals(); // from login.c

  // in login.c gibt es noch keine "echten" Properties - deshalb hier noch
  // einmal richtig setzen

  Set(P_TTY_COLS, previous_object()->Query(P_TTY_COLS));
  Set(P_TTY_ROWS, previous_object()->Query(P_TTY_ROWS));

  if (!TN) TN = ([]);
  
  if (!TN["sent"]) TN["sent"] = allocate_mapping(3,3);
  
  if (!TN["received"]) TN["received"] = allocate_mapping(3,3);
  
  sent = TN["sent"];
  recd = TN["received"];
  
  if (optargs = recd[TELOPT_NAWS,2]) {
    int c, l;
      
    if (sizeof(optargs) == 4) {
      if (!optargs[1]) c = optargs[0];
      else c = optargs[1] + optargs[0] * 256;
          
      if (c < 20) {
        c = 80;
        if (Query(P_TTY_SHOW))
          tell_object(this_object(), break_string("Dein Fenster ist "
            "schmaler als 20 Zeichen? Du scherzt. ;-) Ich benutze den "
            "Standardwert von 80 Zeichen.", BS_STDLEN,
            "Hurrikap teilt Dir mit: ", BS_FOR_COMM));
      }
      
      if (!optargs[3]) l = optargs[2];
      else l = 256 * optargs[2] + optargs[3];
          
      if (l > 100) {
        l = 100;
        if (Query(P_TTY_SHOW))
          tell_object(this_object(), break_string("Tut mir leid, aber ich "
            "kann nur bis zu 100 Zeilen verwalten.", BS_STDLEN,
            "Hurrikap teilt Dir mit: ", BS_FOR_COMM));
      }
          
      if (l < 3) {
        l = 24;
        if (Query(P_TTY_SHOW))
          tell_object(this_object(), break_string("Du willst weniger als "
            "drei Zeilen benutzen? Glaub ich Dir nicht - ich benutze "
            "den Standardwert von 24 Zeilen.", BS_STDLEN,
            "Hurrikap teilt Dir mit: ", BS_FOR_COMM));
      }
      
      if (((int) Query(P_TTY_ROWS) != l) ||
        ((int) Query(P_TTY_COLS) != c)) {
        Set( P_TTY_ROWS, l );
        Set( P_TTY_COLS, c );
        if (Query(P_TTY_SHOW))
          tell_object(this_object(), break_string("Du hast Deine "
            "Fenstergroesse auf "+l+" Zeilen und "+c+" Spalten geaendert.",
            BS_STDLEN, "Hurrikap teilt Dir mit: ", BS_FOR_COMM));
      }
    }
  }
  
  if (recd[TELOPT_TTYPE,2]) {
    if (!sizeof(Terminals)) return;
      
    if (Terminals[0][0..3] == "dec-") Terminals[0] = Terminals[0][4..];
      
    if (Terminals[0] == "linux") Terminals[0] = "vt100";
      
    Set(P_TTY_TYPE, Terminals[0]);
  }
}

