/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: holger.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
//  Holger@Wunderland 21.08.1998
//
//  Anfang einer eigenen Shell.
//
//  Extra-Kommandos:
//  - hhilfe
//      zeigt einen Hilfetext fuer die Shell an
//  - watchprop [-ie] [property]
//      Schaltet eine generelle Propertie-Ueberwachung
//      fuer ein eignes Propertie ein oder aus und gibt
//      alle oder nur in/externe 'Set' und 'Query' darauf aus
//
// 15.01.1999: Alternativ unsichtbares Einloggen moeglich
//

#pragma strong_types

inherit "std/shells/magier";

#define NEED_PROTOTYPES

#include <properties.h>
#include <config.h>
#include <wizlevels.h>
#include <defines.h>

#define MYVERSION "V0.2"
#define MYSAVE "/"WIZARDDIR"/"+getuid(ME)+"/.hshrc"

static mixed tempvar;
static mapping mydebug;

void create() {
  if(!clonep(ME))
    return;
  ::create();
}

// rc-File

private void _load_rc_() {
  if(mappingp(mydebug)) return;
  if(!stringp(tempvar=read_file(MYSAVE))) {
    mydebug=([]);
    return;
  }
  tell_object(this_object(), MYSAVE" gelesen.\n\n");
  tempvar=efun::explode(tempvar, "\n");
  // mydebug setzen aus Zeile 0
  tempvar = efun::explode(tempvar[0]," ")-({""});
  if(sizeof(tempvar)) {
    tempvar = transpose_array(map_array(tempvar, #'efun::explode, "::"));
    mydebug = mkmapping(tempvar[0],tempvar[1]);
  }
  else mydebug=([]);
}

private void _save_rc_() {
  mixed tmp;
  if(!mappingp(mydebug)) {
    tell_object(this_object(), "Schwerer Fehler in Deiner Shell!!!\n");
    return;
  }
  // mydebug schreiben
  tempvar=({});
  tmp = unmkmapping(mydebug);
  while(sizeof(tmp[0])) {
    tempvar += ({tmp[0][<1]+"::"+tmp[1][<1]});
    tmp = ({tmp[0][0..<2],tmp[1][0..<2]});
  }
  rm(MYSAVE);
  if(!sizeof(tempvar)) return;
  tempvar=implode(tempvar, " ")+"\n";
  if(!write_file(MYSAVE, tempvar))
    tell_object(this_object(), "Konnte "MYSAVE" nicht schreiben!\n");
}

// Propertie-Ueberwachung

static int allowed(); // Prototype (Fun ist in /std/thing/properties.c)

varargs private mixed extern(int flag) {
  if(!flag)
    return sizeof(filter_array(caller_stack(), #'!=, ME));
  return filter_array(caller_stack(), #'!=, ME);
}

varargs mixed Set(string name, mixed Value, int Type) {
  if(mappingp(mydebug) && member(mydebug, name)) {
    if(mydebug[name]=="a" ||
      (mydebug[name]=="e" && extern()) ||
      (mydebug[name]=="i" && !extern()))
      tell_object(ME, 
        sprintf("*** SET %s   : %O\n"
                "*** Value          : %O\n"
                "*** Type           : %O\n"
                "*** PO -- TP       : %O -- %O\n\n",
          (extern()?"(extern)":"(intern)"),
          name,
 Value,
 Type,
 previous_object(),
 this_player() ));
  }

  // Sicherheit aus thing/properties.c wiederherstellen
  if(extern_call() && previous_object()!=this_object() && !allowed() &&
     (prop[F_MODE][name] & (PROTECTED|SECURED)))
    return -1;
  if(prop[F_MODE][name] & SECURED && Type == F_MODE && Value & SECURED)
    return -2;

  return ::Set(name,Value,Type);
}

varargs mixed Query(string name, int Type) {
  if(mappingp(mydebug) && member(mydebug, name)) {
    if(mydebug[name]=="a" ||
      (mydebug[name]=="e" && extern()) ||
      (mydebug[name]=="i" && !extern()))
      tell_object(ME,
        sprintf("*** QUERY %s : %O\n"
                "*** Type           : %O\n" 
                "*** PO -- TP       : %O -- %O\n\n",
          (extern()?"(extern)":"(intern)"),
          name,  Type,  previous_object(),  this_player() )); 
  } 
  return ::Query(name, Type);
}

static int _watchprop_(string arg) {
  string opt;
  mixed tmp;
  notify_fail("SYNTAX: watchprop [-ei] <string>\n");
  if(!stringp(arg) || !strlen(arg)) {
    if(!sizeof(mydebug))
      tell_object(ME,"Ueberwachung aus. SYNTAX: watchprop [-ei] <string>\n");
    else 
{
      tempvar="";
      tmp = unmkmapping(mydebug);
      while(sizeof(tmp[0])) {
        switch(tmp[1][<1]) {
          case "a":
            tempvar += "  "+tmp[0][<1]+" - alles \n";
            break;
          case "e":
            tempvar += "  "+tmp[0][<1]+" - extern\n";
            break;
          case "i":
            tempvar += "  "+tmp[0][<1]+" - intern\n";
            break;
        }
        tmp = ({tmp[0][0..<2],tmp[1][0..<2]});
      }
      tell_object(ME,"Ueberwachung aktiv fuer:\n"+tempvar);
    }
    return 1;
  }
  tempvar=efun::explode(arg," ")-({""});
  switch(sizeof(tempvar)) {
    case 1:
      if(tempvar[0][0]=='-') return 0;
      arg=tempvar[0];
      break;
    case 2:
      if(tempvar[0][0]!='-' || strlen(tempvar[0])!=2) return 0;
      arg=tempvar[1];
      opt=tempvar[0][1..1];
      if(opt!="e" && opt!="i") return 0;
      break;
    default: return 0;
  }
  if(!member(mydebug, arg)) {
    tell_object(ME,"Ueberwachung von '"+arg+"' aktiviert.\n");
    mydebug+=([arg:(stringp(opt)?opt:"a")]);
  }
  else {
    if(stringp(opt) && mydebug[arg]!=opt) {
      tell_object(ME,"Ueberwachung von '"+arg+"' geaendert.\n");
      mydebug[arg]=opt;
    }
    else {
      tell_object(ME,"Ueberwachung von '"+arg+"' deaktiviert.\n");
      mydebug=m_delete(mydebug, arg);
    }
  }
  _save_rc_();
  return 1;
}

// Hilfetext

static int _hhilfe_(string argl) {
  notify_fail("Argumente werden nicht unterstuetzt.\n");
  if(stringp(argl))
    return 0;
  tell_object(this_object(),
    "Holgers Shell "MYVERSION".\n"
    "Folgende zusaetzliche Kommandos stehen Dir zur Verfuegung:\n"
    "  hhilfe                   - bringt diesen Text.\n"
    "  watchprop [-ei] <string> - ueberwacht Propertiestring <string>\n"
    "                             -e zeigt nur externe Zugriffe an.\n"
    "                             -i zeigt nur interne Zugriffe an.\n");
  return 1;
}

// Lokale Kommandos

static mixed *_query_localcmds() {
  return ({
    ({"watchprop","_watchprop_",0,WIZARD_LVL}),
    ({"hhilfe","_hhilfe_",0,LEARNER_LVL})
  })+::_query_localcmds();
}

// Unsichtbar einloggen

static void wanna_be_invis(string ans) {
  if(stringp(ans) && ans[0]=='j')
    SetProp(P_INVIS, 1);
  else
    SetProp(P_INVIS, 0);
  ::move_player_to_start2(tempvar);
  tempvar=0;
}

static void move_player_to_start2(string where) {
  tell_object(ME, "Holgers Shell "MYVERSION". Hilfe mit 'hhilfe'.\n\n"); 
  _load_rc_();
  // Beim renewen NIEMALS fragen
  if(previous_object()!=find_object(MASTER)) {
    tempvar=where;
    write("Willst Du nach dem Einloggen gleich unsichtbar sein? (j/[n])\n"); 
    input_to("wanna_be_invis");
    return;
  }
  ::move_player_to_start2(where);
}

// Selbstschutz :-)

int remove(int silent) { 
  object r, o; 
  r=this_interactive(); 
  o=this_object();
  if(clonep(o) && interactive(o) && (r!=o) && 
      query_wiz_level(r)<=query_wiz_level(o) ) { 
      tell_object(r, "Das war keine gute Idee...\n"); 
      tell_object(o, "*** "+capitalize(getuid(r))+" wollte Dich removen! ***\n"); 
      return 1; 
    } 
  return ::remove(silent); 
}

