/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: magier.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. MUDlib
//
// SHELLS/MAGIER.C -- magier shell
//
// $Log: magier.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/05 12:39:44  Largo
// Initial revision
//

#pragma strong_types

inherit "std/player/base";
inherit "/std/shells/filesys/filesys";
inherit "/std/player/objects";

#define NEED_PROTOTYPES

#include <thing/properties.h>
#include <properties.h>
#include <wizlevels.h>
#include <moving.h>
#include <attributes.h>
#include <combat.h>
#include <defines.h>
#include <ansi.h>
#include <udp.h>
#include <player/stat.h>
#include <homes.h>
#include <living/life.h>
#include <health.h>

#define LEARNING() QueryProp(P_WANTS_TO_LEARN)

#define IDLE_MAX 18000

static string my_snooper;
static object snoopee;
static int _hbstop;
static int _age;

void create()
{
  if (!clonep())
    return;
  
  base::create();
  Set(P_RACE, SAVE, F_MODE);
  Set(P_ZAP_MSG, SAVE, F_MODE);
  Set(P_TRANK_FINDEN, SAVE, F_MODE);
  Set(P_CLONEMSG, SAVE, F_MODE);
  Set(P_CLONEFMSG, SAVE, F_MODE);
  Set(P_DESTMSG, SAVE, F_MODE);
  Set(P_DESTFMSG, SAVE, F_MODE);
//  Set(P_HANDS, SAVE, F_MODE);
  Set(P_SHORT_CWD, SAVE, F_MODE);
  SetDefaultHome( MAGIER_HOME );
  SetProp(P_ENEMY_DEATH_SEQUENCE,
	  ([17:"Der Tod schuettelt verstaendnislos den Kopf.\n\n",
	    18:"Der Tod sagt: WIESO MUSSTEST DU DICH AUCH UNBEDINGT MIT EINEM MAGIER ANLEGEN?\n\n"]));

  SetProp(P_MAX_STATS, ({50, 50, 50, 50, 50}));
  SetProp(P_STAT_FACTOR, ({10, 10, 10, 10, 10}));

  SetProp(P_ALCOHOL_DELAY, ALCOHOL_DELAY);
  SetProp(P_FOOD_DELAY, FOOD_DELAY);
  SetProp(P_DRINK_DELAY, DRINK_DELAY);
  SetProp(P_HEAL_DELAY, HEAL_DELAY);
  SetProp(P_POISON_DELAY, POISON_DELAY);

  SetProp(P_MAX_FOOD, MAX_FOOD);
  SetProp(P_MAX_DRINK, MAX_DRINK);
  SetProp(P_MAX_ALCOHOL, MAX_ALCOHOL);
}

static string _query_racedescr()
{
  return "Magier koennen einfach alles. Aber manche Magier koennen mehr.\n";
}

string _query_race()
{
  if (previous_object() && previous_object()->query_login_object())
    return 0;

  return Query(P_RACE) ? Query(P_RACE) : Set(P_RACE, "Magier");
}

string *_query_racestring() {
    return ({"Magier","Magiers","Magier","Magier"});
}

static int zap(string str)
{
  object opfer;
  string* message;

  if (!str || !LEARNING()) return 0;
  if (opfer=present(str))
  {
    if (living(opfer))
    {
      message = QueryProp(P_ZAP_MSG);
      if (!pointerp(message) || sizeof(message)!=3)
      {
	say(this_player()->name() +" beschwoert einen Blitz vom Himmel.\n");
	write("Du zappst "+opfer->name(WEN,2)+".\n");
      }
      else
      {
	write(parse_mess(message[0], opfer));
	say(parse_mess(message[1], opfer), ({this_player(), opfer}));
	tell_object(opfer, parse_mess(message[2], opfer));
      }
      opfer->do_damage(random(QueryProp(P_HANDS)[1]),this_object());
      return 1;
    }
    else
    {
      write("Aber "+capitalize(str)+" lebt nicht.\n");
      return 1;
    }
  }
  else
  {
    write("Sowas siehst Du hier nicht.\n");
    return 1;
  }
}

static int peace(string name)
{
  object obj, *enem;

  if (!LEARNING())
    return 0;
  if (!name)
  {
    for (obj=first_inventory(environment());obj;
	 obj=next_inventory(obj))
      obj->StopHuntingMode();
  }
  else
  {
    obj=find_living(name);
    if (!obj)
    { 
      write("Kein solches Lebewesen im Spiel.\n");
      return 1;
    }
    for(enem=(object *)obj->StopHuntingMode()[0];sizeof(enem);enem=enem[1..])
      enem[0]->StopHuntFor(obj);
  }
  write("Ok.\n");
  return 1;
}

static int traenke()
{
  if(SetProp(P_TRANK_FINDEN, !QueryProp(P_TRANK_FINDEN)))
    write("Du kannst jetzt Zaubertraenke finden.\n");
  else
    write("Du findest jetzt keine Zaubertraenke mehr.\n");
  return 1;
}

mixed verfolger()
{
  mixed *pur;

  if (!pointerp(pur=QueryProp(P_PURSUERS)))
    return 0;
  else
    return pur[0];
}

int verfolge(string str)
{
  mixed *pur, lv,lv2;
  
  if (!LEARNING())
    return 0;
  if (!str || str=="")
  {
    write("Verfolgungsmodus abgeschaltet.\n");
    if (!pointerp(pur=Query(P_PURSUERS)))
      return 1;
    if (pur[0])
      pur[0]->RemovePursuer(ME);
    return 1;
  }
  str=lower_case(str);
  if (intp(lv=match_living(str))||!lv)
  {
    write("Kein solches Wesen gefunden.\n");
    return 1;
  }
  if (objectp(lv))
    lv2=lv;
  else
  {
    lv2=find_player(lv);
    if (!lv2)
      lv2=find_living(lv);
  }
  if (!lv2)
  {
    write("Hm, irgendwas geht schief :(\n");
    return 1;
  }
  lv2->AddPursuer(ME);
  write("Ok, Du verfolgst jetzt "+lv2->name(WEN)+".\n");
  lv2->TakeFollowers();
  return 1;
}

void heart_beat()
{
  mixed *en;
  
//  if (!(en=QueryEnemies())||!sizeof(en[0])&&Query(P_WANTS_TO_LEARN))
//  {
//    set_heart_beat(0);
//    return;
//  }
  base::heart_beat();  // alle tests jetzt hier
}

int MayAddWeight() { return 0;}

varargs int remove()
{
  string work;
  object env;
  work = "/players/" + geteuid() + "/workroom";
  if ((env=environment(ME)) && file_name(env)!=work)
    catch(move(work, M_GO, "nach Hause"));
  return (int)base::remove();
}

mixed level_sort(mixed list)
{
  mixed *sorted_arr;
  int i;
  sorted_arr = ({ ({ }),({ }) });
  for (i=sizeof(list)-1;i>=0;i--)
  {
    sorted_arr[0] += ({ list[i]->QueryProp(P_LEVEL) });
    sorted_arr[1] += ({ list[i] });
  }
  sorted_arr = order_alist(sorted_arr);
  return sorted_arr[1];
}

static int pwho()
{
  object* user;
  mixed* spieler;
  int i;
  if (!IS_WIZARD(this_player()))
    return 0;
  user = users();
  spieler = ({ });
  for (i=sizeof(user)-1; i>=0; i--)
    if (!IS_LEARNER(user[i]))
      spieler += ({ user[i] });
  spieler = level_sort(spieler);
  printf("Lvl Name         Erfahrung   QP  Int Str Dex Con WC   AC    HP  (max)\n");
  write("--------------------------------------------------------------------------\n");
  for (i=sizeof(spieler)-1; i>=0; i--)
    printf("%3d %-12s %8d %5d %3d %3d %3d %3d %4d %4d  %4d (%4d)\n",
	   spieler[i]->QueryProp(P_LEVEL),
	   capitalize(getuid(spieler[i])),
	   spieler[i]->QueryProp(P_XP),
	   spieler[i]->QueryProp(P_QP),
	   spieler[i]->QueryRealStat(A_INT),
	   spieler[i]->QueryRealStat(A_STR),
	   spieler[i]->QueryRealStat(A_DEX),
	   spieler[i]->QueryRealStat(A_CON),
	   spieler[i]->QueryProp(P_TOTAL_WC),
	   spieler[i]->QueryProp(P_TOTAL_AC),
	   spieler[i]->QueryProp(P_HP),
	   spieler[i]->QueryProp(P_MAX_HP));
  return 1;
}


//#@#@#@#@#@

static void initialize() {
  filesys::initialize();
}

static int allow_snoop(string str)
{ 
  object ob;
  
  if (!str)
  { 
    if (!my_snooper) return 0;
    str=my_snooper;
    my_snooper=0;
    write("Ok, "+capitalize(str)+" Erlaubnis zum Snoopen entzogen.\n");
    ob=query_snoop(this_player());
    if (!ob) return 1;
    if (getuid(ob) != str) return 1;
    tell_object(ob,capitalize((string)name(WER))
		+" zwingt Dich, mit dem Snoopen aufzuhoeren.\n");
    snoop(ob);
    return 1;
  }
  if (my_snooper) allow_snoop(0); /* Remove the other first ! */
  str=lower_case(str);
  ob=find_player(str);
  if (!ob){
    write("Kein solcher Spieler.\n");
    return 1;
  }
  if (query_wiz_grp(ob)>query_wiz_grp(this_player())){
    write("Level des Snoopers groesser als Deiner.\n");
    return 1;
  }
  write("Ok !\n");
  my_snooper=str;
  return 1;
}

nomask int QueryAllowSnoop(object who)
{
  return getuid(who) == my_snooper;
}

static int snoop_on(string str)
{
  object ob;
  string flags, plname;
  int fl;
  
  if (!str) {
    if (snoopee && objectp(snoopee))
    {
      tell_object(snoopee, this_player()->name(WER)+" beobachtet Dich nicht mehr.\n");
      snoopee = 0;
    }
    snoop(this_player());  /* Abort snoop */
    return 1;
  }
  if (!LEARNING())
    return 0;
  fl=0;
  if (sscanf(str,"%s %s", plname, flags)==2 && flags!="")
  {
    str=plname;
    while (strlen(flags)) {
      switch (flags[0])
      {
	case 'l':
	  fl|=SF_LOCKED; 
	  break;
	case 'f':
	  fl|=SF_FORCE;
	  break;
	default:
	  printf("Unbekanntes Flag %s ignoriert.\n",flags[0..0]);
      }
      flags=flags[1..];
    }
  }
  SetProp(P_SNOOPFLAGS,fl);
  ob = find_player(str);
  if (!ob) {
    write("Spieler "+capitalize(str)+" nicht gefunden.\n");
    return 1;
  }
  if (!snoop(this_player(),ob))
  {
    write("Du kannst "+ob->name(WEN)+" nicht snoopen !\n");
    return 1;
  }
  if ((ob!=snoopee) && (snoopee && objectp(snoopee)))
    tell_object(snoopee, this_player()->name(WER)+" beobachtet Dich nicht mehr.\n");
  write("Du snoopst jetzt "+ob->name(WEN)+".\n");
  if (ob!=snoopee)
  {
    tell_object(ob, "Du wirst jetzt von "+ME->name(WER)+" beobachtet.\n");
  }
  snoopee = ob;
  return 1;
}

static int trans(string str) {
  object living;

  if (!LEARNING())
    return 0;
  if (!str) {
    notify_fail("Trans WEN?\n");
    return 0;
  }
  str=match_living(str,0);
  if (!stringp(str))
    switch (str)
    {
      case -1: write("Das war nicht eindeutig.\n"); return 1;
      case -2: write("So ein Wesen gibt es nicht.\n"); return 1;
    }
  if((living=find_living(str)))
  {
    if (query_wiz_level(living) > query_wiz_level(this_object()))
    {
      write(capitalize(living->name(WEN)) + " kannst Du nicht teleportieren!\n");
      tell_object(living, capitalize(name(WER)) + " hat versucht, Dich zu teleportieren, hat aber versagt!\n");
      return 1;
    }
    tell_object(living,
		"Ein seltsames Gefuehl ueberkommt Dich ...\n"
		+"Du verlierst die Orientierung ...\n");
    if (living->move(file_name(environment(ME)),M_TPORT|M_NOCHECK)<=0)
    {
      write(living->name(WER)+" will nicht kommen !\n");
      tell_object(living,name(WER)+
		  " wollte Dich teleportieren, hat aber versagt !\n");
      return 1;
    }
    write("OK.\n");
  }
  return 1;
}

static int force_someone(string str)
{
  object living;
  string what, rest;
  string living_name;

  if (!LEARNING())
    return 0;
  if( !str || sscanf( str, "%s %s", living_name, what ) != 2 )
  {
    notify_fail("Zwinge WEN zu WAS?\n");
    return 0;
  }
  if( sscanf( what, "zu %s", rest ) == 1 )
    what = rest;
  if (!(living = find_living(living_name)))
  {
    write("Kein solches Lebewesen gefunden!\n");
    return 1;
  }
  if (living->command_me(what))
  {
    write("Hat geklappt!\n");
    if (!IS_LEARNER(living))
      tell_object(living,sprintf("%s zwingt Dich zu: %s\n",
				 this_object()->name(WER),what));
  }
  else
    write("Hat nicht geklappt!\n");
  return 1;
}

static int wiz_score_list(string arg) {
  if (arg) wizlist(arg);
  else wizlist();
  return 1;
}

static int echo_all(string str) {
  if (!LEARNING())
    return 0;
  if (!str) {
    write("Was moechtest Du 'echoallen'?\n");
    return 1;
  }
  shout( str + "\n");
  write( str + "\n");
  return 1;
}

static int echo_to(string str)
{
  object ob;
  string who;
  string msg;

  if (!LEARNING())
    return 0;
  if (!str || sscanf(str, "%s %s", who, msg) != 2) {
    write("Was moechtest Du 'echoen' ?\n");
    return 1;
  }
  ob = find_living(lower_case(who));
  if (!ob) {
    write("Kein Spieler mit diesem Namen eingeloggt.\n");
    return 1;
  }
  tell_object(ob, msg + "\n");
  write( ob->name(WEN)+"->" + msg + "\n");
  return 1;
}

static int mecho_all(string str)  {
  object *who;
  int i;

  if (!LEARNING())
    return 0;
  notify_fail("Was moechstest Du denn allen Magiern zukommen lassen?\n");
  if (!str) return 0;
  who=users();
  for (i=0; i<sizeof(who); i++)
    if (IS_SEER(who[i]))
      tell_object(who[i], break_string(str,BS_STDLEN));
  return 1;
}

static int local_commands() 
{
  if (!LEARNING())
    return 0;
  localcmd();
  return 1;
}

private static string prettyfile(string str) {
  if (!str) return 0;
  if (str[0..2] == "/d/") return "+"+str[3..<1];
  if (str[0..8] == "/players/") return "~"+str[9..<1];
  return str;
}

private static int cmp_user(object i,object j)
{
  return query_ip_number(i) > query_ip_number(j);
}

static int list_peoples_wiz() 
{
  mixed *list;
  int i, a;
  string a_age,a_ipnum,a_name,a_level,a_idle,a_room,a_end, a_title;

  if (!LEARNING())
    return 0;
  switch(QueryProp("tty")) {
    case "vt100":
    a_ipnum = ""; a_name = ANSI_BOLD; a_level = ANSI_NORMAL;
    a_idle = ANSI_BLINK; a_room = ANSI_NORMAL; a_end = ANSI_NORMAL;
    a_title = ANSI_INVERS; a_age = ANSI_NORMAL;
    break;
    case "ansi":
    a_ipnum = ANSI_GREEN; a_name = ANSI_YELLOW; a_level = ANSI_RED;
    a_idle = ANSI_WHITE; a_room = ANSI_CYAN; a_end = ANSI_NORMAL;
    a_title = ANSI_INVERS; a_age = ANSI_PURPLE;
    break;
    default:
    a_title = a_ipnum = a_name = a_level = a_idle = a_room = a_end = "";
    a_age = "";
  }

  list = sort_array( users(), #'cmp_user );
  write(a_title+"There are now " + sizeof(list) + " players");
  for (i=0, a=0; i < sizeof(list); i++)
    if (query_idle(list[i]) >= 5 * 60)
      a++;
  if (a)
    write(" (" + (sizeof(list) - a) + " active)");
  write(". " + query_load_average() + a_end+ "\n");
  for(i=0; i<sizeof(list); i++) {
    string name_;
    name_ = list[i]->query_real_name();
    if (!name_)
      name_ = "<logon>";
    name_ = capitalize(name_);
    if (list[i]->QueryProp(P_INVIS))
      name_ = "(" + name_ + ")";
    printf( "%s%-15s%s %s%-13s%s %s%3d%s %s",
	   a_ipnum, query_ip_number(list[i]),a_end,
	   a_name, name_,a_end,
	   a_level, MASTER->get_wiz_level(getuid(list[i])),a_end,
	   a_age
	   );
    a = list[i]->QueryProp(P_AGE);
    if (a / 43200 > 0)
      printf( "%3d D", a / 43200 );
    else if (a / 1800 > 0)
      printf( "%3d h", a / 1800 );
    else
      printf( "%3d m", a / 30 );
    if (query_idle(list[i]) >= 5 * 60)
      write(a_idle+" I");
    else
      write("  ");
		write(a_end);
    if (query_editing(list[i]))
      write(a_idle+"E"+a_end);
    else
      write(" ");

    if (query_input_pending(list[i]))
      write(a_idle+"M "+a_end);
    else
      write("  ");

    if (environment(list[i]))
      write(a_room+prettyfile(file_name(environment(list[i]))));
    write(a_end+"\n");
  }
  return 1;
}

/*
 * Temporary move the player to another destination and execute
 * a command.
 */

static int in_room(string str)
{
  object room;
  object old_room;
  string cmd;
  if (!str || !LEARNING())
    return 0;
  if (sscanf(str, "%s %s", room, cmd) != 2) {
    write("Usage: in ROOM CMD\n");
    return 1;
  }
  if (!room) {
    write("Fehlerhafter Dateiname.\n");
    return 1;
  }
  old_room = environment();
  move_object(room);
  command(cmd);
  if (old_room) move_object(old_room);
  else write("Rueckkehr nicht gelungen.\n");
  return 1;
}

static int shut_down_game(string str)
{
  if (!IS_ELDER(ME) || ME!=this_interactive())
    return 0;
  notify_fail("Du musst einen Grund dafuer angeben.\n");
  if (!str) return 0;
  shutdown(str);
  return 1;
}

static int at_player(mixed dest)
{
  object ob,old_room;
  mixed ret;
  string cmd;
  
  if (!LEARNING())
    return 0;
  if (!dest) {
    write("Wohin moechtest Du Dich teleportieren?\n");
    return 1;
  }
  if (sscanf(dest, "%s %s", dest, cmd) != 2) {
    write("Usage: at LIVING CMD\n");
    return 1;
  }
  ob = find_living(dest);
  if (!ob)
  {
    dest=match_living(dest,1);
    if (stringp(dest))
      dest = find_living(dest);
    if (objectp(dest))
      ob=environment(dest);
    else
      ob=0;
  } else
    ob=environment(ob);
  if (!ob)
  {
    notify_fail("Lebewesen nicht gefunden.\n");
    return 0;
  }
  old_room=environment(this_object());
  move_object(ob);
  command(cmd);
  if (old_room) move_object(old_room);
  else write("Rueckkehr nicht gelungen.\n");
  return 1;
}

static int teleport(string dest) {
  object ob;
  string path;
  mixed ret;

  if (!LEARNING())
    return 0;
  if (!dest) {
    write("Wohin moechtest Du Dich teleportieren?\n");
    return 1;
  }
  if (verfolger())
    verfolge("");
  ob = find_living(dest);
  if (ob) {
    ob = environment(ob);
    move(file_name(ob),M_TPORT|M_NOCHECK);
    return 1;
  }
  path=(mixed)MASTER->_get_path(dest,getuid(this_object()));
  ret=catch(call_other(path,"?"));
  if (ret && file_size(path)<0)
  {
    dest=match_living(dest,1);
    if (stringp(dest))
    {
      ob = environment(find_living(dest));
      move(file_name(ob),M_TPORT|M_NOCHECK);
      return 1;
    }
    printf("Fehler beim Teleport nach %O: No such file.\n",path);
    return 1;
  } 
  if (ret)
    printf("Fehler beim Teleport nach %O: %O\n",dest,ret);
  ret=catch(move(path,M_TPORT|M_NOCHECK));
  if (stringp(ret))
    ret=implode(explode(ret,"\n"),"");
  if (ret)
    printf("Fehler beim Teleport nach %O: %O\n",dest,ret);
  return 1;
}

static int disconnect(string str)
{
  if(!str || !LEARNING())
    return ::disconnect(str);
  write("\"schlafe ein\" gibts fuer Magier nicht mehr.\n");
  return quit();
}

static int heal(string name)
{
  object ob;
  string it;

  if (!LEARNING())
    return 0;
  if (!name) return 0;
  it = lower_case(name);
  ob = find_living(it);
  if (!ob) {
    write("Dieser Spieler ist momentan nicht da.\n");
    return 1;
  }
  if (!IS_LEARNER(ob) && !ob->QueryProp(P_TESTPLAYER))
    log_file("HEAL", 
	     sprintf("%s heilt %s (%s) %s\n", 
		     capitalize(geteuid(this_player())),
		     call_other(ob,"name"), capitalize(geteuid(ob)),
		     dtime(time())));
  ob->heal_self(1000000);
  tell_object(ob, QueryProp(P_NAME) + " heilt Dich.\n");
  write("Ok.\n");
  return 1;
}

static int go_home() 
{
  if (!LEARNING())
    return 0;
  if (environment(this_object()) && 
      file_name(environment(this_object()))=="/players/"+ getuid() +"/workroom")
  {
    write("Du bist schon zu Hause.\n");
    return 1;
  }
  return (int)move("players/" + getuid() + "/workroom", 
                   M_GO, "nach Hause");
}

static int add_domain_master(string str)
{
  string master, domain;

  if (this_object() != this_interactive() || 
      !IS_ARCH(this_interactive()))
  {
    write("Das darfst Du nicht !\n");
    return 1;
  }
  notify_fail("Syntax: addmaster <user> <domain>\n");
  if (!str) return 0;
  if (sscanf(str,"%s %s",master,domain)!=2) return 0;
  if (!master || !domain) return 0;
  if (!"/secure/master"->add_domain_master(master,domain))
    write("Hat nicht funktioniert.\n");
  else 
    write("Ok.\n");
  return 1;
}

static int remove_domain_master(string str)
{
  string master, domain;

  if (this_object() != this_interactive() || 
      !IS_ARCH(this_interactive()))
  {
    write("Das darfst Du nicht !\n");
    return 1;
  }
  notify_fail("Syntax: removemaster <user> <domain>\n");
  if (!str) return 0;
  if (sscanf(str,"%s %s",master,domain)!=2) return 0;
  if (!master || !domain) return 0;
  if (!"/secure/master"->remove_domain_master(master,domain))
    write("Hat nicht funktioniert.\n");
  else
    write("Ok.\n");
  return 1;
}

static int invis()
{
  if (!LEARNING())
    return 0;
  if (QueryProp(P_INVIS))
  {
    write("Du warst schon unsichtbar.\n");
    return 1;
  }
  say(capitalize(getuid(this_object()))+" "+ QueryProp(P_MMSGOUT)+".\n");
  SetProp(P_INVIS, 1);
  write("Du bist jetzt unsichtbar.\n");
  return 1;
}

static int vis()
{
  if (!QueryProp(P_INVIS))
  {
    write("Du warst schon sichtbar.\n");
    return 1;
  }
  say(capitalize(getuid(this_object()))+" "+ QueryProp(P_MMSGIN)+".\n");
  SetProp(P_INVIS, 0);
  write("Du bist jetzt sichtbar.\n");
  return 1;
}

int mschau(string str)
{
  if (this_interactive()!=ME)
    return 0;
  if ( str == "ja" || str == "an" )
  {
    if ( Query(P_WANTS_TO_LEARN) )
      write ( "Du hast den Magier-Mode schon an !\n");
    else
      write( "Du hast jetzt den Magier-Modus eingeschaltet.\n" );
    SetProp(P_WANTS_TO_LEARN, 1);
  }
  else if ( str == "nein" || str == "aus" )
  {
    if ( Query(P_WANTS_TO_LEARN) )
      write( "Ok, Magier-Mode aus.\n" );
    else
      write( "Magier-Mode war schon aus.\n");
    SetProp(P_WANTS_TO_LEARN, 0);
  }
  else
    write( "Was willst Du? 'mschau an' oder 'mschau aus'?\n" );
  return 1;
}

static int go_wiz_home(string str)
{
  int f;

  if (!LEARNING())
    return 0;
  str=query_verb();
  if (str[0]!='+') return 0;
  str=str[1..];
  str=explode(str," ")[0];
  if (catch(f=file_size("/players/"+str+"/workroom.c")) || f<=0)
  {
    printf("%shat keinen Workroom.\n",capitalize(str+" "));
    return 1;
  }
  if (catch(call_other("/players/"+str+"/workroom","???")))
  {
    write("Der Workroom hat Fehler.\n");
    return 1;
  }
  this_object()->move("/players/"+str+"/workroom",M_TPORT|M_NOCHECK);
  return 1;
}

static void FinalSetup() {
  SetProp(P_CURRENTDIR,"/players/"+getuid());
  initialize();
  if (IS_LEARNER(this_player())) cat("/etc/WIZNEWS");
  // set_heart_beat(0);
  call_out("_setup_profile", 1);
}

void _setup_profile() {
  string err, filename;
  filename="/players/"+getuid()+"/.profile.c";
  if( file_size(filename) > 0 ) {
    if (err=catch(call_other(filename,"setup",this_object())))
      printf("Error in %s: %s\n",filename,err);
  }
}

static int protect(string str)
{
  if (!LEARNING())
    return 0;
  if (this_object() != this_interactive())
    return 0;
  if (!str || str=="")
  {
    write("\"protect <propstring>\" toggelt das Protected-Flag.\n");
    return 1;
  }
  if (!Query(str) && !Query(str,F_MODE) && !Query(str,F_SET_METHOD) &&
      !Query(str,F_QUERY_METHOD))
  {
    write("Alle Werte dieser Property sind auf 0. Nichts gemacht.\n");
    return 1;
  }
  Set(str, PROTECTED, F_MODE);
  write(str+" ist jetzt "+(Query(str,F_MODE) & PROTECTED?"":"nicht ")+
	"protected.\n");
  return 1;
}

static int udpq(string str)
{
  string ret, mud, type;
  
  if (!LEARNING())
    return 0;
  if (!str || str=="" || sscanf(str,"%s %s",mud,type)<2)
  {
    write("Syntax: udpq mud type\n");
    return 1;
  }
  if (member(({"commands","email","hosts","inetd","list","mud_port","time",
	       "version"}),type)==-1)
    write("TYPEs: commands, email, hosts, inetd, list, mud_port, time, version\n");
  if (ret=INETD->send_udp(mud,([SENDER:getuid(this_object()), REQUEST:QUERY, DATA:type]),1))
    write(ret);
  else
    write("Anfrage abgeschickt.\n");
  return 1;
}

void reset()
{
  int idle;


  if (!query_once_interactive(this_object()))
    return;
  if (!interactive(this_object()))
  {
    this_object()->quit();
    if (this_object())
      remove();
    if (this_object())
      destruct(this_object());
    return;
  }
  if ((idle=query_idle(this_object())) > IDLE_MAX)
  {
    printf("%s war seit %d Minuten idle und wurde automatisch ausgeloggt.\n",
	   name(WER),query_idle(this_object()));
    write("Automatischer Logout wegen zu langer Idlezeit.\n");
    this_object()->quit();
    if (this_object())
      remove();
    if (this_object())
      destruct(this_object());
  }
}

static int ping(string str)
{
  object pl;

  if (!stringp(str)||!strlen(str))
  {
    notify_fail("Usage: ping <spielername>\n");
    return 0;
  }

  str = lower_case(str);
  if (!(pl = find_player(str)))
  {
    notify_fail("Spieler " + capitalize(str) + " nicht gefunden.\n");
    return 0;
  }
  if (pl == this_object())
  {
    notify_fail("Dich selbst anzupingen macht keinen Sinn!\n");
    return 0;
  }
  if (pl->Message(sprintf("%s pingt Dich an.%c\n", name(WER), 7), "ping") == 1)
  {
    write("Ok.\n");
  }
  return 1;
}

static int setplan(string str) {
	if (str) {
		notify_fail("Nur 'setplan' bitte.\n");
		return 0;
	}
	write("Wie soll Dein Plan denn sein?\n"
		"** oder . wenn fertig. ~q fuer Abbruch, ~h fuer eine Hilfeseite\n" );
	nedit("setplan2", 0);
	return 1;
}

static void setplan2(string str) {
	string filename;
	if (!str) {
		write("Abbruch.\n");
		return;
	}
	filename="/players/"+getuid()+"/.plan";
	if (file_size(filename)!=-1) { // .plan vorhanden
		if (!rm(filename)) {
			write("Fehler beim Loeschen des alten .plan\n");
			return;
		}
	}
	write_file(filename, str);
	write("Ok.\n");
}

static void upd_my_age() {
	if (!_age) { // Initialisieren
		_age=age;
		_hbstop=absolute_hb_count();
	}
	age=_age+absolute_hb_count()-_hbstop;
	_age=age;
	_hbstop=absolute_hb_count();
}

static int _query_age() {
	upd_my_age();
	return age;
}

void save_me(int i) {
  upd_my_age();
  base::save_me(i);
}

void Reconnect(int silent) {
  base::Reconnect();
  filesys::reconnect();
}

static mixed *_query_localcmds()
{
  return
    ({
      ({"localcmd","local_commands",0,LEARNER_LVL}),
      ({"zwinge","force_someone",0,LEARNER_LVL}),
      ({"heal","heal",0,LEARNER_LVL}),
      ({"heil","heal",1,LEARNER_LVL}),
      ({"goto","teleport",0,LEARNER_LVL}),
      ({"in","in_room",0,LEARNER_LVL}),
      ({"at","at_player",0,LEARNER_LVL}),  
      ({"shutdown","shut_down_game",0,ELDER_LVL}),
      ({"trans","trans",0,LEARNER_LVL}),
      ({"snoop","snoop_on",0,LEARNER_LVL}),
      ({"invis","invis",0,LEARNER_LVL}),
      ({"vis","vis",0,LEARNER_LVL}),
      ({"sallow","allow_snoop",0,LEARNER_LVL}),
      ({"zap","zap",0,LEARNER_LVL}),
      ({"peace","peace",0,LEARNER_LVL}),
      ({"mschau","mschau",1,LEARNER_LVL}),
      ({"verfolge","verfolge",0,LEARNER_LVL}),
      ({"frieden","peace",0,LEARNER_LVL}),
      ({"pwho","pwho",0,LEARNER_LVL}),
      ({"traenke","traenke",0,LEARNER_LVL}),
      ({"earmuffs","earmuffs",0,LEARNER_LVL}),
      ({"echoto","echo_to",0,LEARNER_LVL}),
      ({"echoall","echo_all",0,LEARNER_LVL}),
      ({"mecho","mecho_all",0,LEARNER_LVL}),
      ({"home","go_home",0,LEARNER_LVL}),
      ({"+","go_wiz_home",1,LEARNER_LVL}),
      ({"addmaster","add_domain_master",0,ARCH_LVL}),
      ({"removemaster","remove_domain_master",0,ARCH_LVL}),
      ({"people","list_peoples_wiz",0,LEARNER_LVL}),
      ({"udpq","udpq",0,LEARNER_LVL}),
      ({"setplan","setplan",0,WIZARD_LVL}),
      ({"ping","ping",0,LEARNER_LVL}),
	({"protect","protect",0,WIZARD_LVL})
    })+
      base::_query_localcmds()+objects::_query_localcmds()+
	filesys::_query_localcmds();
}

int QueryAllowSelect() {
 return 0;
}
