/*******************
** Eldarea MUDLib **
********************
**
** std/shells/player.c - standard player shell
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** CVS History
**
** $Log: human.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "std/player/base";

#include <properties.h>
#include <player/stat.h>
#include <homes.h>
#include <defines.h>
#include <living/life.h>
#include <health.h>

#define WEIGHT ([\
		30:64, 41:77, 52:100, 63:133, 74:181, 85:234,  96:289,\
		31:65, 42:79, 53:103, 64:137, 75:186, 86:239,  97:294,\
		32:65, 43:81, 54:106, 65:141, 76:191, 87:244,  98:299,\
		33:66, 44:83, 55:109, 66:145, 77:196, 88:249,  99:304,\
		34:67, 45:85, 56:112, 67:149, 78:201, 89:254, 100:309,\
		35:68, 46:87, 57:115, 68:153, 79:206, 90:259, 101:314,\
		36:69, 47:89, 58:118, 69:157, 80:211, 91:264, 102:319,\
		37:70, 48:91, 59:121, 70:162, 81:216, 92:269, 103:324,\
		38:71, 49:93, 60:124, 71:167, 82:221, 93:274, 104:329,\
		39:72, 50:95, 61:127, 72:171, 83:226, 94:279, 105:334,\
		40:75, 51:97, 62:130, 73:176, 84:231, 95:284, 106:349])

create() {
  ::create();

  SetDefaultHome(HUMAN_HOME);

  // OBSOLET STUFF
  SetPrayRoom(HUMAN_PRAYROOM);

  SetProp(P_MAX_STATS, ({
    24, /*Intelligenz*/
    26, /*Kraft*/
    25, /*Geschicklichkeit*/
    25, /*Ausdauer*/
    10 /*Charisma*/}));
  SetProp(P_STAT_FACTOR, ({
    10, /*Intelligenz*/
    10, /*Kraft*/
    10, /*Geschicklichkeit*/
    10, /*Ausdauer*/
    5 /*Charisma*/}));

  SetProp(P_ATTRIBUTES_OFFSETS, ({
     0, // Intelligenz
     0, // Kraft
     0, // Geschicklichkeit
     0, // Ausdauer
     0  // Charisma
  }));


  SetProp(P_ALCOHOL_DELAY, ALCOHOL_DELAY);
  SetProp(P_FOOD_DELAY, FOOD_DELAY);
  SetProp(P_DRINK_DELAY, DRINK_DELAY);
  SetProp(P_HEAL_DELAY, HEAL_DELAY);
  SetProp(P_POISON_DELAY, POISON_DELAY);

  SetProp(P_MAX_FOOD, MAX_FOOD);
  SetProp(P_MAX_DRINK, MAX_DRINK);
  SetProp(P_MAX_ALCOHOL, MAX_ALCOHOL);
}

string _query_race() {
  return "Mensch";
}

string *_query_race_string() {
  if(QueryProp(P_GENDER)==FEMALE)
    return ({"Menschenfrau","Menschenfrau","Menschenfrau","Menschenfrau"});
  return ({"Mensch","Menschen","Mensch","Menschen"});
}

_query_racedescr() {
  return "Obwohl die juengste unter den Rassen, haben sich die Menschen doch am"
    " weitesten ausgebreitet. Dies liegt an ihrer einzigartigen Moeglichkeit,"
    " sich an beinahe alle Umweltbedingungen schnell und gruendlich anzupassen."
    " Es existiert bei den Menschen kein solch herrausragendes Rassenmerkmal wie"
    " z.B. die Intelligenz und Langlebigkeit der Elfen oder die Staerke und Ausdauer"
    " der Zwerge. Es gibt innerhalb der menschlichen Rasse wohl alle moeglichen"
    " Kombinationen, von dumm bis hochintelligent ebenso wie von extrem stark bis"
    " zu extrem schwach.\n"
    "Ihre einzigartige Anpassungsfaehigkeit ermoeglicht es Menschen, in allen"
    " Gilden hervorragende Leistungen zu erbringen. So gibt es unter den Menschen"
    " sowohl grosse Kaempfer, flinke Diebe als auch maechtige Zauberer.";
}

int QueryAllowSelect() {
  return 1;
}

int QueryMinSize() {
  return 137;
}

int QueryMaxSize() {
  return 190;
}

int _get_weight(int size) {
  size=WEIGHT[to_int(size / 2.54)] / 2;
  return size*1000;
}
