/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: vampir.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. MUDlib
// basierend auf der Wunderland MUDlib
//
// Datei : /std/shells/vampir.c
// Info  : Die Vampir-Rasse.
//
// $Date: 1999/11/05 12:30:47 $
// $Revision: 1.1.1.1 $
// $Id: vampir.c,v 1.1.1.1 1999/11/05 12:30:47 elatar Exp $
// $Log: vampir.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/05 12:41:51  Big
// Initial revision
//

inherit "std/player/base";

#include <properties.h>
#include <player/stat.h>
#include <homes.h>
#include <defines.h>
#include <living/life.h>
#include <health.h>

#define WEIGHT ([\
                30:64, 41:77, 52:100, 63:133, 74:181, 85:234,  96:289,\
                31:65, 42:79, 53:103, 64:137, 75:186, 86:239,  97:294,\
                32:65, 43:81, 54:106, 65:141, 76:191, 87:244,  98:299,\
                33:66, 44:83, 55:109, 66:145, 77:196, 88:249,  99:304,\
                34:67, 45:85, 56:112, 67:149, 78:201, 89:254, 100:309,\
                35:68, 46:87, 57:115, 68:153, 79:206, 90:259, 101:314,\
                36:69, 47:89, 58:118, 69:157, 80:211, 91:264, 102:319,\
                37:70, 48:91, 59:121, 70:162, 81:216, 92:269, 103:324,\
                38:71, 49:93, 60:124, 71:167, 82:221, 93:274, 104:329,\
                39:72, 50:95, 61:127, 72:171, 83:226, 94:279, 105:334,\
                40:75, 51:97, 62:130, 73:176, 84:231, 95:284, 106:349])

void create ()
{
  ::create();

  SetDefaultHome(VAMPIR_HOME);
  SetPrayRoom(VAMPIR_PRAYROOM);

  SetProp(P_MAX_STATS, ({
    35, // Intelligenz
    35, // Kraft
    35, // Geschicklichkeit
    35, // Ausdauer
    35  // Charisma
  }));

  SetProp(P_STAT_FACTOR, ({
    10, // Intelligenz
    10, // Kraft
    10, // Geschicklichkeit
    10, // Ausdauer
    10  // Charisma
  }));

  SetProp(P_ATTRIBUTES_OFFSETS, ({
     2, // Intelligenz
    -2, // Kraft
     3, // Geschicklichkeit
     1, // Ausdauer
    -2  // Charisma
  }));

  SetProp(P_ATTRIBUTES_MODIFIER, ({
     0, // Intelligenz
     0, // Kraft
     0, // Geschicklichkeit
     0, // Ausdauer
     0  // Charisma
  }));

  SetProp(P_ALCOHOL_DELAY, ALCOHOL_DELAY);
  SetProp(P_FOOD_DELAY,    FOOD_DELAY);
  SetProp(P_DRINK_DELAY,   DRINK_DELAY);
  SetProp(P_HEAL_DELAY,    HEAL_DELAY);
  SetProp(P_POISON_DELAY,  POISON_DELAY);

  SetProp(P_MAX_FOOD,      MAX_FOOD);
  SetProp(P_MAX_DRINK,     MAX_DRINK);
  SetProp(P_MAX_ALCOHOL,   MAX_ALCOHOL);

  SetProp(P_NIGHTVISION,   1);
}

string _query_race ()
{
  return "Vampir";
}

string *_query_race_string ()
{
  if (QueryProp(P_GENDER) == 2)
    return ({"Vampirfrau", "Vampirfrau", "Vampirfrau", "Vampirfrau"});

  return ({"Vampir", "Vampire", "Vampir", "Vampire"});
}

_query_racedescr ()
{
  return "So lange man zurueckdenken kann gab es bereits Vampire. Sie mischten sich "
    "geschickt unter die Menschen und nur selten gelang es denen, einen Vampir zu "
    "enttarnen. Vampire sind fast unsterblich, da sie sich mit Hilfe ihrer besonderen "
    "Faehigkeiten aus jeder nur denkbaren Siuation herausbringen koennen. "
    "Niemandem ist es bisher gelungen, sich mit einem ausgewachsenen Vampir anzulegen "
    "und zu ueberleben. Trotzdem ist das Leben dieser einzigartigen Wesen nicht leicht. "
    "Jederzeit muessen sie sich vor den verschiedensten Dingen in acht nehmen. Am meisten "
    "hassen Vampire jedoch das Tageslicht.";
}

int QueryAllowSelect ()
{
  return 1;
}

int QueryMinSize()
{
  return 137;
}

int QueryMaxSize ()
{
  return 190;
}

int _get_weight (int size)
{
  size=WEIGHT[to_int(size / 2.54)] / 2;
  return size*1000;
}
