/*******************
** Eldarea MUDLib **
********************
**
** std/shells/wood_elf.c - wood elf shell
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** CVS History
**
** $Log: human.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "std/player/base";

#include <properties.h>
#include <player/stat.h>
#include <homes.h>
#include <defines.h>
#include <living/life.h>
#include <health.h>
#include <rmaster.h>

create() 
{
  ::create();

  SetDefaultHome(HUMAN_HOME);
  SetPrayRoom(HUMAN_PRAYROOM);

  SetProp(P_ALCOHOL_DELAY, ALCOHOL_DELAY);
  SetProp(P_FOOD_DELAY, FOOD_DELAY);
  SetProp(P_DRINK_DELAY, DRINK_DELAY);
  SetProp(P_HEAL_DELAY, HEAL_DELAY);
  SetProp(P_POISON_DELAY, POISON_DELAY);

  SetProp(P_MAX_FOOD, MAX_FOOD);
  SetProp(P_MAX_DRINK, MAX_DRINK);
  SetProp(P_MAX_ALCOHOL, MAX_ALCOHOL);
}

string _query_race() 
{
  return WOOD_ELF;
}

string *_query_race_string() 
{
  if(QueryProp(P_GENDER)==FEMALE)
    return ({"Waldelfin","Waldelfin","Waldelfin","Waldelfin"});
  return ({"Waldelf","Waldelfen","Waldelf","Waldelf"});
}

_query_racedescr() 
{
  if (!file_size("/etc/races/wood_elf"))
    return "";
  else
    return read_file("/etc/races/wood_elf");
}

int QueryAllowSelect() 
{
  return 1;
}

int QueryMinSize() 
{
  return 137;
}

int QueryMaxSize() 
{
  return 190;
}

int _get_weight(int size) 
{
  return size*1000;
}
