/*******************
** Eldarea MUDLib **
********************
**
** std/thing.c - standard object
**
** CVS DATA
** $Date: 2000/12/04 11:15:25 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: thing.c,v $
** Revision 1.3  2000/12/04 11:15:25  elatar
** P_MAX_THROW removed
**
** Revision 1.2  1999/11/12 11:38:36  elatar
** lore.c inheritet
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

// A thing. (by Marvin and Deepthought) 
//
// The most general object class. It defines the really basic functions.

#pragma strong_types

inherit "std/thing/properties";
inherit "std/thing/description";
inherit "std/thing/moving";
inherit "std/thing/language";
inherit "std/thing/commands";
inherit "std/thing/restrictions";
inherit "std/thing/material";
inherit "std/thing/lore";
inherit "std/thing/hooks";

#define NEED_PROTOTYPES

#include <thing/properties.h>

#include <properties.h>
#include <language.h>
#include <defines.h>
#include <wizlevels.h>
#include <guilds.h>

void create()
{
  properties::create();
  description::create();
  commands::create();
  restrictions::create();
  material::create();
  lore::create();
  AddId("ding","dinge");
  SetProp(P_GUILD_OBJECT, 0);
}

// Prevents tampering with the master object
int query_prevent_shadow(object dummy) { return 1; }

void init() 
{
  commands::init();
}

void reset() {}
