/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2001/01/31 13:42:20 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: commands.c,v $
** Revision 1.2  2001/01/31 13:42:20  elatar
** process_string() replaced by funcall()
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// Wunderland Mudlib
// basierend auf der MorgenGrauen MUDlib
//
// THING/COMMANDS.C -- thing description
//
/*
 * $Log: commands.c,v $
 * Revision 1.2  2001/01/31 13:42:20  elatar
 * process_string() replaced by funcall()
 *
 * Revision 1.1.1.1  1999/11/05 12:30:47  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:14  en
 * MUDLib CVS Preperation
 *
 * Revision 1.20  1999/04/12 15:27:47  Fiona
 * Zum Regelparsen wird der lower_string genommen, ausser erstes Wort
 *
 * Revision 1.19  1999/02/10 17:05:22  Fiona
 * NetDeadEnvironmentReconnected() zur Kommandoinitialisierung
 *
 * Revision 1.18  1999/02/08 10:25:32  Fiona
 * process_string in AddCmd
 *
 * Revision 1.17  1998/06/26 23:56:04  Gum
 * kleine aenderungen im header
 *
 * Revision 1.16  1998/05/25 17:09:33  Holger
 * Bugfix in AddCmd (fuer Fiona)
 *
 * Revision 1.15  1997/11/26 13:25:15  Fiona
 * Bugfix im 'neuen' AddCmd: errormsg ist weglassbar jetzt (unschoen aber
 * vielleicht moechte man das ja)
 *
 * Revision 1.14  1997/09/30 17:46:12  Arachna
 * Bugfix: 'leerzeichen entfernen' in AddCmd entfernt
 *
 * Revision 1.13  1997/09/08 16:40:29  Fiona
 * AddCmd geht auch, wenn das Obj bereits genommen wurde.
 *
 * Revision 1.12  1997/07/14 11:17:14  Fiona
 * AddCmd(key, fun, 1) geht wieder. Allerdings muss es 1 sein und
 * nicht ein beliebiger intereger !=0 weil das schneller geht.
 *
 * Revision 1.11  1997/06/27 22:48:53  Fiona
 * Fiona schreibt 1000x: erst testen, dann einloggen ;)
 *
 * Revision 1.10  1997/06/27 21:56:37  Fiona
 * Funktionalitaet von AddCmd stark erweitert (Dank Eumel)
 *
 * Revision 1.9  1997/06/22 13:26:15  Fiona
 * riechen und lauschen ausgebaut (-> player/viewcmd)
 *
 * Revision 1.8  1996/12/16 10:33:13  Bongo
 * init() auf P_COMMANDS getestet
 *
 * Revision 1.7  1996/11/08 12:52:56  Mohammed
 * - auf stringp() in mess() getestet, statt nur auf str
 *
 * Revision 1.6  1996/11/01 15:52:35  Mohammed
 * P_SMELL und P_SOUND bei _smell() und _sound()
 * auf ein moegliches Array getestet. Dabei geht [0] an den
 * Spieler und [1] an die Anwesenden
 *
 * Revision 1.5  1996/10/16 12:06:28  Bongo
 * Meldungen in _smell() und _sound berichtigt
 *
 * Revision 1.4  1996/10/15 13:12:10  Mohammed
 * fehlende '\n' eingefuegt und leere log messages entfernt
 *
 * Revision 1.3  1996/10/01 15:33:38  Mohammed
 * BS in _smell() und _sound entfernt und process_string eingebaut
 *
 * Revision 1.2  1996/10/01 12:21:30  Mohammed
 * added _smell() and _sound() for objects
 *
 * Revision 1.1  1994/08/09 13:00:28  mud
 * Initial revision
 *
 */                            

/*
** Neue Datenstruktur von P_COMMANDS:
** ([ Verb: ({ Funktion(en) }); ({ Kriterien }), ... ])
** Dasselbe Verb kann verschiedene Funktionen ausloesen, je nach
** den gesetzten Kriterien.
**
** AddCmd(string|string* cmd, string|closure fun, int|string flag)
** fuegt ein neues Verb oder Verben hinzu. Eine genaue Beschreibung
** ist in der Hilfeseite zu AddCmd.
**
** Das Verfahren des komplexen AddCmd wurde von Eumel@Gueldenland
** entwickelt.
*/

#pragma strong_types

#define NEED_PROTOTYPES

#include <thing/properties.h>
#include <thing/commands.h>
#include <properties.h>

// prototype for local property methods
static mapping _set_commands(mapping commands);

static void _add_commands(string cmd, mixed fun, mixed flag);

void create() {
    Set(P_COMMANDS, ([]));
}

/* Hinzufuegen eines neuen Kommandos zu diesem Objekt. cmd kann ein
** einzelnes Verb, ein Array aus Verben oder ein Regelsatz sein.
** func ist der Name der aufzurufenden Funktion oder eine Closure.
** Wenn flag gesetzt ist, darf das eingegebene Verb laenger sein, als
** das hier verzeichnete. Bitte mit Vorsicht einsetzen (am besten nicht).
** Wenn ein Regelsatz angegeben wurde, koennen in flag die dazugehoerigen
** notify_fail()s stehen. */
varargs void AddCmd(mixed cmd, mixed func, mixed flag) {
  int i, liv;
  mapping cmds;
  
  cmds = Query(P_COMMANDS);
  liv=living(environment());
  if (!pointerp(cmd)) {
    if (intp(flag)&&flag) {
      cmd=({ cmd });
    } else {
      if (sizeof(cmd = explode(cmd, "&"))>1) {
        if (!stringp(flag)) flag = "";
        flag = implode(cmd[1..], "&") + "#" + flag;
        cmd = explode(cmd[0], "|");
      } else cmd = explode(cmd[0], "|");
    }
  }
  for (i=sizeof(cmd); i--;) {
    if (!member(cmds, cmd[i])) {
      if (liv) _add_commands(cmd[i], ({ func }), ({ flag}) ); // Cmd 'nachtragen'
      cmds += ([ cmd[i]: ({ func }); ({ flag }) ]);
    } else {
      cmds[cmd[i], 0] += ({ func });
      cmds[cmd[i], 1] += ({ flag });
    }
  }
  Set(P_COMMANDS, cmds);
}

// Hiermit entfernt man einzelne Kommandos wieder. Es werden immer alle
// zu einem Kommando gehoerigen Funktionen entfernt.
varargs void RemoveCmd(mixed cmd) {
  int i;
  mapping cmds;

  cmds = Query(P_COMMANDS);
  if (!cmd) Set(P_COMMANDS, ([]));
  else {
    if(stringp(cmd)) cmd = ([cmd]); 
    else if(!mappingp(cmd) && pointerp(cmd)) cmd = mkmapping(cmd);
    else return;
    Set(P_COMMANDS, Query(P_COMMANDS) - cmd);
  }
}

// Hier landet jedes Kommando und wird entsprechen ausgewertet
int _cl(string str) {
  string verb, *rule, *errmsg, *words, *synon, *groups, *keys;
  int i, j, k, l, match, missing, ret;
  mixed cmd;
  mapping cmds;

  cmds=Query(P_COMMANDS);
  verb=query_verb();
  cmd=cmds[verb,0];
  for (k=sizeof(cmd); k--;) { // Alle Funktionen durchgehen
    if (stringp(cmds[verb,1][k])) {
      rule = efun::explode(cmds[verb,1][k], "#");
      if (!str) {
        if (strlen(rule[1]))
          notify_fail(efun::explode(rule[1],"|")[0]+"\n");
        continue; // Naechste Funktion zu diesem Verb pruefen
      }
      words = efun::explode(lower_case(str), " ");
      groups = efun::explode(rule[0], "&");
      missing=-1; // Nummer der nichterfuellten Regel
      l=sizeof(groups);
      for (i=0; i<l; i++) { // Alle Regeln durchgehen
        synon = efun::explode(groups[i], "|");
        match = 0;
        for (j=sizeof(synon); j--;) { // Alle Synonyme probieren
          if (member_array(synon[j], words)!=-1) {
            match=1;
            break;
          }
        }
        if (!match) {
          missing=i;
          break;
        }
      }
      if (missing>=0) { // Schluesselwort fehlt
        if (strlen(rule[1]) && sizeof(errmsg=efun::explode(
          rule[1], "|"))>missing)
            notify_fail(funcall(errmsg[missing])+"\n");
        continue; // Naechste Funktion zu diesem Verb pruefen
      }
    }
    if (closurep(cmd[k])) ret=funcall(cmd[k], str);
    else ret=call_other(this_object(), cmd[k], str);
    if (ret) return ret;
  }
  // Verkuerztes Kommando? (flag==1) (nur wenn nur eine Fun fuer diese Verb)
  if (cmd) return 0;
  keys=m_indices(cmds);
  for (i=sizeof(keys); i--;) {
    cmd=cmds[keys[i], 1][0];
    if (!intp(cmd) || !cmd) continue; // Flag nicht gesetzt?
    if (keys[i]!=verb[0..strlen(keys[i])-1]) continue; // keine Uebereinst.?
    if (closurep(cmds[keys[i]][0])) return funcall(cmds[keys[i]][0], str);
    else return call_other(this_object(), cmds[keys[i]][0], str);
  }
  return 0;
}

// Die Kommandos werden this_player() zugewiesen
static void _add_commands(string cmd, mixed fun, mixed flag) {
  add_action("_cl", cmd, (member_array(1, flag)!=-1 ? 1 : 0 ));
}

// init() wird aufgerufen, wenn ein Lebewesen in unsere Naehe kommt.
// Dieses erhaelt sofort unsere Kommandos.
void init() {
  mapping cmds;
  cmds = QueryProp(P_COMMANDS);
  if (mappingp(cmds)) walk_mapping(cmds, #'_add_commands);
}

void NetDeadEnvironmentReconnected() {
  mapping cmds;
  cmds = QueryProp(P_COMMANDS);
  if (mappingp(cmds)) walk_mapping(cmds, #'_add_commands);
}

// **** local property methods
static mapping _set_commands(mapping commands) {
  if (mappingp(commands)) return Set(P_COMMANDS, commands);
}
