/*******************
** Eldarea MUDLib **
********************
**
** std/thing/description - object descriptions
**
** CVS DATA
** $Date: 2001/01/31 13:42:20 $
** $Revision: 1.6 $
**
** CVS History
**
** $Log: description.c,v $
** Revision 1.6  2001/01/31 13:42:20  elatar
** process_string() replaced by funcall()
**
** Revision 1.5  2001/01/31 13:12:05  elatar
** clock include changed
**
** Revision 1.4  2001/01/05 23:48:56  elatar
** fixed bugs in light calculation
**
** Revision 1.3  2000/12/12 11:33:18  elatar
** id() returns true for unique_id(file_name())
**
** Revision 1.2  2000/12/04 11:27:33  elatar
** completely new light handling implemented
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

#define NEED_PROTOTYPES 1

inherit "/std/thing/details";

#include <thing/properties.h>
#include <properties.h>
#include <language.h>
#include <defines.h>
#include <clock.h>
#include "/std/sys_debug.h"

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

// prototypes for local properties methods
static mixed _set_adjectives(mixed adjective);
static mixed _set_ids(mixed ids);

void create()
{ 
  string poid, tpid;
  object po, tp;

  ::create();
  SetProp(P_LONG,0);

  SetProp(P_SMELL,0);           // nothing to smell by default
  SetProp(P_SOUND,0);           // nothing to hear by default

  Set(P_ADJECTIVES,({}));
  Set(P_NAME_ADJ,({}));
  Set(P_IDS, ({}));
  Set(P_TRANSLUCENT,1);
  Set(P_LIGHT, 0);
  
  po=previous_object();
  if (po && !(poid=geteuid(po))) poid=getuid(po);
  if (!(tp=this_interactive())) tp=this_player();
  if (tp && !(tpid=geteuid(tp))) tpid=getuid(tp);
  if (!tpid) tpid="UNKNOWN";
  if (!poid) poid="UNKNOWN";
  Set(P_CLONER,(poid!=tpid ? poid+":"+tpid : tpid));
  Set(P_CLONER,-1,F_SET_METHOD);
  Set(P_CLONER,SECURED,F_MODE);
}

/*
 * id management 
 */

int match_item(string str, string *ids);
public int my_inv_nr();

varargs int id(string str, int lvl) { 
  string str2, tmp;
  int count;	
  mixed ids;

  if (str==unique_id(file_name()))
    return 1;
  if (!stringp(str)) return 0;
  if (ME->QueryProp(P_INVIS)) return 0;

  ids = QueryProp(P_IDS);
  if (!pointerp(ids) || !sizeof(ids))
    return 0;
  if (match_item(str,ids)) return 1;

  // Fuer "i15" Notation
  if (this_player()==environment() &&
      sscanf(str,"i%d%s", count, str2)==2 && str2=="") {
    if (count<1) return 0;
    if (count==environment()->my_inv_nr(ME)) return 1;
    return 0;
  }

  // Fuer "ding 31" Notation
  if (sscanf(str,"%s %d%s",str2,count,tmp)>=2 &&(!tmp||tmp=="") && count>0) {
    if (match_item(str2,ids) && environment())
      return present(sprintf("%s %d",str2,count), environment())==this_object();
  }
  return ::id(); 
}

varargs void AddId(mixed sing, mixed plur)
{
  if(stringp(sing)) sing = ({ sing });
  if(pointerp(sing)) return Set(P_IDS, Query(P_IDS)+sing);
}

void AddAdjective(mixed str)
{
  if(stringp(str)) str = ({ str });
  if(pointerp(str)) return Set(P_ADJECTIVES, Query(P_ADJECTIVES)+str);
}

/* Ids muessen uebergeben werden, da unit machmal mit plural-Ids, */
/* also anderen als den normalen arbeiten muss. */
int match_item(string str, string *ids)
{
  mixed ads;

  if (!str) return 0;
  if (!pointerp(ids) || !sizeof(ids)) return 0;
  if (member_array(str,ids)>=0)
    return 1;
  if (member_array(lower_case(str),ids)>=0)
    return 1;
  if (ads = QueryProp(P_ADJECTIVES)) {
    string *obj;
    int len;
    int i;
    
    obj = explode(str," ");
    len = sizeof(obj);
    /* find as many adjectives as possible */
    for (i = 0; i < len-1; i++) {
      if (member_array(obj[i],ads) < 0) break;
    }
    /* The rest must be in the id list */
    str = implode(obj[i..len-1]," ");
  }
  if (member_array(str,ids)>=0)
    return 1;
  return (member_array(lower_case(str),ids)>=0);
}

varargs string name(int casus, int demon)
{
  string adj;
  mixed sh;
  int art, flag;
  mixed last;
  
  flag=demon;
  demon&=NAME_AUTO|NAME_DEF|NAME_INDEF;

  if (flag & NAME_PLURAL) {
    sh=QueryProp(P_PLURAL);
    if (stringp(sh) && (string)sh=="") sh=0;
  }
  else sh = QueryProp(P_NAME);
  if (!sh) return 0;

  if (QueryProp(P_INVIS)) {
    if (casus==RAW) return "etwas";
    return ({ "etwas", "von etwas", "etwas", "etwas" })[casus];
  }

  if (casus==RAW) {
    if (pointerp(sh)) return sh[WER];
    return (string)sh;
  }
  if (demon==NAME_AUTO)
    demon = SuggestArticle(sh);
  if (pointerp(sh)) {
    if (intp(sh[1])) // Alle Ints, egal was ;o) ist Adjektiv
      sh = DeclAdj(sh[0], casus, demon)[0..<2];
    else sh = sh[casus];
  }
  else if ((!(flag&NAME_PLURAL)) && stringp(sh)) {
    last = sh[<1]|32; // Kleinschreib-Bit setzen
    switch (casus) {
      case WEM:
      case WEN:
        if (Query(P_ARTICLE)!=1 && QueryProp(P_GENDER)==MALE && last=='e')
          sh = (string)sh + "n";
        break;
      case WESSEN:
        if (Query(P_ARTICLE)==1) {
          switch( last ) {
            case 'x': case 's': case 'z':
              sh=(string)sh + "'";
              break;
            default:
              sh=(string)sh + "s";
          }
        } else {
          switch (QueryProp(P_GENDER)) {
            case MALE:
              switch (last) {
                case 'x': case 's': case 'z':
                  break;
                case 'e':
                  sh = (string)sh + "n";
                  break;
                default:
                  sh = (string)sh + "s";
              }
              break;
            case NEUTER:
              switch (last) {
                case 'x': case 's': case 'z':
                  break;
                default:
                  sh = (string)sh + "s";
              }
              break;
            case FEMALE:
              break;
          } /* switch( QueryProp(P_GENDER) ) */
        } /* if (Query(P_ARTICLE)==1) else */
    } /* switch (casus) */
  } /* pointerp(sh) */
  
  if (flag&NAME_DESCR) {
    adj=QueryProp(P_DESCR);
    adj=funcall(adj);
    if (adj) sh+=(adj[0]==',' ? "" : " ")+adj;
  }

  last=QueryProp(P_NAME_ADJ)||({});
  if (flag&NAME_PLURAL) {
    if (casus!=WER && casus!=WEN) return 0;
    // Beugen der Adjektive immer einfach 'e' anhaengen
    adj=implode(map_array(last, lambda( ({ 'x }), ({ #'+, 'x, "e " }) )), "");
  } else {
    adj=(Query(P_ARTICLE)!=1 ? QueryArticle(casus,demon) : "")+
      implode(map_array(last, #'DeclAdj, casus, demon), "");
  }
  return adj+sh;
}

varargs string Name(int casus, int demon)
{
  return capitalize(name(casus,demon));
}

//  **** local property methods
static mixed _set_name_adj(mixed adjectives)
{
  if (!adjectives) return Set(P_NAME_ADJ, 0);
  if(!pointerp(adjectives)) adjectives = ({ adjectives });
  return Set(P_NAME_ADJ, adjectives);
}

static mixed _set_adjectives(mixed adjectives)
{
  Set(P_ADJECTIVES, ({}));
  return AddAdjective(adjectives);
}

static mixed _set_ids(mixed ids)
{
  Set(P_IDS, ({}));
  return AddId(ids);
}

// *****
string long()
{
  mixed long;
  
  return funcall(QueryProp(P_LONG));
}

mixed QueryName() {
  return QueryProp( P_NAME );
}

varargs int QueryExternalLight()
{
  int i, light, * lightlevels;
  object * inv;
  
  
  if (!QueryProp(P_TRANSLUCENT))
    return QueryProp(P_LIGHT);
  else
  {
    lightlevels = allocate(10);
    lightlevels[QueryProp(P_LIGHT)+2]++;
  }
  
  inv = all_inventory();  
  for (i=sizeof(inv);i-->0;)
  {
    lightlevels[inv[i]->QueryExternalLight()+2]++;
  }
  
  if (0 < light = lightlevels[9] - lightlevels[0])
  {
    light = 7;
  }
  else if (0 > light)
  {
    light = -2;  
  }
  else if (0 < light = lightlevels[8] - lightlevels[1])
  {
    light = 6;
  }
  else if (0 > light)
  {
    light = -1;
  }
  else if (lightlevels[7])
  {
    light = 5;  
  }
  else if (lightlevels[6])
  {
    light = 4;
  }
  else if ( 3 < light = lightlevels[3] + lightlevels[4]*2 + lightlevels[5]*3)
  {
    light = 4;
  }

  return light;
}

varargs int QueryInternalLight(object exclude)
{
  int i, light, * lightlevels;
  object * inv;
  
  lightlevels = allocate(10);
  
  lightlevels[QueryProp(P_LIGHT)+2]++;
  
  if (QueryProp(P_TRANSLUCENT) && environment())
  {
    lightlevels[environment()->QueryInternalLight(this_object())+2]++;
  }
  
  inv = all_inventory()-({exclude});  
  for (i=sizeof(inv);i-->0;)
  {
    lightlevels[inv[i]->QueryExternalLight()+2]++;
  }
  if (0 < light = lightlevels[9] - lightlevels[0])
  {
    light = 7;
  }
  else if (0 > light)
  {
    light = -2;  
  }
  else if (0 < light = lightlevels[8] - lightlevels[1])
  {
    light = 6;
  }
  else if (0 > light)
  {
    light = -1;
  }
  else if (lightlevels[7])
  {
    light = 5;  
  }
  else if (lightlevels[6])
  {
    light = 4;
  }
  else if (3 < light = lightlevels[3] + lightlevels[4]*2 + lightlevels[5]*3)
  {
    light = 4;
  }

  return light;
}

int _query_light()
{
  int dlights;
  
  if (pointerp(dlights=QueryProp(P_DAYTIME_LIGHTS)))
    return QueryProp(P_DAYTIME_LIGHTS)[UHR->QueryState()];
  return Query(P_LIGHT);
}