/*******************
** Eldarea MUDLib **
********************
**
** std/thing/details.c - details for objects
**
** CVS DATA
** $Date: 2001/02/22 13:28:24 $
** $Revision: 1.5 $
**
** CVS History
**
** $Log: details.c,v $
** Revision 1.5  2001/02/22 13:28:24  elatar
** details querying (GetDetail()) hopefully fixed
**
** Revision 1.4  2001/01/31 13:42:20  elatar
** process_string() replaced by funcall()
**
** Revision 1.3  2001/01/31 13:12:18  elatar
** clock include changed
**
** Revision 1.2  2000/05/11 07:29:05  elatar
** Detail handling expanded (ilum added)
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types
#define NEED_PROTOTYPES

#include <thing/details.h>
#include <properties.h>
#include <thing/properties.h>
#include <clock.h>

private static mapping details;
private static mapping smell_details;
private static mapping sound_details;
private static mapping read_details;

private mixed _get_readmsg();

void create() {
  details = ([ ]);
  smell_details = ([ ]);
  sound_details = ([ ]);
  read_details = ([ ]);
  AddReadDetail(({"text","schrift"}), #'_get_readmsg);
}

private mixed _get_readmsg() {
  mixed x;
  x=QueryProp(P_READ_MSG);
  if (pointerp(x)) return x[0];
  else return x;
}

// Hinzufuegen und Loeschen von Details

varargs void AddDetail(mixed *keys, mixed descr, mixed idescr, mixed ndescr) 
{
  int i;
 
  if (ndescr || idescr) 
    descr = ({ descr, idescr, ndescr });

  if (!pointerp(keys)) 
    details += ([ keys : descr ]);
  else 
  {
    if (stringp(descr)) 
      descr=make_shared_string((string)descr);
    for (i = sizeof(keys); i-- > 0; )
      details += ([ keys[i] : descr ]);
  }
}

void RemoveDetail(mixed *keys) {
  int i;

  if (!keys)
    details = ([ ]);
  else if (stringp(keys))
    efun::m_delete(details, keys);
  else
    for (i = sizeof(keys) - 1; i >= 0; i--)
      efun::m_delete(details, keys[i]);
}

void AddSmellDetail(mixed keys, string descr) {
  int i;

  if (stringp(keys))
    smell_details += ([ keys : descr ]);
  else {
    if (stringp(descr)) descr=make_shared_string(descr);
    for (i = sizeof(keys) - 1; i >= 0; i--)
      smell_details += ([ keys[i] : descr ]);
  }
}

void RemoveSmellDetail(mixed keys) {
  int i;

  if (!keys)
    smell_details = ([ ]);
  else if (stringp(keys))
    efun::m_delete(smell_details, keys);
  else
    for (i = sizeof(keys) - 1; i >= 0; i--)
      efun::m_delete(smell_details, keys[i]);
}

void AddSoundDetail(mixed keys, string descr) {
  int i;

  if (stringp(keys))
    sound_details += ([ keys : descr ]);
  else {
    if (stringp(descr)) descr=make_shared_string(descr);
    for (i = sizeof(keys) - 1; i >= 0; i--)
      sound_details += ([ keys[i] : descr ]);
  }
}

void RemoveSoundDetail(mixed keys) {
  int i;

  if (!keys)
    sound_details = ([ ]);
  else if (stringp(keys))
    efun::m_delete(sound_details, keys);
  else
    for (i = sizeof(keys) - 1; i >= 0; i--)
      efun::m_delete(sound_details, keys[i]);
}

void AddReadDetail(mixed keys, mixed descr) {
  int i;

  if (stringp(keys))
    read_details += ([ keys : descr ]);
  else {
    if (stringp(descr)) descr=make_shared_string(descr);
    for (i = sizeof(keys) - 1; i >= 0; i--)
      read_details += ([ keys[i] : descr ]);
  }
}

void RemoveReadDetail(mixed keys) {
  int i;

  if (!keys)
    read_details = ([ ]);
  else if (stringp(keys))
    efun::m_delete(read_details, keys);
  else
    for (i = sizeof(keys) - 1; i >= 0; i--)
      efun::m_delete(read_details, keys[i]);
}

// Abfrage von Details

// es wird in den Faellen auch an GetSoundDetail, GetSmellDetail und
// GetReadDetail uebergeben, jedoch nicht weiter beachtet.

varargs string GetDetail(mixed key)
{
  int l;
  mixed detail;
  string desc;
  
  detail = details[key];
  if (closurep(detail)) 
    detail=funcall(detail, key);

  if (pointerp(detail))
  {
    switch(sizeof(detail)) 
    {
      case 0: 
        return 0;
      case 1: 
        detail = detail[0]; 
        break;
      default: 
        if (UHR->IsNight())
        {
          if ( l = this_object()->QueryInternalLight() 
            && QueryProp(P_LIGHT) < l)
            desc = detail[1];
          if(!desc)
            desc = detail[2];          
        }
        if (!desc)
          desc = detail[0];
        break;
    }
    detail = desc;
  }
  
  return funcall(detail);
}

varargs string GetSoundDetail(string key, string hauptid) {
  mixed det;
  det=sound_details[key];
  if (stringp(det) || closurep(det)) return funcall(det);
  return 0;
}

varargs string GetSmellDetail(string key, string hauptid) {
  mixed det;
  det=smell_details[key];
  if (stringp(det) || closurep(det)) return funcall(det);
  return 0;
}

varargs string GetReadDetail(string key, string hauptid) {
  mixed det;
  det=read_details[key];
  if (stringp(det) || closurep(det)) return funcall(det);
  return 0;
}

varargs int id(string str, int lvl) {
  if (details[str]) return 1;
  if (sound_details[str]) return 1;
  if (smell_details[str]) return 1;
  if (read_details[str]) return 1;
  return 0;
}

// ***** Property-Methoden

static mapping _set_details(mapping arg) {
  if (mappingp(arg))
    return details = arg;
  else return 0;
}

static mapping _query_details() {
  return details;
}

static mapping _set_smell_details(mapping arg) {
  if (mappingp(arg))
    return smell_details = arg;
}

static mapping _query_smell_details() {
  return smell_details;
}

static mapping _set_sound_details(mapping arg) {
  if (mappingp(arg))
    return sound_details = arg;
}

static mapping _query_sound_details() {
  return sound_details;
}

static mapping _set_read_details(mapping arg) {
  if (mappingp(arg))
    return read_details = arg;
}

static mapping _query_read_details() {
  return read_details;
}

static string _query_read_msg() {
  return funcall(Query(P_READ_MSG));
}
