/*******************
** Eldarea MUDLib **
********************
**
** std/thing/hooks.c - hook handling
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** All Hooks are handled here
**
** CVS History
**
** $Log: properties.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#include <thing/hooks.h>
#include <properties.h>

#pragma strong_types

varargs void AddHook(string hook ,object ob, string fun, int expire, mixed extra)
{
  mapping hooks;
  
  if (!objectp(ob) || !stringp(fun) || !stringp(hook))
    return;
  if (!intp(expire))
    expire=0;
      
  if ( !mappingp(hooks=this_object()->QueryProp(hook)) )
    hooks=([]);
  
  this_object()->Set(hook,hooks+([ob:fun;expire;extra]));
}

void DelHook(string hook, object ob)
{
  if (!stringp(hook) || !objectp(ob))
    return;
    
  this_object()->Set(hook,m_delete(this_object()->QueryProp(hook),ob));
}

static void UseHook(string hook, object ob)
{
  mapping hooks;
  
  hooks=this_object()->QueryProp(hook);
  
  if (++hooks[ob,HOOK_EXPIRE]==0)
    hooks=m_delete(hooks,ob);
  
  this_object()->Set(hook,hooks);
}

int EvalHook(string hook, mixed args)
{
  mapping hooks;
  object * ind;
  int i;
  mixed ret;
  
  if (!stringp(hook))
    return 1;
    
  if (!mappingp(hooks=this_object()->QueryProp(hook))) 
    hooks=([]);
 
  for (i=sizeof(ind=m_indices(hooks));i-->0;)
  {
    if ( !objectp(ind[i]) 
      || !stringp(hooks[ind[i],HOOK_FUN]) 
      || (hooks[ind[i],HOOK_EXPIRE]>0 && hooks[ind[i],HOOK_EXPIRE]<time()) )
    {
      DelHook(hook,ind[i]);
    }
    else if (hooks[ind[i],HOOK_EXPIRE]<0)
    {
      if (!ret=call_other(ind[i],hooks[ind[i],HOOK_FUN],args,hooks[ind[i],HOOK_EXTRA]))
      {
        UseHook(hook,ind[i]);
        return 0;
      }
      UseHook(hook,ind[i]);            
    }
    else
      if (!ret=call_other(ind[i],hooks[ind[i],HOOK_FUN],args,hooks[ind[i],HOOK_EXTRA]))
        return 0;
  }
  return ret;
}