/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: language.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// Wunderland Mudlib
// basierend auf der MorgenGrauen MUDlib
//
// THING/LANGUAGE.C -- language handling object
//
/*
 * $Date: 1999/11/05 12:30:47 $                      
 * $Revision: 1.1.1.1 $       
 * $Log: language.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:47  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:14  en
 * MUDLib CVS Preperation
 *
 * Revision 1.8  1999/01/16 17:40:02  Fiona
 * Beugen der Adjective nimmt nun Ruecksicht auf P_ARTICLE
 *
 * Revision 1.7  1999/01/13 19:40:46  Fiona
 * Ausbau QueryAFlag(), Einbau von ART_DEF und ART_INDEF in QueryArticle()
 *
 * Revision 1.6  1998/08/23 14:12:46  Gum
 * #include <std_headers.h> entfernt (headerfile geloescht)
 *
 * Revision 1.5  1998/08/22 22:33:10  Gum
 * parameter von SuggestArticle ist jetzt mixed
 *
 * Revision 1.4  1998/06/26 23:56:04  Gum
 * kleine aenderungen im header
 *
 * Revision 1.3  1997/04/14 11:32:53  Arachna
 * QueryPronoun unterstuetzt jetzt Shadows
 *
 * Revision 1.2  1994/10/26 18:41:26  Arachna
 * Neue MG-Release
 *
 */                            

#pragma strong_types

#define NEED_PROTOTYPES

#include <language.h>
#include "/sys/thing/properties.h"
#include <properties.h>
#include <defines.h>

static int _set_article(int fl) {
  fl=Set(P_ARTICLE, PROP2ART(fl));
  return PROP2ART(fl);
}

static int _query_article() {
  int i;
  i=Query(P_ARTICLE);
  return PROP2ART(i);
}

private string query_c_article(int casus)
{
  return ({ ({ "das ", "des ", "dem ", "das " }),
            ({ "der ", "des ", "dem ", "den " }),
            ({ "die ", "der ", "der ", "die " }) })
         [(int)QueryProp( P_GENDER ) % 3][casus];
}

private varargs string query_g_suffix(int gen, int casus, int anzahl)
{
  return ({ ({ ({"","e"}), ({"es","er"}), ({"em","en"}), ({"","e"}) }),
	    ({ ({"","e"}), ({"es","er"}), ({"em","en"}), ({"en","e"}) }),
	    ({ ({"e","e"}), ({"er","er"}), ({"er","en"}), ({"e","e"}) }) })
    [gen][casus][anzahl];
}

private string query_ic_article(int casus)
{
  return "ein"+query_g_suffix( (int)QueryProp( P_GENDER ) % 3, casus )+" ";
}

varargs string QueryArticle(int casus, int dem, int force)
{
  int i;
  if (force) i=force;
  else {
    i=Query(P_ARTICLE);
    i=PROP2ART(i);
  }
  switch (i) {
    case ART_NONE : return "";
    case ART_AUTO : if (dem==2) dem = SuggestArticle(QueryProp(P_NAME));
               if (dem) return query_c_article(casus);
               return query_ic_article(casus);
    case ART_DEF  : return query_c_article(casus);
    case ART_INDEF: return query_ic_article(casus);
  }
  return "???";
}

varargs int SuggestArticle(mixed id)
{
  object ob;
  if(!environment()) return 1;
  for(ob = first_inventory(environment()); ob; ob = next_inventory(ob))
    if(ob != this_object() && id == ob->QueryProp(P_NAME)) return 0;
  return 1;
}

varargs string QueryPossPronoun(mixed what, int casus, int number)
{
  int gen2;
  gen2 = intp(what) ? what : (int)what->QueryProp(P_GENDER);
  return ((((int)QueryProp( P_GENDER ) % 3) < FEMALE ) ? "sein" : "ihr")
    + query_g_suffix(gen2, casus, number);
}

string QueryPronoun(int casus)
{
  int gender;
  gender = ME->QueryProp(P_GENDER);
  switch(casus)
  {
    case WER:
    switch(gender)
    {
      case MALE  : return "er";
      case FEMALE: return "sie";
      case NEUTER: return "es";
    }
    break;
    case WEM: if(gender == FEMALE) return "ihr"; else return "ihm";
  }
  switch(gender)
  {
    case MALE: return "ihn";
    case FEMALE: return "sie";
  }
  return "es";
}

varargs string QueryDu(int casus,int gender,int zahl)
{
  return
    ({ ({ ({ "du", "ihr"}), ({ "du", "ihr"}), ({ "du", "ihr"}) }),
       ({({"deines","deiner"}),({"deines","deiner"}),({"deiner","deiner"})}),
       ({({"dir","euch"}),({"dir","euch"}),({"dir","euch"})}),
       ({({"dich","euch"}),({"dich","euch"}),({"dich","euch"})})
       })[casus][gender][zahl];
}

string QueryGenderString()
{
  switch( (int)ME->QueryProp( P_GENDER ) % 3 )
  {
    case MALE  : return "maennlich";
    case FEMALE: return "weiblich";
    case NEUTER: return "saechlich";
  }
}

varargs string DeclAdj(string adj, int casus, int demon)
{
  int i;
  if (!adj) return "";
  i=Query(P_ARTICLE);
  i=PROP2ART(i);
  switch (i) {
    case ART_NONE : /* wie INDEF */
    case ART_INDEF: demon=0; break;
    case ART_DEF  : demon=1; break;
    case ART_AUTO : if (demon==2) demon = SuggestArticle(QueryProp(P_NAME));
  }
  
  if(demon)
    return adj + ({ ({ "e" , "en", "en", "e"  }),
		    ({ "e" , "en", "en", "en" }),
		    ({ "e" , "en", "en", "e"  }) })
      [(int)ME->QueryProp( P_GENDER ) % 3][casus] + " ";
  else
    return adj + ({ ({ "es", "en", "en", "es" }),
		    ({ "er", "en", "en", "en" }),
		    ({ "e" , "en", "en", "e"  }) })
      [(int)ME->QueryProp( P_GENDER ) % 3][casus] + " ";
}

static int _set_gender(int i)
{
  if(i==MALE || i==FEMALE || i==NEUTER) return Set(P_GENDER, i);
}
