/*******************
** Eldarea MUDLib **
********************
**
** std/thing/lore.c - lore data handling
**
** CVS DATA
** $Date: 2000/12/04 11:28:03 $
** $Revision: 1.3 $
**
** this file manages the lore data used by the living lore skills
**
** CVS History
**
** $Log: lore.c,v $
** Revision 1.3  2000/12/04 11:28:03  elatar
** lore handling changed
**
** Revision 1.2  2000/01/14 15:18:28  elatar
** small bugfix
**
** Revision 1.1  1999/11/12 11:36:53  elatar
** Initial revision
**
**
*/

#pragma strong_types

#define NEED_PROTOTYPES 1

#include <thing/properties.h>
#include <thing/language.h>
#include <thing/lore.h>
#include <defines.h>
#include <living/skills.h>

void create()
{
  RemoveDetailLore(0);
}

void AddDetailLore(string detail, string lore, mapping newlore)
{
  Set(P_DETAIL_LORE,Query(P_DETAIL_LORE)+([detail:([lore:newlore])]));
}

#define AddLore(a,b) AddDetailLore(0,a,b)

void RemoveDetailLore(string detail, string lore)
{
  if (!detail)
    Set(P_DETAIL_LORE,([1:ZERO_LORES]));
  else if (!lore)
    Set(P_DETAIL_LORE,m_delete(Query(P_DETAIL_LORE),detail)); 
  else
  {
    mapping tmp;

    tmp=Query(P_DETAIL_LORE);
    tmp[detail]=m_delete(tmp[detail],lore);
    Set(P_DETAIL_LORE,tmp);
  }
}

varargs mapping QueryLore(string detail,string lore)
{
  if (lore)
    return copy_mapping(QueryProp(P_DETAIL_LORE)[detail][lore]);
  else
    return copy_mapping(QueryProp(P_DETAIL_LORE)[detail]);
} 
