/*******************
** Eldarea MUDLib **
********************
**
** std/thing/material.c - material handling
**
** CVS DATA
** $Date: 2000/08/15 08:28:55 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: material.c,v $
** Revision 1.2  2000/08/15 08:28:55  eldarea
** material handling reimplemented
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

#define NEED_PROTOTYPES 1

#include <thing/properties.h>
#include <thing/language.h>
#include <thing/material.h>
#include <thing/restrictions.h>
#include <defines.h>
#include <material.h>

#define Mconvert ([MAT_WOOD:({"Holz", "Holzes", "Holz", "Holz"}), \
               MAT_HORN:({"Horn", "Horns", "Horn", "Horn"}), \
               MAT_LEATHER:({"Leder", "Leders", "Leder", "Leder"}), \
               MAT_CLOTH:({"Stoff", "Stoffes", "Stoff", "Stoff"}), \
               MAT_FUR:({"Fell", "Fells", "Fell", "Fell"}), \
               MAT_PAPER:({"Papier", "Papiers", "Papier", "Papier"}), \
               MAT_STONE:({"Stein", "Steines", "Stein", "Stein"}),\
               MAT_GLASS:({"Glas", "Glasses", "Glas", "Glas"}),\
               MAT_CERAMIC:({"Keramik", "Keramik", "Keramik", "Keramik"}),\
               MAT_METAL:({"Metall", "Metalls", "Metall", "Metall"}),\
               MAT_ICE:({"Eis", "Eises", "Eis", "Eis"}),\
               MAT_FIRE:({"Feuer", "Feuers", "Feuer", "Feuer"}),\
               MAT_WATER:({"Wasser", "Wassers", "Wasser", "Wasser"}),\
               MAT_BRONZE:({"Bronze", "Bronzenes", "Bronzenem", "Bronze"}),\
               MAT_COPPER:({"Kupfer", "Kupfernes", "Kupfernem", "Kupfer"}),\
               MAT_MAGIC:({"magisches Material", "magischen Materials",\
                           "magischem Material", "magische Material"}),\
               MAT_IRON:({"Eisen", "Eisens", "Eisen", "Eisen"}),\
               MAT_SILVER:({"Silber", "Silbers", "Silber", "Silber"}),\
               MAT_GOLD:({"Gold", "Goldes", "Gold", "Gold"}),\
               MAT_MITHRIL:({"Mithril", "Mithrils", "Mithril", "Mithril"}),\
               MAT_ADAMANTITE:({ "Adamantit","Adamantits","Adamantit","Adamantit" }),\
               MAT_ORGANIC:({"organisches Material","organischen Materials",\
                             "organischem Material","organischen Material" }),\
               MAT_LIVING:({"lebende Materie", "lebenden Materie",\
                            "lebender Materie", "lebende Materie"}),\
               MAT_CORPSE:({"verwesendes Fleisch", "verwesenden Fleisches",\
                            "verwesendem Fleisch", "verwesende Fleisch"})])
void create()
{ 
  Set(P_MATERIAL, ([MAT_MISC:100]));
}

int QueryShare(string mat) {
  if(!stringp(mat)) return 0;
  return Query(P_MATERIAL)[mat];
}

varargs string mat2string(string mat, int casus)
{
  mixed Mindices;

  Mindices=m_indices(Mconvert);
  if (member(({WER, WESSEN, WEM, WEN}), casus)==-1)
    casus = WER;
  if (member(Mindices, mat)!=-1)
    return Mconvert[mat][casus];
  else
    return ({"unbekanntes Material", "unbekannten Materiales",
             "unbekanntem Material", "unbekanntes Material"})[casus];   
}

void matmap(string key, int val, int casus, string str) {
  str+=sprintf("%-20s : %d%%\n",mat2string(key,casus),val);
}

string MatList(int casus)
{
  mapping mat;
  string str;
  
  mat = QueryProp(P_MATERIAL);
  str="";
  walk_mapping(mat, "matmap", this_object(), casus, &str);
  return str;
}

// property methods

mapping _set_material(mapping mat) 
{
  int hardness, wearout, transcendence, perc, i;
  float spec_weight;
  string * ind;
  mapping cpy;

  if(!mappingp(mat))
    mat=([mat:100]);

  cpy=copy_mapping(mat);
  //all material info is written to cpy
  walk_mapping(cpy,lambda(
    ({'ind,'val}),
      ({#'=,
        'val,
        ({#'call_other,
          MATERIALDB,
          "QueryMaterialInfo",
          'ind,
          quote(({MATI_WEIGHT,
                  MATI_HARDNESS,
                  MATI_WEAROUT,
                  MATI_TRANSCENDENCE}))})})));
  
  for (i=sizeof(ind=m_indices(mat));i-->0;)
  {
    perc+=mat[ind[i]];
    spec_weight=spec_weight+cpy[ind[i]][MATI_WEIGHT]*(mat[ind[i]]/100.0);
    hardness+=to_int(cpy[ind[i]][MATI_HARDNESS]*(mat[ind[i]]/100.0));
    wearout+=to_int(cpy[ind[i]][MATI_WEAROUT]*(mat[ind[i]]/100.0));
    transcendence+=to_int(cpy[ind[i]][MATI_TRANSCENDENCE]*(mat[ind[i]]/100.0));
  }
  if (perc!=100)
  { // percentage does not add to 100 :)
    // we can correct this right now (but it may happen to get 99 or 101 %)
    spec_weight=spec_weight*100.0/perc;
    hardness=to_int(hardness*100.0/perc);
    wearout=to_int(wearout*100.0/perc);
    transcendence=to_int(transcendence*100.0/perc);
    walk_mapping(mat,lambda(
      ({'ind,'val}),
        ({#'=,'val,({#'to_int,({#'*,'val,100.0/perc})})})));
  }  
  SetProp(P_SPECIFIC_WEIGHT,spec_weight);
  SetProp(P_HARDNESS,hardness);
  SetProp(P_WEAROUT,wearout);
  SetProp(P_TRANSCENDENCE,transcendence);
  
  return Set(P_MATERIAL,mat);
}
