/*******************
** Eldarea MUDLib **
********************
**
** std/thing/moving.c - moving objects
**
** CVS DATA
** $Date: 2000/12/19 18:00:29 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: moving.c,v $
** Revision 1.3  2000/12/19 18:00:29  elatar
** implemented deep_remove()
**
** Revision 1.2  2000/12/04 11:28:30  elatar
** header changed
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

#define NEED_PROTOTYPES 1
#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

#include <thing/properties.h>
#include <properties.h>
#include <moving.h>

// move()
//
// This is called every time someone wants to move us. No message is
// given currently (this behaviour can be changed in livng objects
// that want to be noisy when leaving aroom and entering another or
// the source or destination object can give messages (dropping or
// taking things)
// a retvalue of 1 means success to move, 0 means failure.

int move(mixed dest,int method)
{
  object source;
  int weight;

  if (!(method & M_NOCHECK))
  {
    if (QueryProp(P_NODROP) &&  (method & (M_PUT|M_GIVE|M_DROP)))
      return ME_CANT_BE_DROPPED;
    if (QueryProp(P_NOGET) &&  (method & M_GET))
      return ME_CANT_BE_TAKEN;
    weight=(int)QueryProp(P_TOTAL_WEIGHT);
    if (!weight)
      weight=(int)QueryProp(P_WEIGHT);
    if ((int)dest->MayAddWeight(weight)==-1)
      return ME_TOO_HEAVY;
    if ((int)dest->MayAddBulkiness(QueryProp(P_BULKINESS))==-1)
      return ME_TOO_BULKY;
    if (dest->PreventInsert(this_object()))
      return ME_CANT_BE_INSERTED;
  }
  else
    dest->PreventInsert(this_object());

  if (environment(this_object()))
      environment(this_object())->LeaveMe(this_object());

  move_object( dest );
  return (method & M_SILENT ? MOVE_OK_SILENT : MOVE_OK);
}

// remove()
//
// This is called when someone wants to destruct us. Objects normally
// can be destructed - well, this is only a simulation, someone could
// leave a nice message "The xxx turns onto a terrible blast of Energy"
// if he wants :)
// You also can redefine it if you want...
// 1 means success, destruction complete, 0 is failure.

varargs int remove()
{
  destruct(this_object());
  return 1;
}

varargs int deep_remove(int force, int silent)
{
  object * inv;
  
  for (inv = all_inventory();sizeof(inv);inv = inv[1..])
  {
    inv[0]->deep_remove(force, silent);
    if (force && inv[0])
      destruct(inv[0]);
  }
  return remove(silent);
}