/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: pricing.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// Wunderland Mudlib
//
// /STD/THING/PRICING.C
//
// Author: Troy@Wunderland
//
/*
 * $Date: 1999/11/05 12:30:47 $
 * $Revision: 1.1.1.1 $
 * $Log: pricing.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:47  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:14  en
 * MUDLib CVS Preperation
 *
 * Revision 1.3  1998/06/26 23:56:04  Gum
 * kleine aenderungen im header
 *
 * Revision 1.2  1997/01/08 08:30:15  Bongo
 * RCS-Kommentar eingebaut
 *
 */

#pragma strong_types

#include <properties.h>

#define DEFAULT_CM "/obj/coinmaster_WL"

static int get_list_width(mixed *items);
static int get_width(mixed *items);

object get_active_cm()
{
  string cs;
  object cm;
  if(!(cs=(string)call_other(this_object(),"QueryProp",P_COINMASTER))) cs=DEFAULT_CM;
  call_other(cs,"???");
  if(!(cm=find_object(cs)) || !objectp(cm)) return 0;
  return cm;
}

string charstr(string char, int times)
{
  string s;
  s = "";
  if(strlen(char)!=1) return "";
  for(;times>0;times--) s += char;
  return s;
}

/* right-adjust */
string radj(string str,int len)
{
  return (charstr(" ",len)+str)[<len..];
}

/* left-adjust */
string ladj(string str,int len)
{
  return (str+charstr(" ",len))[0..len-1];
}

/* center-adjust */
string cadj(string str,int len)
{
  int odd;
  if(!stringp(str) || strlen(str)>=len) return str;
  len -= strlen(str);
  odd=(len-((len/2)*2));
  return charstr(" ",len/2)+str+charstr(" ",(len/2)+odd);
}

/* Returns the Headline for the coin-coulumns. */
string HeadLine()
{
  int *mind;
  string ret;
  object cm;
  mapping currency;
  if(!(cm=get_active_cm()) || !(currency=cm->query_coins()) ||
     !mappingp(currency) || !m_sizeof(currency)) return "";
  ret = "";
  mind=(int*)m_indices(currency);
  for(mind=(int*)sort_array(mind,#'<);sizeof(mind);mind=mind[1..])
    ret += radj(currency[mind[0]][4],6);
  return ret;
}

/* Returns a string which contains the coin-values in columns */
string MakeValString(mapping vals)
{
  int *mind;
  string ret;
  mapping currency;
  object cm;
  if(!(cm=get_active_cm()) || !(currency=cm->query_coins()) ||
     !mappingp(currency) || !m_sizeof(currency)) return "";
  ret = "";
  mind=(int*)m_indices(currency);
  for(mind=(int*)sort_array(mind, #'<);sizeof(mind);mind=mind[1..])
    if(vals[mind[0]]) ret += (" "+radj(vals[mind[0]][0],5));
    else ret += "      ";
  return ret;
}

static string make_line(mixed *line, int width, int cw)
{
  object cm;
  if(!(cm=get_active_cm()) || !sizeof(line) || !stringp(line[0]) || !strlen((string)line[0]))
    return charstr(" ",width);
  if(sizeof(line)<2 || !intp(line[1]) || !line[1])
    return ladj(line[0],width);
  return ladj(line[0],cw)+":"+radj(MakeValString(cm->ExchangeValue((int)line[1])),width-(cw+1));
}

#define LMARG (margin?margchar+charstr(" ",margin-1):"")
#define RMARG (margin?charstr(" ",margin-1)+margchar:"")

/* Returns a Pricelist-Sign. Parameters are: *
 * header   : Headline for the pricelist, e.g. "Preise" *
 * margchar : a one-char string containing the char used for the margins *
 * margin   : an in containing the width of the margin (0..) if zero, *
 *            magchar is obsolete. *
 * items    : an array containing all items and prices, each in pairs. *
 *            A separate headline may be entered by not using the price. *
 * width    : optional. If given, it will be used as maximum width WITHOUT margins. *
 */
string MakePriceList(string header,string margchar,int margin,mixed* items,int width)
{
  int cw;
  string *s;
  if(!header || !stringp(header) || !strlen(header)) header = "";
  if(!margchar || !stringp(margchar) || !strlen(margchar)) margchar = "*";
  if(!intp(margin) || margin < 0) margin = 0;
  if(!items || !pointerp(items) || !sizeof(items)) return "";
  if(!width || !intp(width) || width<get_width(items)) width = get_width(items);
  s = ({ charstr(margchar,width+2*margin),
	 LMARG+charstr(" ",width)+RMARG });
  if(strlen(header))
      s += ({ LMARG+cadj(header,width)+RMARG,
	      LMARG+cadj(charstr("=",strlen(header)),width)+RMARG,
	      LMARG+charstr(" ",width)+RMARG });
  s+= ({ LMARG+radj(HeadLine(),width)+RMARG,
	      LMARG+charstr(" ",width)+RMARG });
  for(cw=get_list_width(items);sizeof(items);items=items[1..])
    if(sizeof(items[0])) s += ({ LMARG+make_line(items[0],width,cw)+RMARG });
  s += ({ LMARG+charstr(" ",width)+RMARG,
	  charstr(margchar,width+2*margin) });
  return efun::implode(s,"\n");
}

static int get_list_width(mixed *items)
{
  int w,i;
  for(w=0,i=0;i<sizeof(items);i++)
    if(sizeof(items[i]) && stringp(items[i][0]) && w<strlen(items[i][0]))
      w=strlen(items[i][0]);
  return w;
}

static int get_width(mixed *items)
{
  return get_list_width(items)+strlen(HeadLine())+1;
}
