/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: properties.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// MD Mudlib
//
// /std/thing/properties.c -- most general class (property handling)
//
// basierend auf der MorgenGrauen MUDlib
//
// (c) 1993 Hate@MorgenGrauen, Mateese@NightFall
//          Idea and Code      Flames and Destructions
//
// IDEA: normalising the propertysystem and providing and easy to use and
//       efficient design to produce configurable objects
//
// IMPLEMENTATION:
//       * everything is a property (even the functions over properties)
//         there us just one exception the set/query filter functions :(
//       * two functions Set() and Query() provide direct access to it 
//         (and ONLY direct access)
//       * two further functions SetProp() and QueryProp() use the function
//         funcall() to apply the standard methods F_SET and F_QUERY for 
//         the specific property
//
// AENDERUNGEN (12.Jun.94/Jof)
//       * Properties werden jetzt in einem Array von 4 Mappings ab-
//         gelegt; 0-Elemente werden entfernt. Damit ist magier:jof
//         von ca 36 KB auf ca 30 KB geschrumpft
//       * Die LFUN-Closures #'this_object->set_... und query_ ...
//         entfernt, stattdessen call_resolved in Set und Query.
//         Langsamer, mag als Rueckschritt erscheinen. Aber:
//         magier:jof ist von ca 30 auf ca 27.5 KB geschrumpft - und
//         unsere Speichersituation ist verzweifelt. HOPE THIS HELPS
//       * HACK: Wenn die spezielle SetMethod -1 uebergeben wird, wird
//         stattdessen das Flag NOSETMETHOD gesetzt - hat nochmal einige
//         100 Bytes gespart. Ich hoffe, Hate lyncht mich nicht - aber
//         Einsparungen waren definitiv notwendig :(
// 
// INTERNALS:
//       * properties are stored in a mapping
//
// The propertymapping:
// STRUCTURE: ([ name : Value ; flags ; set_method ; query_method , ...])
// JETZT NEU:
// SRUCTURE: ({([ name : Value, ...]),
//             ([ name : flags, ...]),
//             ([ name : set_method, ...]),
//             ([ name : query_method, ...])
//           })
// name 	-- Name of the property
// Value    	-- the value of any type
// set_method	-- a method executed when SetProp() is called
// query_method	-- a method executed when QueryProp() is called
// flags	-- contains needed flags
//			PROTECED - any set of the property is protected
//			SAVE     - property will be saved with save_object()
//
// $Id: properties.c,v 1.1.1.1 1999/11/05 12:30:47 elatar Exp $
//
// $Log: properties.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//
// Revision 1.4  1998/08/31 18:25:24  Holger
// SicherheitsBug in SetProperties entfernt
//

#pragma strong_types

#define NEED_PROTOTYPES 1

#include "/sys/thing/properties.h"
#include "/secure/wizlevels.h"

// the mapping where the actual properties are stored
static mapping *prop;

// the mapping that is used for saving
mapping properties;

static mixed _query_uid() { return getuid(this_object()); }
static mixed _query_euid() { return geteuid(this_object()); }

static void InitializeProperties()
{
  prop = ({([]),([]),([]),([])});

  Set(P_UID, -1, F_SET_METHOD);
  Set(P_UID, SECURED, F_MODE); //F_MODEas);
  Set(P_EUID, -1, F_SET_METHOD);
  Set(P_EUID, SECURED, F_MODE); //F_MODEas);
}

void create() { InitializeProperties(); }

static int allowed()
{
  return
     (previous_object() && IS_ARCH(getuid(previous_object())) &&
      this_interactive() && IS_ARCH(this_interactive())) ||
     (previous_object() && getuid(previous_object()) == ROOTID &&
      geteuid(previous_object()) == ROOTID);
}

// Set() -- provides direct access to a property, no filters
//
varargs mixed Set(string name, mixed Value, int Type)
{
  if(!pointerp(prop)) InitializeProperties();
  
  if(extern_call() && previous_object()!=this_object() && !allowed() &&
     (prop[F_MODE][name] & (PROTECTED|SECURED)))
    return -1;

  //if(Type == F_MODE || Type == F_MODE_AD)
  //{
  //  printf("DOIT: %O %O %s\n",this_object(),Value,name);
  //}

//  if ((Type == F_MODE || Type == F_MODE_AD )
  if ((prop[F_MODE][name] & SECURED) && (Type == F_MODE) && (Value & SECURED))
    return -2;

  if(Type == F_MODE) prop[F_MODE][name] ^= (intp(Value)?Value:0);
  else if(Type == F_MODE_AS) prop[F_MODE][name] |= Value;
  else if(Type == F_MODE_AD) prop[F_MODE][name] &= ~Value;
  else
  {
    if((Type == F_SET_METHOD || Type == F_QUERY_METHOD) && 
       (closurep(Value) && !query_closure_object(Value)))
    {
      if(extern_call() &&
	 (geteuid(previous_object())!=geteuid(this_object()) ||
	  getuid(previous_object())!=getuid(this_object())))
	return prop[Type][name];
      Value=bind_lambda(Value, this_object());
    }
    if (Value==-1 && Type==F_SET_METHOD)
    {
      Value=0;
      prop[F_MODE][name]|=NOSETMETHOD;
    }
    prop[Type][name] = Value;
  }

  if (Type == F_MODE_AS || Type == F_MODE_AD) Type = F_MODE;
  if (!prop[Type][name]) prop[Type] = m_delete(prop[Type],name);

  return prop[Type][name];
}

// Query() -- directly retrieves the current value of the property, no filters
//
varargs mixed Query(string name, int Type)
{
  if(!pointerp(prop)) InitializeProperties();
  return prop[Type][name];
}

// SetProp() -- filters the value of the property with F_SET method
//
mixed SetProp(string name, mixed Value)
{
  closure func;
  mixed result;
  
  if(!objectp(this_object())) return -1; // Klappt offenbar NICHT im Create !
  if(!pointerp(prop)) InitializeProperties();

  if (Query(name,F_MODE)&NOSETMETHOD)
    return -1;

  if(func = Query(name, F_SET_METHOD))
    return closurep(func) ? funcall(func, Value, name) : func;
  
  if (func=symbol_function("_set_"+name,this_object()))
    return funcall(func,Value);
  else
    return Set(name, Value);
}

// QueryProp() filters the value of the property with F_QUERY method
//
mixed QueryProp(string name)
{
  closure func;
  mixed result;
  
  if(!objectp(this_object())) return -1;
  if(!pointerp(prop)) InitializeProperties();
  
  if(func = Query(name, F_QUERY_METHOD))
    return closurep(func) ? funcall(func, name) : func;
  
  if (func=symbol_function("_query_"+name, this_object()))
    return funcall(func);
  else
    return Query(name);
}

// SetProperties() -- sets all properties in one step
//
void SetProperties(mapping props)
{
  mixed name;
  int i,j;
 
  if(!pointerp(prop)) InitializeProperties();
  if(mappingp(props))
  {
    int same_object;

    same_object = (!extern_call() || previous_object() == this_object());
    name = m_indices(props);
    for(j=sizeof(name)-1; j>=0; j--)
      if(same_object || !(prop[F_MODE][name[j]] & (PROTECTED|SECURED)))
      	for (i=0;i<4;i++)
          if (props[name[j],i])
            prop[i][name[j]]=props[name[j],i];
          else
            prop[i]=m_delete(prop[i],name[j]);
  }
}

// QueryProperties() -- returns a whole mapping with all properties
//
mapping QueryProperties()
{
  mapping props;
  int i,j;
  string *name;

  if(!pointerp(prop)) InitializeProperties();
  props=allocate_mapping(0,4);
  
  for (i=0;i<4;i++)
  {
    name=m_indices(prop[i]);
    for (j=sizeof(name)-1;j>=0;j--)
      props[name[j],i]=prop[i][name[j]];
  }
  return props;
}

mixed *__query_properties()
{
  return ({copy_mapping(prop[0]),copy_mapping(prop[1]),
	   copy_mapping(prop[2]),copy_mapping(prop[3])});
}

// INTERNAL
// _set_save_data() -- sets the non static mapping properties for save
// _get_save_data() -- returns the mapping properties for restore
//
void _set_save_data(mixed data) { properties = data; }
mixed _get_save_data() { return properties; }
