/*******************
** Eldarea MUDLib **
********************
**
** std/thing/restrictions.c - object restrictions
**
** CVS DATA
** $Date: 2000/12/04 11:29:10 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: restrictions.c,v $
** Revision 1.3  2000/12/04 11:29:10  elatar
** volume, weight and specific_weight handling implemented
**
** Revision 1.2  2000/08/15 08:28:15  eldarea
** weight and volume handling implemented/rewritten
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
*/

#pragma strong_types

#define NEED_PROTOTYPES 1

#include "/sys/thing/properties.h"

#include <properties.h>
#include <language.h>

void create() 
{
  
}

// **** local property methods
static int _set_weight(int weight)
{
  float sw;
   
  if(sw=QueryProp(P_SPECIFIC_WEIGHT))
    Set(P_VOLUME,to_int(weight/sw-0.5));
  else
    Set(P_VOLUME,to_int(weight/Set(P_SPECIFIC_WEIGHT,1.0)));
  
  return SetProp(P_TOTAL_WEIGHT,
	         Set(P_WEIGHT, weight));
  /* Redefined by container/restrictions */
}

static int _set_volume(int volume)
{
  float sw;
  
  if (sw=QueryProp(P_SPECIFIC_WEIGHT))
    SetProp(P_TOTAL_WEIGHT,
      Set(P_WEIGHT, to_int(volume*sw)));
  else
    SetProp(P_TOTAL_WEIGHT,
      Set(P_WEIGHT, to_int(volume*Set(P_SPECIFIC_WEIGHT,1.0))));
  return Set(P_VOLUME,volume);
}

static float _set_specific_weight(float spec_weight)
{    
  SetProp(P_TOTAL_WEIGHT,
    Set(P_WEIGHT,to_int(QueryProp(P_VOLUME)*spec_weight+0.5)));
  
  return Set(P_SPECIFIC_WEIGHT,spec_weight); 
}

