/*******************
** Eldarea MUDLib **
********************
**
** std/thing/util.c - 
**
** CVS DATA
** $Date: 2001/02/01 14:10:37 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: util.c,v $
** Revision 1.2  2001/02/01 14:10:37  elatar
** applied strong_types requirements
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#define NEED_PROTOTYPES 1
#include <thing/properties.h>

void ShowPropList(string * props);
static void PrettyDump(mixed x);
static void DumpArray(mixed * x);
static void DumpMapping(mapping x);
static void DumpKeyValPair(mapping x, int i);

void ShowPropList(string * props) 
{
  int i;
  for (i = 0; i < sizeof(props); i++) 
  {
    write("*"+props[i]+": ");
    PrettyDump(QueryProp(props[i]));
    write("\n");
  }
}

static void PrettyDump(mixed x) 
{
  if (pointerp(x)) 
  {
    DumpArray(x);
  }
  else if (mappingp(x))
  {
    DumpMapping(x);
  }
  else if (objectp(x)) 
  {
    write ("OBJ("+file_name(x)+")");
  }
  else if (stringp(x))
  {
    write("\""+x+"\"");
  }
  else
    write (x);
}

static void DumpArray(mixed * x) 
{
  int i;
  write ("({ ");
  if (sizeof(x)) {
    for (i = 0; i < sizeof(x)-1; i++) 
    {
      PrettyDump(x[i]);
      write(", ");
    }
    PrettyDump(x[i]);
    write (" ");
  }
  write ("})");
}

static void DumpMapping(mapping x)
{
  int i, c;
  write("([ ");
  c = m_sizeof(x);
  if (!c)
  {
    write(" ])");
    return;
  }
  DumpKeyValPair(x, 0);
  for (i=1; i<c; i++)
  {
    write(", ");
    DumpKeyValPair(x, i);
  }
  write(" ])");
}

static void DumpKeyValPair(mapping x, int i) // Lacht nicht ueber den Namen!!! -Boing
{
  int j, vc;
  vc = get_type_info(x)[1];
  PrettyDump(m_indices(x)[i]);
  write(" : ");
  PrettyDump(x[m_indices(x)[i]]);
  for (j=1; j<vc; j++)
  {
    write("; ");
    PrettyDump(x[m_indices(x)[i], j]);
  }
}
