/*******************
** Eldarea MUDLib **
********************
**
** std/tool.c - Basisobjekt fuer sicherheitsrelevante Objekte (Tools)
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** Von dieser Unterklasse von std/thing.c sollten alle Magiertools, 
** zumindest aber jene in /obj/tools/ und jene, welche eine effektive
** User-ID != 0 verwenden, abgeleitet werden.
**
** (c) 1999 Adrian Holzwarth / Anatol@Silberland
**
** CVS History
**
** $Log:$
**
*/

#pragma strong_types

inherit "std/thing";

#include <properties.h>

static int secure() {
  return ((this_interactive()) && 
          (this_player()==this_interactive()) &&
          (this_player()==environment(this_object())) &&
          (!process_call()));
}

public void create() {
  ::create();
  AddId("TOOL");
}


public varargs string long() {
  return funcall(QueryProp(P_LONG));
}

public string short() {
  if (QueryProp(P_INVIS)) return 0;
  if (QueryProp(P_SHORT))
    return funcall(QueryProp(P_SHORT))+".\n";
}

public varargs string GetSmell(mixed race) {
  mixed smell;

  if (stringp(race)) race=lower_case(race);
  smell = funcall(QueryProp(P_SMELL));
  if (mappingp(smell)) smell = smell[race] || smell[0];
  if (stringp(smell)) return smell;
  else return 0;
}

public varargs string GetSound(mixed race) {
  mixed sound;

  if (stringp(race)) race=lower_case(race);
  sound = funcall(QueryProp(P_SOUND));
  if (mappingp(sound)) sound = sound[race] || sound[0];
  if (stringp(sound)) return sound;
  else return 0;
}

public varargs string GetDetail(mixed key, mixed race) {
  mixed detail;
 
  if (stringp(race)) race=lower_case(race);
  detail = Query(P_DETAILS)[key];
  if (mappingp(detail)) detail = detail[race] || detail[0];
  if (stringp(detail)) return detail;
  else return 0;
}

public varargs string GetReadDetail(mixed key, mixed race) {
  mixed detail;

  if ((id(key) && (detail=funcall(QueryProp(P_READ_MSG)))) ||
      (detail=Query(P_READ_DETAILS)[key]))
    if (mappingp(detail))
      detail = (stringp(race)?detail[lower_case(race)]:0) || detail[0];
  if (stringp(detail)) return detail;
}

public int lies(string str) {
  string detail;

  _notify_fail("Was moechtest Du lesen?\n");
  if (!str || !id(str)) return 0;
  if (!this_player()->CanSee()) return 1;
  if (QueryProp(P_READ_MSG))
    return (int)write(funcall(QueryProp(P_READ_MSG))), 1;
  else if (detail = funcall(QueryProp(P_READ_DETAILS)[str]))
    return (int)write(detail);
  else return 0;
}

public int read(string str) { return lies(str); }

