/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: trade.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// /STD/TRADE.C - Grundfunktionen fuer den Handel
//
// $Log: trade.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:13  en
// MUDLib CVS Preperation
//
// Revision 1.3  1999/06/16 12:18:43  Holger
// Funktionalitaet erweitert
//
// Revision 1.2  1999/05/06 10:03:20  Fiona
// Coinmaster und seine Infos nun mehr oder weniger statisch (Elric)
//
// Revision 1.1  1999/02/16 17:07:33  Fiona
// Initial revision
//
//

// 25.05.99 00:59 (Elric)
//
// Einige unnoetige Funktionen entfernt!
// Diese koennen problemlos durch sprintf-Aufrufe ersetzt werden:
//
// charstr("X", int times)   --> sprintf("%'X'*s", times, "");
// ladj(string str, int len) --> sprintf("%-' ':*s", len, (string)str);
// radj(string str, int len) --> sprintf("%+' ':*s", len, (string)str);
// cadj(string str, int len) --> sprintf("%|' ':*s", len, (string)str);

#pragma strong_types

#include <properties.h>

#define NEED_PROTOTYPES
#include <thing/properties.h>

private static object CoinMaster;
private static mapping Coins;
private static int *Indices;
private static string HLine;

static object GetActiveCM()
{
	string CoinMasterString;

	if (objectp(CoinMaster)) return CoinMaster;

	Coins            = ([]);
	Indices          = ({});
	CoinMasterString = (string)QueryProp(P_COINMASTER);

	if (!stringp(CoinMasterString)) return 0;

	Coins      = (mapping)CoinMasterString->query_coins();
	CoinMaster = find_object(CoinMasterString);
	Indices    = (int*)sort_array((int*)m_indices(Coins), #'<);
	HLine      = sprintf("%@' ':6s", map_array(Indices, lambda(({'x, 'y}),
			({#'[, ({#'[, 'y, 'x}), 4})), Coins));

	return CoinMaster;
}

static string HeadLine()
{
	int count;
	string ret;

	if (!objectp(CoinMaster)) CoinMaster = GetActiveCM();

	return HLine;
}

static string MakeValString(mapping vals)
{
	int count, size;
	string ret;
	mixed dummy;

	if (!objectp(CoinMaster)) CoinMaster = GetActiveCM();
	if (!objectp(CoinMaster)) return "";

	ret  = "";
	size = sizeof(Indices);

	for(count = 0; count < size; count++)
	{
		dummy = vals[Indices[count]];

		ret += (pointerp(dummy) ? sprintf("%' ':6i", dummy[0]) : "      ");
	}

	return ret;
}

static string SpecCostStr(mapping vals)
{
	int count, size, dummy1;
	string *ret;
	mixed dummy2;

	if (!objectp(CoinMaster)) CoinMaster = GetActiveCM();
	if (!objectp(CoinMaster)) return "";

	ret  = ({});
	size = sizeof(Indices);

	for(count = 0; count < size; count++)
	{
		dummy1 = Indices[count];
		dummy2 = vals[dummy1];

		if (pointerp(dummy2)) ret += ({dummy2[0] + " " + (dummy2[0] > 1 ?
			Coins[dummy1][2] : Coins[dummy1][1])});
	}

	switch (sizeof(ret))
	{
		case 0: return "";
		case 1:	return ret[0];
	}

	return implode(ret[0..<2], ", ") + " und " + ret[<1];
}

static string CostStr(int wert)
{
	object CoinMaster;

	if (!objectp(CoinMaster)) CoinMaster = GetActiveCM();

	return SpecCostStr(CoinMaster->ExchangeValue(wert));
}

static object FindTrader()
{
	mixed ids;
	int count;
	object trader;

	if ((int)QueryProp(P_TRADER_NEEDED) == 1) return present("\ntrader", this_object());

	ids = (mixed)QueryProp(P_TRADER_NEEDED);

	if (pointerp(ids) && (count = sizeof(ids)))
		for (; count--;) if (trader = present(ids[count], this_object())) return trader;

	return 0;
}

static string MakePriceList(string title, string marginchar, int marginwidth, mixed* items, int width)
{
	int iwidth, hwidth, i, size;
	string eline, lmargin, rmargin, list;
	closure c_sprintf;

	if (!objectp(CoinMaster)) CoinMaster = GetActiveCM();
	if (!pointerp(items)) return "";

	items = filter(items, lambda(({'x}), ({#'&&, ({#'pointerp, 'x}), ({#'sizeof, 'x})})));

	if (!sizeof(items)) return "";
	if (!stringp(title)) title = "";
	if (!stringp(marginchar) || !strlen(marginchar)) marginchar = "*";
	if (!intp(marginwidth) || (marginwidth < 0)) marginwidth = 0;

	hwidth  = strlen(HLine);
	iwidth  = 0;

	for (i = sizeof(items); i--;)
		if (iwidth < (size = strlen(items[i][0]))) iwidth = size;

	c_sprintf = symbol_function("sprintf");
	lmargin   = (marginwidth ? funcall(c_sprintf, "%s%' '*s", marginchar, marginwidth - 1, "") : "");
	rmargin   = (marginwidth ? funcall(c_sprintf, "%' '*s%s", marginwidth - 1, "", marginchar) : "");

	if (!intp(width) || (width <= 0)) width = iwidth;
	else if (width < iwidth) iwidth = width;

	width = iwidth + hwidth + 1;
	eline = funcall(c_sprintf, "%s%|' ':*s%s\n", lmargin, width, "", rmargin);
	list  = funcall(c_sprintf, funcall(c_sprintf, "\n%%'%s':*s\n%s", marginchar, eline),
			width + 2 * marginwidth, "");

	if (strlen(title))
		list += funcall(c_sprintf, "%s%|' ':*s%s\n%s%|' ':*s%s\n%s", lmargin, width,
			title, rmargin, lmargin, width,	funcall(c_sprintf, "%'=':*s",
			strlen(title), ""), rmargin, eline);

	list += funcall(c_sprintf, "%s%+' ':*s%s\n%s", lmargin, width, HLine, rmargin, eline);

	for (size = sizeof(items), i = 0; i < size; i++)
	{
		if (!stringp(items[i][0]) || !strlen(items[i][0]))
		{
			list += eline;
			continue;
		}

		if ((sizeof(items[i]) < 2) || !intp(items[i][1]) || !items[i][1])
		{
			list += funcall(c_sprintf, "%s%-' ':*s%s\n", lmargin, width,
					items[i][0] + ":", rmargin);
			continue;
		}

		list += funcall(c_sprintf, "%s%-' ':*s %s%s\n", lmargin, iwidth, items[i][0],
				MakeValString(CoinMaster->ExchangeValue((int)items[i][1])),
				rmargin);
	}
				
	list += funcall(c_sprintf, funcall(c_sprintf, "%s%%'%s':*s\n", eline, marginchar),
			width + 2 * marginwidth, "");

	return list;
}
