/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2001/01/31 13:42:19 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: transport.c,v $
** Revision 1.2  2001/01/31 13:42:19  elatar
** process_string() replaced by funcall()
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// Wunderland MUDlib
// basierend auf der MorgenGrauen MUDlib
//
// TRANSPORT.C -- transport standard object
//
/*
 * $Date: 2001/01/31 13:42:19 $
 * $Revision: 1.2 $
 * $Log: transport.c,v $
 * Revision 1.2  2001/01/31 13:42:19  elatar
 * process_string() replaced by funcall()
 *
 * Revision 1.1.1.1  1999/11/05 12:30:47  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:13  en
 * MUDLib CVS Preperation
 *
 * Revision 1.5  1999/01/16 19:57:46  Fiona
 * Transports werden jetzt auch wieder Invis ;o)
 *
 * Revision 1.4  1998/12/01 15:35:31  Fiona
 * P_TRANSPORT eingefuehrt
 *
 * Revision 1.3  1998/12/01 14:08:51  Fiona
 * clean_up() returned nun 0
 *
 * Revision 1.2  1998/06/27 02:38:07  Gum
 * kleine aenderungen m header
 * 78 in BS_STDLEN geaendert
 *
 */

inherit "std/thing/moving";
inherit "std/room";

#include <properties.h>
#include <moving.h>
#include <defines.h>
#include <language.h>

/* transport.c
 * Hates und Rumatas generisches Transport Objekt
 * MorgenGrauen 15.2.93
 *
 * Dokumentation in /doc/std/transport
 */

/********************** Variablen **********************/

mixed *route;	/* Liste der Haltepunkte. */
int rpos;	/* Momentane position in obiger Liste. */
string roomCode;/* Code des aktuellen Raumes (oder 0). */
string short;	/* ==  P_SHORT */
int transparent; /* == P_TRANSPARENT */

/********* Management der builtin-properties ***********/

_set_short( str )
{ return short = str; }

_query_short()
{ if ( roomCode ) return short; }

_query_plural()
{ if ( roomCode ) return Query(P_PLURAL); }

_set_transparent( val )
{ return transparent = val; }

_query_transparent()
{ if ( roomCode ) return transparent; }

/***************** Zugriffsfunktionen ****************/

public Start( pos )
{
  Halt();
  rpos = ( pos>=sizeof(route) ) ? -1 : pos-1;
  call_out( "changeHp", 0 );
}

public Halt()
{
  while (remove_call_out( "changeHp" )>-1);
  while (remove_call_out( "disconnect" )>-1);
}

public AddRoute( room, stay, next, code )
{
  route += ({ ({ HP_ROOM, room, stay, next, code }) });
}

public AddMsg( msg, next )
{
  route += ({ ({ HP_MSG, msg, next }) });
}

public AddFun( fun, next )
{
  route += ({ ({ HP_FUN, fun, next }) });
}

public QueryArrived()
{
  /* sollte es nich besser QueryRoom() heissen ? */
  return roomCode;
}

public QueryPosition()
{
  return ({ route[rpos][1], route[(rpos+1)<sizeof(route)?(rpos+1):0][1] });
}

public QueryPassengers()
{
  mixed *livings;
  object ob;

  livings = ({});
  for ( ob = first_inventory(ME); ob; ob = next_inventory( ob ) )
    if ( living(ob) ) livings += ({ ob });

  return livings;
}

public RemoveRoute()
{
  Halt();
  route = ({ });
  rpos = 0;
}

public Enter()
{
  string msgs;
  int maxpassengers;

  if ( environment(this_player()) == ME )
  {
    write( "Da bist Du bereits.\n" );
    return 1;
  }

  if( !roomCode )
    return 0;

  maxpassengers = QueryProp( P_MAX_PASSENGERS );
  if ( maxpassengers && sizeof(QueryPassengers()) >= maxpassengers )
  {
    if ( pointerp( msgs = QueryProp(P_ENTERFAIL) ) )
    {
      say( this_player()->name(WER,2) + " " + msgs[1] + ".\n" );
      msgs = msgs[0];
    }
    write( msgs + ".\n" );
    return 1;
  }
  if ( !pointerp( msgs = QueryProp(P_ENTERMSG) ) )
    msgs = ({ 0,0 });
  return this_player()->move( ME, M_GO, 0, msgs[0], msgs[1] );
}

public Leave()
{
  string msgs;

  if ( environment(this_player()) != ME )
  {
		if( roomCode )
		{
			write( "Dafuer muesstest Du erstmal dort sein.\n" );
			return 1;
		}
		return 0;
  }

  if( !roomCode )
  {
    if ( pointerp( msgs = QueryProp(P_LEAVEFAIL) ) )
    {
      say( this_player()->name(WER,2) + " " + msgs[1] + ".\n" );
      msgs = msgs[0];
    }
    write( msgs + ".\n" );
    return 1;
  }
  if ( !pointerp( msgs = QueryProp(P_LEAVEMSG) ) )
    msgs = ({ 0,0 });
  return this_player()->move( environment(), M_GO, 0,
			     msgs[0], msgs[1] );
}


/****************** Internal Functions ******************/

public create()
{
  ::create();
  route = ({});
  SetProp( P_ENTERCMDS, ({}) );
  SetProp( P_LEAVEFAIL, "Das geht jetzt nicht" );
  SetProp( P_ENTERFAIL, "Dort ist kein Platz" );
  SetProp( P_TRANSPORT, 1 );
}

public remove()
{
  destruct( ME ); /* schoener waere "::remove();" */
  return 1;
}

changeHp()
{
  if ( ++rpos == sizeof(route) )
    rpos = 0;
  if ( route[rpos][0] == HP_MSG )
  {
    tell_room( this_object(), route[rpos][1] );
    call_out( "changeHp", route[rpos][2] );
  }
  else if ( route[rpos][0] == HP_FUN )
  {
    call_out( "changeHp", route[rpos][2] );
    call_other( ME, route[rpos][1] );
  }
  else /* route[rpos][0] == HP_ROOM */
  {
    connect( route[rpos][1], route[rpos][4] );
    call_out( "disconnect", route[rpos][2] );
    call_out( "changeHp", route[rpos][2]+route[rpos][3] );
  }
}

connect( room, code )
{
  mixed *arrivemsg;

  if ( roomCode ) disconnect();
  roomCode = code ? code : "";
  if ( catch(move( room , M_SILENT | M_NOCHECK )) )
  { /* Wenn der "Hafen" kein korrekter Raum ist ... */
    roomCode = 0;
    return;
  }
  arrivemsg = QueryProp(P_ARRIVEMSG);
  if ( pointerp(arrivemsg) )
  {
    tell_room( ME, funcall(arrivemsg[0]));
    tell_room( room, funcall(arrivemsg[1]));
  }
}

disconnect()
{
  string room;
  mixed *departmsg;

  departmsg = QueryProp(P_DEPARTMSG);
  if ( (room=environment()) && pointerp(departmsg) )
  {
    tell_room( ME, funcall(departmsg[0]));
    tell_room( room, funcall(departmsg[1]));
  }
  roomCode = 0;
}

clean_up(arg)
{
  return 0; // Never try to clean again (until swapped)
}

void __restart(string funname)
{
  if(!funname||funname==""||(funname!="changeHp"&&funname!="disconnect"))
    return;
  while(remove_call_out(funname)!=-1);
  call_out(funname,funname=="changeHp"?15:5);
}
