/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: unit.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland MUDlib
//
// STD/UNIT.C -- Ein Object welches mehrere einer Sorte darstellt
//
// basierend auf der MorgenGrauen MUDlib
//
// $Revision: 1.1.1.1 $
//
// $Log: unit.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:13  en
// MUDLib CVS Preperation
//
// Revision 1.15  1999/05/12 20:52:54  Holger
// load_name() statt explode(file_name()) eingebaut
//
// Revision 1.14  1999/04/07 06:50:35  Holger
// Es gibt keine negativen Amounts mehr im Unit
//
// Revision 1.13  1999/01/19 15:19:23  Fiona
// P_PLURAL gesetzt
//
// Revision 1.12  1999/01/18 17:05:20  Fiona
// Einbau NAME_UACT
//
// Revision 1.11  1999/01/15 18:23:53  Holger
// Hatte vergessen DEBUG auszukommentieren. :(
//
// Revision 1.10  1999/01/15 18:15:57  Fiona
// move() neu   (Holger)
//
// Revision 1.9  1998/08/21 16:28:23  Gum
// bulkiness fuer units eingebaut
//
// Revision 1.8  1998/07/09 13:09:58  Gum
// in move returnwerte MOVE_OK und MOVE_SILENT eingebaut
// id liefert 0, wenn P_AMOUNT == 0
//
// Revision 1.7  1998/06/27 02:38:07  Gum
// kleine aenderungen im header
// 78 in BS_STDLEN geaendert
//
// Revision 1.6  1998/06/15 12:04:40  Gum
// in move() wird beim neuclonen im ziel im geclonten objekt U_REQ gesetzt
// (bugfix von RayOne)
//
// Revision 1.5  1998/04/22 12:11:27  Fiona
// AddAmount() testete nicht ob Anzahl danach noch != 0 war

inherit "std/thing";

#define DEBUG(x) if(find_living("holger")) tell_object(find_living("holger"), sprintf("%O",x))

#define NEED_PROTOTYPES

#include <properties.h>
#include <thing/properties.h>
#include <defines.h>
#include <moving.h>
#include <units.h>

static string lastverb;

static void check_leave() {
  if (Query(P_AMOUNT)>0)
    return;
  remove();
}

static void envchk()
{
  if (!environment())
    remove();
}

void create()
{
  ::create();
  Set(U_IDS, ({({}), ({})}));
  Set(P_AMOUNT, 1);
  SetProp(P_PLURAL, ""); // wichtig, damit sie nicht zusammengefasst werden
  Set(U_BPU, ({ 2, 1 }));
  Set(U_GPU, ({ 1, 1 }));
  Set(U_CPU, ({ 0, 1 }));
  SetProp(P_ARTICLE, 0);
  Set(U_REQ, 1);
  call_out("envchk", 1);
}

void reset()
{
  if (!Query(P_AMOUNT))
    remove();
}

int remove(int silent)
{
  int r;

  if (silent > 1 && (r = QueryProp(U_REQ)))
  {
    SetProp(P_AMOUNT, QueryProp(P_AMOUNT) - r);
    return 1;
  }

  return ::remove(silent);
}

static void _set_name(mixed names)
{
  if (!names)
    return Set(P_NAME, ({ ({ "", "", "", "" }), ({ "", "", "", "" }) }));

  if (stringp(names))
    return Set(P_NAME, ({ ({ names, names, names, names }),
                          ({ names, names, names, names }) }));
  if (pointerp(names))
  {
    switch (sizeof(names))
    {
      case 0:
        return Set(P_NAME, ({ ({ "", "", "", "" }), ({ "", "", "", "" }) }));
      case 1:
        if (stringp(names[0]))
          return Set(P_NAME, ({ ({ names[0], names[0], names[0], names[0] }),
                                ({ names[0], names[0], names[0], names[0] }) }));
        if (pointerp(names[0]))
        {
          switch (sizeof(names[0]))
          {
            case 0:
              return Set(P_NAME, ({ ({ "", "", "", "" }), ({ "", "", "", "" }) }));
            case 1:
              if (!stringp(names[0][0]))
                return Set(P_NAME, ({ ({ "", "", "", "" }), ({ "", "", "", "" }) }));
              return Set(P_NAME, ({ ({ names[0][0], names[0][0], names[0][0], names[0][0]}),
                                    ({ names[0][0], names[0][0], names[0][0], names[0][0]}) }));
            default:
              if (sizeof(names[0]) != 4 || sizeof(filter_array(names[0], #'stringp)) != 4)
              {
                if (!stringp(names[0][0]))
                  return Set(P_NAME, ({ ({ "", "", "", "" }), ({ "", "", "", "" }) }));
                else
                  return Set(P_NAME, ({ ({ names[0][0], names[0][0], names[0][0], names[0][0] }),
                                        ({ names[0][0], names[0][0], names[0][0], names[0][0] }) }));
              }
              return Set(P_NAME,({names[0],names[0]}));
          }
        }
      default:
        if (stringp(names[0]))
          names[0] = ({ names[0], names[0], names[0], names[0] });
        if (stringp(names[1]))
          names[1] = ({ names[1], names[1], names[1], names[1] });
        if (pointerp(names[0]) && pointerp(names[1]))
          return Set(P_NAME, names[0..1]);
    }
  }
}

static string *_query_name()
{
  if (Query(U_REQ) == 1)
    return (string *)Query(P_NAME)[0];
  return (string *)Query(P_NAME)[1];
}

void AddSingularId(mixed *str)
{
  string *ids;

  ids = Query(U_IDS);
  if (!pointerp(str))
    if (stringp(str)) str = ({ str });
    else return;

  Set(U_IDS, ({ ids[0] + str, ids[1] }));
}

void AddPluralId(mixed *str)
{
  string *ids;

  ids = Query(U_IDS);
  if (!pointerp(str))
  {
    if (stringp(str)) str = ({ str });
    else return;
  }
  Set(U_IDS, ({ ids[0], ids[1] + str }));
}

void SetCoinsPerUnits(int coins,int units)
{
  if (coins < 0 || units <= 0) return;
  Set(U_CPU, ({ coins, units }));
}

void SetGramsPerUnits(int grams,int units)
{
  if (grams < 0 || units <= 0) return;
  Set(U_GPU, ({ grams, units }));
}

void SetBulkinessPerUnits(int bulkiness, int units)
{
  if (bulkiness < 0 || units <= 0) return;
  Set(U_BPU, ({ bulkiness, units }));
}

int *QueryCoinsPerUnits()
{
  return Query(U_CPU);
}

int *QueryGramsPerUnits()
{
  return Query(U_GPU);
}

int *QueryBulkinessPerUnits()
{
  return Query(U_BPU);
}

private string ZahlWort(int req, int fall)
{
  switch (req)
  {
    case  0: return ({ "keinen", "keine", "kein" })[fall];
    case  1: return ({ "einen", "eine", "ein" })[fall];
    case  2: return "zwei";
    case  3: return "drei";
    case  4: return "vier";
    case  5: return "fuenf";
    case  6: return "sechs";
    case  7: return "sieben";
    case  8: return "acht";
    case  9: return "neun";
    case 10: return "zehn";
    case 11: return "elf";
    case 12: return "zwoelf";
    default: return sprintf("%d", req);
  }
}

private int GetReqFromString(string reqstr)
{
  switch (reqstr)
  {
    case "einen":
    case "eine":
    case "ein":
      return 1;
    case "zwei":
      return 2;
    case "drei":
      return 3;
    case "vier":
      return 4;
    case "fuenf":
      return 5;
    case "sechs":
      return 6;
    case "sieben":
      return 7;
    case "acht":
      return 8;
    case "neun":
      return 9;
    case "zehn":
      return 10;
    case "elf":
      return 11;
    case "zwoelf":
      return 12;
    default:
      return 0;
  }
}

varargs string name(int fall, int demo)
{
  int req;
  string desc;

  
  if (demo&NAME_UACT && (!lastverb || query_verb() != lastverb))
    Set(U_REQ, req = Query(P_AMOUNT));
  demo&=NAME_DEF|NAME_INDEF|NAME_AUTO;
  desc=funcall(QueryProp(P_DESCR));
  if (desc) desc=" "+desc;
  else desc="";

  switch (req = Query(U_REQ))
  {
    case 0:
      return 0;
    case 1:
      return QueryArticle(fall, demo, 1) + Query(P_NAME)[0][fall] + desc;
    default:
      return sprintf("%s %s", ZahlWort(req, fall), Query(P_NAME)[1][fall]+desc);
  }
}

string short()
{
  int req;

  req = Query(U_REQ);
  if (!lastverb || query_verb() != lastverb)
    Set(U_REQ, req = Query(P_AMOUNT));

  if (!req)
    return 0;

  if (req == 1)
    return sprintf("%s%s.\n", capitalize(QueryArticle(WER, 0, 1)), Query(P_NAME)[0][0]);
  else
    return sprintf("%d %s.\n", req, Query(P_NAME)[1][0]);
}

string long()
{
  return sprintf("Du siehst %s.\n", name(WEN));
}

int id(string str)
{
  int i, amount;
  string s1, s2, *ids;

  if (!str)
    return 0;

  lastverb = query_verb();
  amount = Query(P_AMOUNT);

  if (!amount)
    return 0;

  if (::id(str))
  {
    Set(U_REQ, Query(P_AMOUNT));
    return 1;
  }

  if (!(ids = Query(U_IDS)))
    return 0;

  if (match_item(str, ids[1]))
  {
    Set(U_REQ, amount);
    return 1;
  }
  if (match_item(str, ids[0]))
  {
    Set(U_REQ, 1);
    return 1;
  }
  if ((sscanf(str, "%s %s", s1, s2) == 2) && (s1[0..3] == "alle") && match_item(s2, ids[1]))
  {
    Set(U_REQ, amount);
    return 1;
  }
  if ((sscanf(str, "%s %s", s1, s2) == 2) && (i = GetReqFromString(s1)) && match_item(s2, ids[1]))
  {
    Set(U_REQ, i);
    return 1;
  }
  if ((sscanf(str, "%d %s", i, s1) == 2) && (i == 1) && match_item(s1,ids[0]))
  {
    Set(U_REQ, 1);
    return 1;
  }
  if ((sscanf(str, "%d %s", i, s1) == 2) && match_item(s1,ids[1]) && (i <= amount) && (i > 0))
  {
    Set(U_REQ, i);
    return 1;
  }
  lastverb = 0;

  return 0;
}

string QueryPronoun(int casus)
{
  if (Query(U_REQ) > 1) return ({ "sie", "ihr", "ihnen", "sie" })[casus];
  return ::QueryPronoun(casus);
}

static int _query_value()
{
  int *cpu;

  cpu = Query(U_CPU);
  return (Query(U_REQ)*cpu[0]) / cpu[1];
}

static int _query_bulkiness()
{
  object env;
  int *bpu;

  // units in einem behaelter haben keine bulkiness
  if ((env = environment(this_object())) && env->QueryProp(P_CONTAINER) && !living(env))
    return 0;
  bpu = Query(U_BPU);
  return (Query(U_REQ) * bpu[0]) / bpu[1];
}

static int _query_weight()
{
  int *gpu;
  int req;

  gpu = Query(U_GPU);
  if ((req = Query(U_REQ)) <= 0)
    return req; // Hier ists egal - aufaddiert wird ja nun nicht mehr ...
  return MAX(1, (req * gpu[0]) / gpu[1]);
}

static void _set_amount(int am)
{
  if (!am)
    call_out("check_leave", 1);
  Set(P_AMOUNT, am);
  Set(U_REQ, am);
}

void AddAmount(int am)
{
  am += Query(P_AMOUNT);
  Set(P_AMOUNT, am);
  Set(U_REQ, Query(P_AMOUNT));
  if (!am)
    call_out("check_leave", 1);
}

int move(mixed dest, int method) {
  object other, *inv;
  int err;
  string tf;
  int amount;
  int *gpu, *bpu;
  int req;

  amount = Query(P_AMOUNT);
  req = Query(U_REQ);

  // DEBUG(({ME,dest,method,amount,req}));

  if(!intp(method))
    method = 0;

  if(stringp(dest))
    dest=find_object(dest);

  if(!objectp(dest) && !(dest=environment()))
    return 0;

  if(method & M_MOVE_ALL)
    req = amount;

  if(!req)
    return (method & M_SILENT ? MOVE_OK_SILENT : MOVE_OK);

  Set(P_GIVEN_AMOUNT, req);

  tf = load_name(ME);

  if(!(method&M_NO_JOIN)) { // gleiches Unit da?
    inv = all_inventory(dest);
    while(sizeof(inv) && !other) {
      if(load_name(inv[0]) == tf)
        other = inv[0];
      else
        inv = inv[1..];
    }
    if(other)
      other->check_leave();
  }

  if(!other) {
    if(req == amount)
      return ::move( dest, method );
    else {
      other = clone_object(tf);
      other->Set(P_AMOUNT, req);
      other->Set(U_REQ, req);
      lastverb = 0;
      err = other->move(dest, method|M_MOVE_ALL );
      if(err>0) {
        Set(P_AMOUNT, amount-req);
        call_out("check_leave", 0);
        return (method & M_SILENT ? MOVE_OK_SILENT : MOVE_OK);
      }
      other->remove();
      return err;
    }
  }

  gpu = Query(U_GPU);
  bpu = Query(U_BPU);
  if(!(method&M_NOCHECK)) {
    if(dest->MayAddWeight((other->QueryProp(P_AMOUNT)+req) * 
      gpu[0]/gpu[1]-other->QueryProp(P_WEIGHT))<0)
        return ME_TOO_HEAVY;
    if(dest->MayAddBulkiness((other->QueryProp(P_AMOUNT)+req) *
      bpu[0]/bpu[1]-other->QueryProp(P_BULKINESS))<0)
        return ME_TOO_BULKY;
  }

  Set(P_AMOUNT, amount-req);
  other->AddAmount(req);
  lastverb = 0;
  call_out("check_leave", 0);

  return (method & M_SILENT ? MOVE_OK_SILENT : MOVE_OK);
}

IsUnit() {
  return 1;
}

