/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: pager.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// Wunderland MUDlib
// basierend auf der MorgenGrauen MUDlib
//
// UTIL/PAGER.C -- generic pager
//
/*
 * $Date: 1999/11/05 12:30:47 $
 * $Revision: 1.1.1.1 $
 * $Log: pager.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:47  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:14  en
 * MUDLib CVS Preperation
 *
 * Revision 1.2  1998/06/27 00:05:13  Gum
 * kleine aenderungen am header
 *
 * Revision 1.1  1995/05/02  19:19:05  mud
 * Initial revision
 *
 */

#pragma strong_types

inherit "/std/util/input";

#include "pager.h"

string prompt(mixed pinfo, string add)
{
  return sprintf(MSG_PROMPT+"%s", stringp(add)?add:"");
}

string fread(mixed pinfo, int begin, int c)
{
  if(begin > pinfo[MAXL] || begin < 0) return 0;
  if(pinfo[FILE]) return read_file(pinfo[TEXT], begin-1, c);
  else
  {
    int start, end, l;
#ifdef O_SPEED
# ifdef O_SPEED_UP
    if(member(pinfo[JUNK], begin-1)) 
    {
      start = pinfo[JUNK][begin-1];
      if(!(end = pinfo[JUNK][begin-1+c]))
        end = pinfo[JUNK][pinfo[MAXL]];
      return pinfo[TEXT][start..end];
    }
    return 0;
# else 
    end = pinfo[JUNK][begin / JUNKSIZE];
# endif
#endif
#ifndef O_SPEED_UP
    l = begin-1 + c; start = -1;
# ifdef SPEED_UP
    l -= begin / JUNKSIZE;
# endif
    while(l && (end = strstr(pinfo[TEXT], "\n", end+1)) > -1)
    {
      if(l == c) start = end;
      l--;
    }
    if(start == -1) return 0;
    return pinfo[TEXT][start..(end < 0 ? strlen(pinfo[TEXT]) : end)];
#endif
  }
}

mixed call(mixed ctrl, mixed ctrlargs)
{
  if(!ctrl || (stringp(ctrl) && !(ctrl = symbol_function(ctrl)))) return 0;
  if(!pointerp(ctrlargs)) return funcall(ctrl);
  return apply(ctrl, ctrlargs);
}

 
varargs int command(mixed in, mixed pinfo)
{
  string cprompt, tmp;
  cprompt = "";
  if(in == "q" || in == "x")
  {
    if(closurep(pinfo[CTRL])) apply(pinfo[CTRL], pinfo[CARG]);
    return 1;
  }
  else
    if(!in || (stringp(in) && !strlen(in))) pinfo[CURL] += pinfo[PAGE];
    else if(in != -1) return 0;

  if(pinfo[CURL] >= pinfo[MAXL]) 
    return (call(pinfo[CTRL], pinfo[CARG]), 1); 
  if(pinfo[CURL] <= 0) pinfo[CURL] = 1;
  if(pinfo[CURL] == 1) cprompt = MSG_TOP;
  if(pinfo[CURL] + pinfo[PAGE] >= pinfo[MAXL]) cprompt = MSG_BOTTOM;
  if(!tmp = fread(pinfo, pinfo[CURL], pinfo[PAGE]))
    return (write(MSG_OOPS+"\n"), 0);
  write(tmp);
  input(#'prompt, ({ pinfo, cprompt }), #'command, ({ pinfo }));
  return 1;
}

varargs public void More(string txt, int file, mixed ctrl, mixed ctrlargs)
{
  int j;
  mixed tmp, pinfo;
  if(!txt) return call(ctrl, ctrlargs);
  //         TEXT, FILE, CURL, MAXL, REGX, PAGE, CTRL, CARG
  pinfo = ({ txt, file, 1, 0, 20, 0, ctrl, ctrlargs });
#ifdef O_SPEED
  pinfo += ({ ([0:0]) });
#endif
  if(!pinfo[FILE]) 
    while((j = strstr(pinfo[TEXT], "\n", j+1)) != -1)
#ifdef O_SPEED
# ifdef O_SPEED_UP
      pinfo[JUNK][++pinfo[MAXL]] = j+1;
# else
      if(!(++pinfo[MAXL] % JUNKSIZE)) 
        pinfo[JUNK][pinfo[MAXL]] = j+1;
# endif
#else
     pinfo[MAXL]++;
#endif
  else
    while(tmp = read_file(pinfo[TEXT], pinfo[MAXL], MAX_LINE_READ))
      pinfo[MAXL] += sizeof(Explode(tmp, "\n"))+1;
  if(!pinfo[MAXL]) return call(ctrl, ctrlargs);
  pinfo[PAGE] = PAGELENGTH;
  pinfo[CURL] = -pinfo[PAGE];
  command(0, pinfo);
  return;
}
