/*******************
** Eldarea MUDLib **
********************
**
** std/virtual/v_compiler.c - a general virtual compiler object
**
** CVS DATA
** $Date: 1999/11/12 08:20:01 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: v_compiler.c,v $
** Revision 1.2  1999/11/12 08:20:01  elatar
** Prepared for new driver
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

// principle:
//   - inherit this object into your own 'virtual_compiler.c'
//  - customize Validate() and CustomizeObject() for you own sake
//  
//  * Validate() checks if a room filename given as argument (without path)
//    is valid and returns this filename with stripped '.c'!!
//  * CustomizeObject() uses the previous_object()->Function() strategy to
//    customize the standard object (for example to set a description)
//
// Properties: P_STD_OBJECT, P_COMPILER_PATH

#pragma strong types

inherit "/std/thing/properties";

#define NEED_PROTOTYPES

#include <thing/properties.h>
#include <defines.h>
#include <v_compiler.h>
#include "/std/sys_debug.h"

private static string last_loaded_file;
private static mapping objects;

void create()
{
  ::create();
	seteuid(getuid());
  SetProp(P_STD_OBJECT, "/std/room");
  SetProp(P_COMPILER_PATH, "/"+implode(explode(file_name(this_object()), "/")
                                [0..<2], "/"));
  objects = ([]);
}

string Validate(string file)
{
  if(file[<2..] == ".c") file = file[0..<3];
  return file;
}

mixed CustomizeObject()
{
  string file;

  if(stringp(last_loaded_file)) file = last_loaded_file;
  else file = Validate(explode(file_name(previous_object()), "/")[<1]);
  if(!file) return 0;
  last_loaded_file = 0;
  return file;
}

// add a new object to the object list if it compiles
private static mixed AddObject(string file)
{
  object ob;
  string err;

  // clean up the object list
  objects = filter_mapping(objects, 
                           lambda(({'k}), ({#'objectp, 
                                            ({#'[, ({#'objects}), 'k})
                                          })));

  last_loaded_file = file;
  // register new object
  if(ob = clone_object(QueryProp(P_STD_OBJECT)))
    objects[file] = ob;
  return ob;
}

// try to create an object for the wanted file
mixed compile_object(string file)
{
  // validate if the file name is a correct one
  if(file = Validate(file)) return AddObject(file);
}  

// return all cloned virtual objects
mixed QueryObjects()
{
  return m_values(objects)-({0});
}

// clean up rooms that have not been destructed yet
int remove()
{
  mixed ob;

  if(!mappingp(objects)) return 0;
  for(ob = QueryObjects(); sizeof(ob); ob = ob[1..])
    if(objectp(ob[0]))
    {
      ob[0]->remove();
      if(objectp(ob[0])) destruct(ob[0]);
    }
  return 1;
}
