/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: weapon.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// Wunderland MUDlib
// basierend auf der MorgenGrauen MUDlib
//
// WEAPON.C -- weapon standard object
//
/*
 * $Date: 1999/11/05 12:30:47 $                      
 * $Revision: 1.1.1.1 $       
 * $Log: weapon.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:47  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:13  en
 * MUDLib CVS Preperation
 *
 * Revision 1.19  1998/06/27 02:38:07  Gum
 * kleine aenderungen m header
 * 78 in BS_STDLEN geaendert
 *
 * Revision 1.18  1998/06/02 10:59:43  Gum
 * in _query_value wird initialize aufgerufen, wenn P_MAX_LIFETIME == 0
 *
 * Revision 1.16  1998/02/07 18:02:55  Gum
 * beim kaufen von waffen in nyx laden gabs nen bug, weil P_MAX_LIFETIME
 * noch nicht initialisiert war
 *
 * Revision 1.15  1998/02/04 11:53:04  Gum
 * _query_value vereinfacht
 *
 * Revision 1.14  1998/02/04 11:27:07  Gum
 * bugfix in costs_for_repair
 *
 * Revision 1.13  1998/02/04 11:05:28  Gum
 * initialisierung von P_MAX_CLASS und P_LIFETIME nach move verschoben
 * kosten fuers reparieren nochmal etwas erhoeht
 *
 * Revision 1.12  1998/02/03 15:33:13  Gum
 * die kosten fuer das reparieren sind jetzt hoeher als der wertverlust
 * der durch das kaempfen entsteht
 * waffen koennen jetzt nicht mehr 100% repariert werden sondern nur
 * noch zwischen 93% und 97% (per zufall)
 *
 * Revision 1.11  1998/01/20 14:09:11  Gum
 * einige aenderungen von t.
 *
 * Revision 1.10  1998/01/12 13:23:10  Gum
 * einige aenderungen von Tommy eingebaut
 *
 * Revision 1.9  1996/11/08 11:25:58  Bongo
 * M_NOCHECK fuer verfluchte Waffen korrigiert
 *
 * Revision 1.8  1996/11/07 13:10:17  Bongo
 * move() und remove() an P_CURSED angepasst
 *
 * Revision 1.8  1995/01/15  11:12:51  Andara
 * repair() setzt P_TOTAL_WC des Traegers (falls vorhanden)
 *
 * Revision 1.7  1994/10/27  11:19:14  Troy
 * Removed function show(). No longer defined (OBSOLETE)
 * Troy
 *
 * Revision 1.6  1994/10/10  13:36:46  mud
 * Bugs in der Initialisierung von Waffen beseitigt (weder P_WC, noch P_MAX_CLASS wurden automatisch und richtig gesetzt)
 * Arachna
 *
 * Revision 1.3  1994/10/07  14:12:41  mud
 * repair() und costs_for_repair() hinzugefuegt
 * Arachna
 *
 * Revision 1.2  1994/10/05  13:23:06  mud
 * Description geaendert, Zustand wird jetzt mit angezeitgt.
 * Lifetime-Berechnung, (Wert),
 * Arachna
 *
 * Revision 1.1  1994/08/24  15:48:14  mud
 * Initial revision
 *
 */                            

#pragma strong_types

inherit "/std/thing";
inherit "/std/weapon/combat";
inherit "/std/weapon/description";

#define NEED_PROTOTYPES

#include <thing/properties.h>

#include <properties.h>
#include <moving.h>
#include <defines.h>
#include <combat.h>

void create()
{
  thing::create();
  combat::create();
  description::create();
}

void init()
{
  thing::init();
  combat::init();
}

/*
string short()
{
  return description::short();
}
*/

string long()
{
  return description::long();
}

static void initialize()
{
  switch (Query(P_MAX_LIFETIME))
  {
    case -1:   // -1 bedeutet, die Waffe ist unzerstoerbar
      return;  // fuer unzerstoerbare Waffen ist hier nix zu machen
    case  0:
      // es gibt Waffen mit P_WC kleiner oder gleich 0, deshalb so umstaendlich
      Set(P_MAX_LIFETIME, abs(Query(P_WC) || 1) * 1000);
      Set(P_LIFETIME, Query(P_MAX_LIFETIME));
  }
}

int move(mixed dest, int method)
{
  initialize();

  if (ME->QueryProp(P_WIELDED) && ME->QueryProp(P_CURSED))
  {
    if (method & M_NOCHECK)
      ME->SetProp(P_CURSED, 0);
    else
      return ME_CANT_BE_DROPPED;
  }
  ME->DoUnwield( method & M_SILENT);
  return ::move(dest, method );
}

int remove(int silent )
{
  ME->SetProp(P_CURSED, 0);
  ME->DoUnwield(silent);
  return ::remove(silent);
}

void repair()
{
  object pl;
  int new_lifetime, percent;

  percent = 97 - random(5);
  new_lifetime = to_int(to_float(Query(P_MAX_LIFETIME)) * percent / 100 + 0.5);
  if (QueryProp(P_LIFETIME) < new_lifetime)
  {
    SetProp(P_LIFETIME, new_lifetime);
  }

  if (objectp(pl = QueryProp(P_WIELDED)) && pl)
  {
    pl->SetProp(P_TOTAL_WC, summe(map_objects(pl->QueryProp(P_WEAPONS), "QueryProp", P_WC)));
  }
}

// returnwert 0 bedeutet es gibt nix zu reparieren
int costs_for_repair()
{
  int min_value, max_value, cur_value, costs;
  float pct;

  // Waffe ist unzerstoerbar
  if (Query(P_MAX_LIFETIME) == -1) return 0;

  // Waffe ist noch zu gut zum reparieren
  if ((pct = 100.0 * (float)QueryProp(P_LIFETIME) / (float)QueryProp(P_MAX_LIFETIME) + 0.5) > 91.0) return 0;

  max_value = Query(P_VALUE);
  cur_value = to_int((float)max_value * pct / 100.0 + 0.5);

  // es gibt Waffen mit negativen wc!
  if ((min_value = Query(P_AC)) < 0) min_value = 0;
  min_value = (min_value + 4) * 15;

  costs = to_int((float)(max_value - cur_value) * 1.5 + 0.5);
  if (min_value > costs) costs = min_value;

  return costs;
}

int _query_value()
{
  int value, min_value;

  if (!(value = Query(P_VALUE))) return 0;
  switch (Query(P_MAX_LIFETIME))
  {
    case -1: return value;
    case  0: initialize();
  }

  return to_int((float)value * (float)QueryProp(P_LIFETIME) / (float)QueryProp(P_MAX_LIFETIME) + 0.5);
}

int _set_max_lifetime(int value)
{
  if (value == 0) value = -1;
  Set(P_MAX_LIFETIME, value);

  if (value == -1)
  {
    value = 0;
  }

  if (Query(P_LIFETIME) > value)
  {
    Set(P_LIFETIME, value);
  }

  return Query(P_MAX_LIFETIME);
}

int _set_lifetime(int value)
{
  int max;

  if ((max = Query(P_MAX_LIFETIME)) == -1)
  {
    Set(P_LIFETIME, 0);
    return Query(P_LIFETIME);
  }

  if (value > max) value = max;
  Set(P_LIFETIME, value);

  return Query(P_LIFETIME);
}

int _query_bulkiness()
{
  if (QueryProp(P_WIELDED)) return 0;
  return Query(P_BULKINESS);
}
