/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2000/12/04 11:30:01 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: combat.c,v $
** Revision 1.2  2000/12/04 11:30:01  elatar
** fixed damage to P_WC
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// Wunderland MUDlib
// basierend auf der MorgenGrauen MUDlib
//
// WEAPON/COMBAT.C -- combat part of the weapon standard object
//
// $Log: combat.c,v $
// Revision 1.2  2000/12/04 11:30:01  elatar
// fixed damage to P_WC
//
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//
// Revision 1.26  1999/04/29 15:23:02  Fiona
// Ausbau des Setzens von P_USED_HANDS
//
// Revision 1.25  1999/02/11 13:13:15  Gum
// WieldFunc und UnwieldFunc bekommen als zweiten parameter silent uebergeben
//
// Revision 1.24  1998/12/20 16:45:54  Gum
// wenn unsichtbare eine waffe zuecken/zurueckstecken geht keine message mehr an den raum
//
// Revision 1.23  1998/12/19 21:40:42  Gum
// unzerstoerbare waffen koennen jetzt auch gezueckt werden

#pragma strong_types
#define NEED_PROTOTYPES

#include <combat.h>
#include <defines.h>
#include <properties.h>
#include <thing/description.h>
#include <thing/properties.h>
#include <weapon.h>

private string statmod_str(mapping map, int negate);

void create()
{
  SetProp(P_WEAPON_TYPE, WT_CLUB);
  SetProp(P_DAM_TYPE, DT_BLUDGEON);
  SetProp(P_NR_HANDS, 2);
  SetProp(P_LIFETIME, 0);
}

void init()
{
  add_action("wield", "zueck");
  add_action("wield", "zuecke");
  add_action("wield", "zieh");
  add_action("wield", "ziehe");
  add_action("unwield", "steck");
  add_action("unwield", "stecke");
}

int summe(int *array)
{
  int sum, size;

  sum = 0;
  if (!array || !(size = sizeof(array))) return 0;
  while (size--) sum += array[size];
  return sum;
}

varargs int wield(string str, int silent)
{
  object *wielded_weapons, wielded_weapon;
  int used_hands;
  mapping map;

  if (!str) return 0;
  if ((query_verb()||"")[0..3] == "zieh" && sscanf(str, "%s hervor", str) != 1) return 0;

  if (present(str, environment()) != ME)
  {
    notify_fail("Du hast sowas nicht.\n");
    return 0;
  }

  if (environment(ME) != PL)
  {
    notify_fail(break_string(sprintf(
      "Du musst %s schon erst nehmen!", name(WEN, 1)), BS_STDLEN,
      0, BS_LEAVE_MY_LFS));
    return 0;
  }

  if ((QueryProp(P_MAX_LIFETIME) > 0) && !to_int(100 * (float)QueryProp(P_LIFETIME) / (float)QueryProp(P_MAX_LIFETIME) + 0.5))
  {
    tell_object(PL, break_string(sprintf(
      "%s ist doch kaputt!", CAP(name(WER, 1))), BS_STDLEN, 0,
      BS_LEAVE_MY_LFS));
    return 1;
  }

  if (!allow_wield())
  {
    tell_object(PL, break_string(sprintf(
      "Mitglieder Deiner Gilde duerfen %s nicht zuecken!",
      name(WEN, 1)), BS_STDLEN, 0, BS_LEAVE_MY_LFS));
    return 1;
  }

  if (QueryProp(P_WIELDED))
  {
    tell_object(PL, "Das hast Du schon gemacht!\n");
    return 1;
  }

  if (QueryProp(P_WIELD) && !QueryProp(P_WIELD)->WieldFunc(ME, silent)) return 1;

  if (((PL->QueryAttribute(A_DEX)+8)*10) < QueryProp(P_WC))
  {
    tell_object(PL, break_string(sprintf(
      "Du bist nicht geschickt genug, um mit %s umzugehen.",
      name(WEM, 1)), BS_STDLEN, 0, BS_LEAVE_MY_LFS));
    return 1;
  }

  if (QueryProp(P_WC) > MAX_WEAPON_CLASS)
  {
    tell_object(PL, "Ungueltige Waffenklasse, bitte Erzmagier verstaendigen!\n");
    return 1;
  }

  if (!(wielded_weapons = PL->QueryProp(P_WEAPONS))) wielded_weapons = ({});

  if (sizeof(wielded_weapons) && (wielded_weapon = wielded_weapons[0]))
  {
    if (wielded_weapon->DoUnwield(silent) != ME_CANT_BE_UNWIELDED)
      return wield(str, silent);
    else
    {
      tell_object(PL, break_string(sprintf(
        "Das geht nicht, solange Du noch %s gezueckt hast!",
        wielded_weapon->name(WEN, 1)), BS_STDLEN, 0, BS_LEAVE_MY_LFS));
      return 1;
    }
  }

  used_hands = PL->QueryProp(P_USED_HANDS) + QueryProp(P_NR_HANDS);

  if (used_hands > PL->QueryProp(P_MAX_HANDS))
  {
    tell_object(PL, "Du hast keine Hand mehr frei.\n");
    return 1;
  }

  wielded_weapons += ({ ME });

  SetProp(P_WIELDED, PL);

  PL->SetProp(P_WEAPONS, wielded_weapons);
  PL->SetProp(P_TOTAL_WC, summe(map_objects(wielded_weapons, "QueryProp", P_WC)));
  PL->SetActiveSkill();

  if (map = QueryProp(P_STATMOD))
  {
    if (str = statmod_str(map, 0))
      str = sprintf(" und fuehlst Dich ploetzlich %s", str);
    else str = "";
    PL->AddStatMod(ME);
  }
  else str="";

  if (!silent && environment(PL))
  {
    tell_object(PL, break_string(sprintf(
      "Du zueckst %s%s.", name(WEN, 1), str), BS_STDLEN, 0,
      BS_LEAVE_MY_LFS));
    if (!PL->QueryProp(P_INVIS)) tell_room(environment(PL), break_string(sprintf(
      "%s zueckt %s.", CAP(PL->name(WER)), name(WEN)), BS_STDLEN,
      0, BS_LEAVE_MY_LFS), ({PL}));
  }

  return 1;
}

int unwield(string str)
{
  string dummy;

  if (!str) return 0;
  if (sscanf(str, "%s weg", dummy) != 1 &&
      sscanf(str, "%s ein", dummy) != 1 &&
      sscanf(str, "%s zurueck", dummy) != 1) return 0;

  str = dummy;

  if (!str || !id(str) || !PL->QueryProp(P_WEAPONS) || (member_array(ME, PL->QueryProp(P_WEAPONS)) == -1))
    return 0;

  if (environment(ME) != PL)
  {
    notify_fail("Diese Waffe gehoert Dir nicht!\n");
    return 0;
  }

  if (!QueryProp(P_WIELDED))
  {
    notify_fail("Diese Waffe hast Du gar nicht gezueckt...\n");
    return 0;
  }

  return DoUnwield();
}

varargs int DoUnwield(int silent)
{
  int used_hands;
  mixed hands;
  object wielded_by, *weapons;
  string msg;
  mapping map;

  if (!(wielded_by = QueryProp(P_WIELDED))) return ME_CANT_BE_UNWIELDED;
  if (QueryProp(P_UNWIELD) && !QueryProp(P_UNWIELD)->UnwieldFunc(this_object(), silent))
    return 1;

  if (msg = QueryProp(P_CURSED))
  {
    if (!silent)
    {
      if (stringp(msg))
        tell_object(wielded_by, msg);
      else
        tell_object(wielded_by, break_string(sprintf(
          "Du kannst %s nicht mehr wegstecken.", name(WEN, 1)),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS));
    }
    return ME_CANT_BE_UNWIELDED;
  }

  weapons = wielded_by->QueryProp(P_WEAPONS);
  weapons -= ({ ME, 0 });
  wielded_by->SetProp(P_WEAPONS, weapons);
  SetProp(P_WIELDED, 0);

  if (!sizeof(weapons))
  {
    hands = wielded_by->QueryProp(P_HANDS);
    wielded_by->SetProp(P_TOTAL_WC, hands[1]); /* bare hands */
  }
  else
    wielded_by->SetProp(P_TOTAL_WC, summe(map_objects(weapons, "QueryProp", P_WC)));

  if (map = QueryProp(P_STATMOD))
  {
    if (msg = statmod_str(map, 1))
      msg = sprintf(" und fuehlst Dich wieder %s", msg);
    else msg = "";
    PL->RemoveStatMod(ME);
  }
  else msg = "";

  wielded_by->SetActiveSkill();

  if (!silent)
  {
    tell_object(wielded_by, break_string(sprintf(
      "Du steckst %s zurueck%s.", name(WEN, 1), msg), BS_STDLEN,
      0, BS_LEAVE_MY_LFS));
    if (!wielded_by->QueryProp(P_INVIS)) tell_room(environment(wielded_by), break_string(sprintf(
      "%s steckt %s zurueck.", CAP(wielded_by->name(WER)),
      name(WEN)), BS_STDLEN, 0, BS_LEAVE_MY_LFS), ({wielded_by}));
  }

  return 1;
}

int QueryDamage(object enemy)
{
  object wielded_by;
  int dam;

  if (!(wielded_by = QueryProp(P_WIELDED))) 
    return 0;

  dam = QueryProp(P_WC);

  if (QueryProp(P_WEAPON_HIT))
    dam += QueryProp(P_WEAPON_HIT)->HitFunc(enemy);

  return dam;
}

int QueryWeaponDefend(int dam, string* dam_type, int spell, object enemy)
{
  if (!QueryProp(P_WIELDED)) return 0;
  if (QueryProp(P_WEAPON_DEFEND))
    return QueryProp(P_WEAPON_DEFEND)->WeaponDefendFunc(dam, dam_type, spell, enemy);
  return 0;
}

void DoStructureDamage(int dam)
{
  int lt, old_wc, new_wc;

  // ist MAX_LIFETIME == -1 dann ist die waffe unzerstoerbar
  if (Query(P_MAX_LIFETIME) == -1) return;
  if ((lt = QueryProp(P_LIFETIME)) < 1) return;
  if ((lt -= dam) < 1)
  {
    SetProp(P_LIFETIME, 0);
    tell_object(QueryProp(P_WIELDED), break_string(sprintf(
      "%s ist gerade kaputt gegangen.", CAP(name(WER, 1))),
      BS_STDLEN, 0, BS_LEAVE_MY_LFS));
    DoUnwield();
    return;
  }

  old_wc = QueryProp(P_WC);
  SetProp(P_LIFETIME, lt);
  new_wc = QueryProp(P_WC);

  // ist die neue wc kleiner als die alte muss total_wc neu berechnet werden
  if (old_wc != new_wc)
  {
    object obj;
    if (objectp(obj = QueryProp(P_WIELDED)) && obj)
    {
      object *weapons;

      weapons = obj->QueryProp(P_WEAPONS);
      obj->SetProp(P_TOTAL_WC, summe(map_objects(weapons, "QueryProp", P_WC)));
    }
  }
}

int _query_wc()
{
  int wc;

  if (!(wc = Query(P_WC))) return wc;
  switch (Query(P_MAX_LIFETIME))
  {
    case -1: return wc;
    case  0: initialize();
  }

  return to_int((float)wc * (float)QueryProp(P_LIFETIME) / (float)Query(P_MAX_LIFETIME) + 0.5);
}

int _set_nr_hands(int arg)
{
  if (arg < 1) return Query(P_NR_HANDS);
  Set(P_NR_HANDS, arg);
}

mixed _set_dam_type(mixed arg)
{
  if (pointerp(arg)) return Set(P_DAM_TYPE, arg);
  else return Set(P_DAM_TYPE, ({arg}));
}

int allow_wield()
{
  mixed guild_info, weapons, ids;
  int n, m;

  guild_info = call_other("/secure/guildmaster", "QueryGuild", PL->QueryProp(P_GUILD), 1);
  if (!sizeof(guild_info)) return 1;

  weapons = call_other(guild_info[0], "QueryProp", P_WEAPONS_ALLOWED);
  if (!sizeof(weapons)) return 1;

  n = sizeof(ids = QueryProp(P_IDS));
  for (m = 0; m < n; m++)
    if (member_array(ids[m], weapons) != -1) return 1;

  return 0;
}

mapping QueryStatMod(object pl)
{
  if (pl == QueryProp(P_WIELDED)) return QueryProp(P_STATMOD);
}

private string statmod_str(mapping map, int negate)
{
  int i;
  string *idx;
  mixed mix;

  negate = 1 - 2*negate;
  mix = ({});
  idx = m_indices(map);

  for (i = sizeof(idx); i--;)
  {
    if (map[idx[i]] == 0) continue;
    switch (idx[i])
	{
      case A_INT:
        if (map[idx[i]]*negate>0) mix += ({"intelligenter"});
        else mix += ({"weniger intelligent"});
        break;
      case A_CON:
        if (map[idx[i]]*negate>0) mix += ({"ausdauernder"});
        else mix += ({"weniger ausdauernd"});
        break;
      case A_STR:
        if (map[idx[i]]*negate>0) mix += ({"staerker"});
        else mix += ({"weniger stark"});
        break;
      case A_DEX:
        if (map[idx[i]]*negate>0) mix += ({"geschickter"});
        else mix += ({"weniger geschickt"});
        break;
    }
  }

  if (sizeof(mix)) mix = "/std/player/soul"->CountUp(mix);
  else mix = 0;

  return mix;
}
