/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2001/01/31 13:42:20 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: description.c,v $
** Revision 1.2  2001/01/31 13:42:20  elatar
** process_string() replaced by funcall()
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// MD Mudlib
//
// basierend auf der Wunderland Mudlib
//
// /STD/WEAPON/DESCRIPTION.C --- standard-description of weapons
//
// $Log: description.c,v $
// Revision 1.2  2001/01/31 13:42:20  elatar
// process_string() replaced by funcall()
//
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/12 10:52:09  Largo
// Initial revision
//

inherit "/std/thing/description";

#pragma strong_types

#define NEED_PROTOTYPES

#include "/sys/thing/properties.h"
#include <properties.h>

void create()
{
  ::create();
  AddId("waffe");
}

static string _query_descr()
{
//  int max_lifetime, lifetime, pct;
//  string desc;

//  max_lifetime = QueryProp(P_MAX_LIFETIME);
//  lifetime = QueryProp(P_LIFETIME);
//  if (max_lifetime) pct = lifetime * 100 / max_lifetime;
/*
  switch (pct)
  {
    case 95..100: desc = "(ausgezeichnet)"; break;
    case 90..94:  desc = "(sehr gut)"; break;
    case 60..89:  desc = "(gut)"; break;
    case 30..59:  desc = "(oft benutzt)"; break;
    case 10..29:  desc = "(abgenutzt)"; break;
    case  1..9:   desc = "(runtergewirtschaftet)"; break;
    case  0:      desc = "(unbrauchbar)"; break;
    default:      desc = "(Zustand ungueltig, bitte MAG rufen!)";
  }
  return desc + (QueryProp(P_WIELDED) ? " (gezueckt)" : "");
*/
  string str, str2;
  str=funcall(Query(P_DESCR));
  if (QueryProp(P_WIELDED)) str2="(gezueckt)";
  if (str) {
    if (str2) return str+" "+str2;
    else return str;
  }
  return str2;
}

string long()
{
  string desc, str;
  int lifetime, max_lifetime, pct;

  if (Query(P_MAX_LIFETIME) == -1) pct = 100;
  else
  {
    max_lifetime = QueryProp(P_MAX_LIFETIME);
    lifetime = QueryProp(P_LIFETIME);
    if (max_lifetime) pct = lifetime * 100 / max_lifetime;
  }

  switch(pct)
  {
    case 95..100: desc = "exzellenten"; break;
    case 90..94:  desc = "sehr guten"; break;
    case 60..89:  desc = "guten"; break;
    case 30..59:  desc = "schlechten"; break;
    case 10..29:  desc = "sehr schlechten"; break;
    case  1..9:   desc = "miserablen"; break;
    case  0:      desc = "unbrauchbaren"; break;
    default:      desc = "(P_LIFETIME ungueltig, bitte MAG rufen!)";
  }

  str = funcall(QueryProp(P_LONG));
  if (!stringp(str)) str = "";
  else if (str[<1] != '\n') str += "\n";
  return str + capitalize(name(WER, 1)) + " ist in einem " + desc + " Zustand.";
}
