/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: books.h,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
/* Wunderland Mudlib
 *
 * SYS/BOOKS.H -- Buecher-Headerfile
 *
 * $Log: books.h,v $
 * Revision 1.1.1.1  1999/11/05 12:30:47  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:14  en
 * MUDLib CVS Preperation
 *
 * Revision 1.1  1999/07/02 11:54:09  Fiona
 * Initial revision
 *
 */

#ifndef __BOOKS_H__
#define __BOOKS_H__

// book_symbols:
#define HOTCHAR     "\\"

#define S_BACKSLASH       "#@@BACK@@#"
#define S_HYPHEN          "#@@HYPH@@#"
#define S_SPEC_HYPHEN     "#@@SPHY@@#"
#define S_PROTECTED_SPACE "#@@SPAC@@#"
#define S_VERTICAL_BAR    "#@@VBAR@@#"
#define S_GREATER_THAN    "#@@GREA@@#"
#define S_LESS_THAN       "#@@LESS@@#"
#define S_CIRCUMFLEX      "#@@CIRC@@#"
#define S_PERCENT         "#@@PERC@@#"

#define BS_REPLACE ({({HOTCHAR+HOTCHAR,S_BACKSLASH}),\
		     ({HOTCHAR+"-",S_HYPHEN}),\
		     ({HOTCHAR+"~",S_SPEC_HYPHEN}),\
		     ({HOTCHAR+" ",S_PROTECTED_SPACE}),\
		     ({HOTCHAR+"|",S_VERTICAL_BAR}),\
		     ({HOTCHAR+">",S_GREATER_THAN}),\
		     ({HOTCHAR+"<",S_LESS_THAN}),\
		     ({HOTCHAR+"^",S_CIRCUMFLEX}),\
		     ({HOTCHAR+"%",S_PERCENT})})

#define BS_RESTORE ({({S_BACKSLASH,HOTCHAR}),\
		     ({S_HYPHEN,"-"}),\
		     ({S_SPEC_HYPHEN,"~"}),\
		     ({S_PROTECTED_SPACE," "}),\
		     ({S_VERTICAL_BAR,"|"}),\
		     ({S_GREATER_THAN,">"}),\
		     ({S_LESS_THAN,"<"}),\
		     ({S_CIRCUMFLEX,"^"}),\
		     ({S_PERCENT,"%"})})

// Falls neue Symbole hinzugefuegt werden: Bitte den HOTCHAR und das Space
// NICHT in das SYMBOLS-Array schreiben!
#define SYMBOLS ({"-","~","|","<",">","^","%"})

#define IS_SYMBOL(x) (member_array((x),SYMBOLS)>-1)

#define SYMBOLFILTER lambda(({'el}),\
			    ({#'<,({#'member_array,'el,quote(SYMBOLS)}),0}))

// Ende book_symbols

// Filename for textfile to be displayed as a book.
#define P_BOOK_CONTENTS "book_contents"

/* Property for height of pages. If zero, the book
 * will assume P_SCREENSIZE for textheight.
 */
#define P_BOOK_PAGE_HEIGHT "book_page_height"

/* Property for textwidth. Note, that this property
 * contains only the width of ONE page in characters.
 * There will be two pages displayed simultaneously.
 * For margins, etc. another 12 characters will be
 * needed. DEFAULT set by std/book.c is 30.
 */
#define P_BOOK_PAGE_WIDTH "book_page_width"

// Two properties just for the looks :)
// the first one is the frame char (normally a hash mark #)
#define P_BOOK_FRAME_CHAR "book_frame_char"
// the second one is the fill_char (normally a space)
#define P_BOOK_FILL_CHAR "book_fill_char"
// defines the flush-right character, normally a space.
#define P_BOOK_FLUSH_CHAR "book_flush_char"
// default 1. If ==0, blank lines will be skipped at the top of a page
#define P_BOOK_BLANK_HEADERS "book_blank_headers"

// and some internal properties...
#define P_BOOK_TEXT "book_text"
#define P_BOOK_SATZ "book_satz"
#define P_BOOK_PAGE "book_page"
#define P_BOOK_OPEN "book_open"
#define P_BOOK_READ "book_read"

#endif
