/*******************
** Eldarea MUDLib **
********************
**
** sys/clock.h - mud clock
**
** CVS DATA
** $Date: 2001/02/08 16:09:14 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: clock.h,v $
** Revision 1.3  2001/02/08 16:09:14  elatar
** timezones and handling completely rewritten, ET_CHANGE_DAYTIME event implemented
**
** Revision 1.2  2001/02/01 09:26:47  elatar
** clock moved
**
** Revision 1.1  2001/01/17 15:02:08  elatar
** renamed uhr.h to clock.h
**
** Revision 1.1.1.1  1999/11/05 12:30:48  elatar
** Preparing mudlib for cvs control
**
**
*/

#ifndef _CLOCK_H_
#define _CLOCK_H_

// Definition fuer Zugriff auf Uhr-Objekt
#define UHR       "/global/service/clock"
#define CLOCK     "/global/service/clock"


// Definitionen fuer die Flags einer Zeitzone
#define INACTIVE       1       // Zone inaktiv

// Definitionen fuer Zugriff auf zones-Mapping und Zustand einer Zone
#define NEXT           0       // Naechster Wechsel
#define DUSK           1       // Laenge der Morgen-Periode
#define DAY            2       // Laenge der Tag-Periode
#define MORN           2       // Tag (Tagesanbruch)
#define DAWN           3       // Laenge der Abend-Periode
#define NIGHT          4       // Laenge der Nacht-Periode
#define EVEN           4       // Nacht (Nachtanbruch)
#define OFFSET         5       // Offset relativ zu 0 Uhr
#define STATE          6       // Aktuelle Tageszeit
#define FLAGS          7       // Flags der Zeitzone
#define DESC           8       // Beschreibung

// Definitionen um die Typen etwas klarer hinzubekommen
#define time_t         int     // Type fuer time()-Werte
#define zone_t         int     // Type fuer Zonennummern
#define min_t          int     // Type fuer (relative) Minutenzahl

// Definition der Zeitzonen.
#define TZ_STANDARD    0       // Standardzone fuer Objekte ohne Zone

// Definitionen der Zeitzonen selbst. 
// Format ist:
// ([zone_t zone: time_t next_change;
//                min_t daylenght;
//                min_t dawnlength;
//                min_t nightlength;
//                min_t dusklength;
//                min_t offset;
//                int state;
//                int flags;
//                string desc ])
#define ZONEDEFS ([ \
  TZ_STANDARD:       0;   3; 300;   3; 300;   0;   MORN; 0; "Standard"\
    ])

// Tageszeitwechsel-Event
#define ET_CHANGE_DAYTIME   "et_change_daytime"

// Tageszeitwechsel-Event-Defines
#define E_DAYTIME           "e_daytime"
#define E_TIMEZONE          "e_timezone"

#ifdef NEED_PROTOTYPES

public int get_day_ticks(time_t ticks);
public time_t get_0_oclock(time_t ticks);
varargs public string GetLighting(mixed mix);
varargs public int IsNight(mixed mix);
varargs public int QueryState(mixed mix);
varargs public time_t QueryDay(mixed mix);
varargs public time_t QueryNight(mixed mix);
varargs public time_t QueryChange(mixed mix);

#endif // NEED_PROTOTYPES

#endif // _CLOCK_H_
