/*******************
** Eldarea MUDLib **
********************
**
** sys/combat.h - combat header
**
** CVS DATA
** $Date: 2001/02/01 09:27:18 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: combat.h,v $
** Revision 1.3  2001/02/01 09:27:18  elatar
** event defines implemented
**
** Revision 1.2  2000/12/04 11:34:55  elatar
** many changes due to new combat system
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#ifndef __COMBAT_H__
#define __COMBAT_H__

#define P_NR_HANDS              "nr_hands"

// event defines

#define ET_HIT      "et_hit"
#define ET_DAMAGE   "et_damage"
#define ET_ATTACK   "et_attack"
#define ET_DEFEND   "et_defend"

//
// Definition der moeglichen Waffentypen.
//

#define WT_KNIFE    "wt_knife"   //Messer und Dolche
#define WT_SWORD    "wt_sword"   //Schwerter
#define WT_AXE      "wt_axe"     //Aexte
#define WT_CLUB     "wt_club"    //stumpfe Hiebwaffen
#define WT_FENCING  "wt_fencing" //scharfe Hiebwaffen
#define WT_SPEAR    "wt_spear"   //Speere/Stangenwaffen ohne Klinge
#define WT_FLAIL    "wt_flail"   //Flegel/mehrteilige Waffen
#define WT_POLE     "wt_pole"    //Stangenwaffen mit Klinge
#define WT_THROW    "wt_throw"   //Wurfwaffen
#define WT_SHOOT    "wt_shoot"   //Schusswaffen

#define WT_AMMU     "wt_ammunition" //Munition als Waffentyp???
#define WT_HANDS    "wt_hands"      //blosse Haende
#define WT_MAGIC    "wt_magic"      //Besser als eigene Property

#define WT_FIST     "wt_fist"

#define WEAPON_ATTACK_TYPES ({WT_KNIFE,\
                              WT_SWORD,\
                              WT_AXE,\
                              WT_CLUB,\
                              WT_FENCING,\
                              WT_SPEAR,\
                              WT_FLAIL,\
                              WT_POLE,\
                              WT_AMMU,\
                              WT_THROW,\
                              WT_SHOOT})

#define VALID_WEAPON_TYPE(t) (member_array(t, \
         WEAPON_ATTACK_TYPES ) != -1)

#define MAX_WEAPON_CLASS 200

//
// Definition der moeglichen Schadenstypen, unterteilt in
// physischen und magischen Schaden.
//

#define DT_SLASH     "slash"
#define DT_BLUDGEON  "bludgeon"
#define DT_PIERCE    "pierce"
#define DT_TEAR      "tear"

#define DT_MAGIC     "magic"

#define DT_FIRE      "fire"
#define DT_WATER     "water"
#define DT_EARTH     "earth"
#define DT_AIR       "air"
#define DT_ICE       "ice"

#define DT_HOLY      "holy"
#define DT_UNHOLY    "unholy"

#define DT_ACID      "acid"
#define DT_ELECTRIC  "electric"
#define DT_LIGHT     "light"
#define DT_DARK      "dark"

// ???
#define DT_SOUND     "sound"

#define VALID_MAGIC_TYPE(t) ( member_array(t,\
          MAGICAL_DAMAGE_TYPES ) != -1 )

#define MAGICAL_DAMAGE_TYPES ({DT_MAGIC, DT_FIRE, DT_WATER, DT_EARTH, \
                               DT_AIR, DT_ICE, DT_HOLY, DT_UNHOLY, \
                               DT_ACID, DT_ELECTRIC, DT_LIGHT, DT_DARK})
                               
#define PHYSICAL_DAMAGE_TYPES ({DT_SLASH, DT_BLUDGEON, DT_PIERCE, DT_TEAR})

//
// Definition der moeglichen Ruestungstypen.
//

#define AT_ARMOUR   "Ruestung"
#define AT_HELMET   "Helm"
#define AT_AMULET   "Amulett"
#define AT_RING     "Ring"
#define AT_GLOVE    "Handschuhe"
#define AT_CLOAK    "Umhang"
#define AT_BOOT     "Schuhe"
#define AT_SHIELD   "Schild"
#define AT_TROUSERS "Hose"
#define AT_GLASSES  "Brille"
#define AT_MISC     "Misc"
#define AT_ILLEGAL  "ILLEGAL"

// Ruestungstypen, die als 'Kleidung' und nicht als 'Tools' bei
// der Langbeschreibung von Livings angesehen werden sollen
#define AT_IS_CLOTHING ({ AT_ARMOUR, AT_CLOAK, AT_TROUSERS })

#define VALID_ARMOUR_TYPE(t) (member_array(t, \
          ({AT_ARMOUR, AT_HELMET, AT_RING, AT_GLOVE, AT_CLOAK, AT_BOOT,\
          AT_TROUSERS, AT_SHIELD, AT_AMULET, AT_GLASSES, AT_MISC}) ) != -1)

#define VALID_ARMOUR_CLASS ([ AT_ARMOUR   : 40,\
                              AT_HELMET   : 10,\
                              AT_RING     :  3,\
                              AT_GLOVE    : 10,\
                              AT_CLOAK    : 10,\
                              AT_BOOT     : 10,\
                              AT_TROUSERS : 10,\
                              AT_SHIELD   : 30,\
                              AT_AMULET   :  5,\
                              AT_GLASSES  :  2,\
                              AT_MISC     :  0 ])

// Kleidungszonen

#define VALID_CWL ([CWL_HEAD:"Kopf",\
                    CWL_BODY:"Koerper",\
                    CWL_RIGHT_ARM:"Rechter Arm",\
                    CWL_LEFT_ARM:"Linker Arm",\
                    CWL_RIGHT_HAND:"Rechte Hand",\
                    CWL_LEFT_HAND:"Linke Hand",\
                    CWL_RIGHT_LEG:"Rechtes Bein",\
                    CWL_LEFT_LEG:"Linkes Bein",\
                    CWL_RIGHT_FOOT:"Rechter Fuss",\
                    CWL_LEFT_FOOT:"Linker Fuss"\
                    ])

#define CWL_HEAD         "head"
#define CWL_BODY         "body"
#define CWL_RIGHT_ARM    "right_arm"
#define CWL_RIGHT_HAND   "right_hand"
#define CWL_LEFT_ARM     "left_arm"
#define CWL_LEFT_HAND    "left_hand"
#define CWL_RIGHT_LEG    "right_leg"
#define CWL_RIGHT_FOOT   "right_foot"
#define CWL_LEFT_LEG     "left_leg"
#define CWL_LEFT_FOOT    "left_foot"
#define CWL_RINGS        "rings"
#define CWL_MISC         "misc"       


#endif // __COMBAT_H__
