/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2000/12/04 11:39:09 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: config.h,v $
** Revision 1.2  2000/12/04 11:39:09  elatar
** mud name changed
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
#ifndef _CONFIG_
#define _CONFIG_

/*
 * config.h
 *
 * general configuration is done here, the selection of gamedriver mode
 * and the language to use.
 */

#include <homes.h>

#define MUDNAME "Eldarea"

#ifdef COMPAT_FLAG
#define COMPAT
#else
#define NATIVE
#endif

#define DEUTSCH
/* define general pathnames */
#ifdef NATIVE
#define MASTER "secure/master"
#endif
#define MAILPATH "mail/"
#define SAVEPATH "save/"
#define NEWSPATH "news/"
#define NEWSSERVER "secure/news"
#define SECURESAVEPATH "secure/save/"
#define COMBAT_MASTER "secure/combat"
#define UTIL "secure/util"
#define WIZARDDIR "players"
#define DOMAINDIR "d"
#define PROJECTDIR "p"

#define NETDEAD_ROOM NETDEADROOM
#define NETDEAD_CHECK_TIME 100 /* Check all 5 Minutes */

/* define special userids */ 
#define BACKBONEID " S T D "
#define ROOTID " R O O T "			/* uppercase !! */
#define MAILID " M A I L "
#define NEWSID " N E W S "

#define MAX_LOG_SIZE 50000


#define PERCENT_BASE	10000	/* accuracy of percents */

#define TIME_TO_UPDATE	10	/* time to update resources */

#define SPELL_COST			1

#define AUTO_BATTLE		/* automatic reattack */

/* 
 * volumes
 */

#define VOL_WHISPER 30
#define VOL_NORMAL  100
#define VOL_LOUD    500
#define VOL_CRY     1000

#define VOL_MIN_WHISPER	10
#define VOL_MIN_NORMAL  90


/*
 * vision
 */

#define VIS_MIN_NORMAL  300 /* normal sight */
#define VIS_MIN_SHADOW  100  /* you can see only shadows */
#define VIS_MIN_TRANS   P50 /* minimun transparency to spot something */

#endif
