/*******************
** Eldarea MUDLib **
********************
**
** sys/corpse.h - corpse header
**
** CVS DATA
** $Date: 2000/12/15 15:32:08 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: corpse.h,v $
** Revision 1.2  2000/12/15 15:32:08  elatar
** P_VICTIM_DIE_FLAGS inserted
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#ifndef __CORPSE_H__
#define __CORPSE_H__

// properties

#define P_KILLER            "killer"
#define P_CORPSE_DECAY      "corpse_decay"
#define P_CORPSE_DECAY_TIME "corpse_decay_time"
#define P_VICTIM            "victim"

#define P_VICTIM_TYPE       "victim_type"
#define P_VICTIM_NAME       "victim_name"
#define P_VICTIM_PLURAL     "victim_plural"
#define P_VICTIM_ARTICLE    "victim_article"
#define P_VICTIM_GENDER     "victim_gender"
#define P_VICTIM_LEVEL      "victim_level"
#define P_VICTIM_REAL_STATS "victim_real_stats"
#define P_VICTIM_MAX_HP     "victim_max_hp"
#define P_VICTIM_XP         "victim_xp"
#define P_VICTIM_HANDS      "victim_hands"
#define P_VICTIM_MAX_HANDS  "victim_max_hands"
#define P_VICTIM_BODY       "victim_body"
#define P_VICTIM_RACE       "victim_race"
#define P_VICTIM_ALIGN      "victim_align"
#define P_VICTIM_WEIGHT     "victim_weight"
#define P_VICTIM_WEAPONS    "victim_weapons"
#define P_VICTIM_ARMOURS    "victim_armours"
#define P_VICTIM_HEAL       "victim_heal"
#define P_VICTIM_AGGRESSIVE "victim_aggressive"
#define P_VICTIM_DIE_FLAGS  "victim_die_flags"

#endif // __CORPSE_H__

#ifdef NEED_PROTOTYPES

#ifndef __CORPSE_H_PROTO__
#define __CORPSE_H_PROTO__

// prototypes

void create();
void init();
void Start();
int query_prevent_shadow(object ob);
void do_decay();
int mampf();

#endif // __CORPSE_H_PROTO__

#endif	// NEED_PROTOYPES
