/*******************
** Eldarea MUDLib **
********************
**
** sys/cron.h
**
** CVS DATA
** $Date: 2000/12/04 15:05:57 $
** $Revision: 1.1 $
**
** mud cron daemon header
**
** CVS History
**
** $Log: cron.h,v $
** Revision 1.1  2000/12/04 15:05:57  elatar
** initial release
**
**
**
*/

#ifndef _CRON_H_
#define _CRON_H_

#define CRON "/global/daemon/cron"
#define CRONTABS "/global/daemon/crontabs"

#endif // _CRON_H_

#ifdef NEED_CRON_PROTOTYPES
#undef NEED_CRON_PROTOTYPES

// prototypes
nomask static void ReadCrontabs();
nomask static void CheckCrontabs();
nomask static void UpdateCrontab(string uid);
nomask static void RemoveJobs(string uid);
nomask static void AddJob(string tabline, string uid);
nomask mixed EvalValue(string val, int min, int max);
nomask static void TryAddJobToList(mixed * job, string uid);
nomask static int * GetDayData();
nomask static int CheckRange(int val, mixed * range);
nomask static void StartNextCallout();
nomask static void DoJobs();
nomask static void TryDoJob(mixed * job);
nomask static string ListCrontab(string uid);
nomask static void PostEditCrontab(string ntab, string * args);
nomask static void UpdateCrontabs();

nomask static void CLog(string line);
nomask static varargs void CError(string err, int silent);

nomask public int cmd_crontab(string * args);

// internal defines

#define MAINTAINER "elatar"
#define DISCARD_MINUTES   1
#define JOBS_PER_CYCLE   10
#define SYSTEM_JOB ({({0}),({24}),({({0,31})}),({({0,11})}),({({0,6})}),\
                   CRON,"UpdateCrontabs",ROOTID})

#define CJ_UID        0
#define CJ_OBJ        1
#define CJ_FUN        2

#define CT_FILEDATE   0
#define CT_CRONJOBS   1

#define CTI_MINUTES   0
#define CTI_HOURS     1
#define CTI_DAYS      2
#define CTI_MONTHS    3
#define CTI_WEEKDAYS  4
#define CTI_OBJECT    5
#define CTI_FUNCTION  6
#define CTI_SECONDS   5

#define month_to_int(x) (["Jan":0,\
                          "Feb":1,\
                          "Mae":2,\
                          "Apr":3,\
                          "Mai":4,\
                          "Jun":5,\
                          "Jul":6,\
                          "Aug":7,\
                          "Sep":8,\
                          "Okt":9,\
                          "Nov":10,\
                          "Dez":11])[x]
#define wday_to_int(x) (["Mon":0,\
                         "Die":1,\
                         "Mit":2,\
                         "Don":3,\
                         "Fre":4,\
                         "Sam":5,\
                         "Son":6])[x]

#endif // NEED_CRON_PROTOTYPES
