/*******************
** Eldarea MUDLib **
********************
**
** sys/daemon/channel.h - channel daemon header
**
** CVS DATA
** $Date: 2001/06/18 18:17:59 $
** $Revision: 1.4 $
**
** CVS History
**
** $Log: channel.h,v $
** Revision 1.4  2001/06/18 18:17:59  elatar
** #endif corrected
**
** Revision 1.3  2000/12/04 14:50:27  elatar
** properties moved to player includes
** new define for channeld.init
**
** Revision 1.2  1999/11/19 10:38:46  elatar
** adapted due to new channeld
**
**
*/

#ifndef __DAEMON_CHANNEL_H__
#define __DAEMON_CHANNEL_H__

#define VOICEMASTER             "/global/daemon/channeld"
#define CHANNELDINIT            "/etc/channeld.init"

// Message types
#define MSG_SAY                 0
#define MSG_EMOTE               1
#define MSG_GEMOTE              2
#define MSG_EMPTY               3

// Errors
#define E_ACCESS_DENIED         -1
#define E_ALREADY_JOINED        -2
#define E_NOT_MEMBER            -3
#define E_EMPTY_MESSAGE         -4
#define E_UNKNOWN_TYPE          -5
#define E_UNKNOWN_USER          -6

// Commands
#define C_NEW                   "new"
#define C_JOIN                  "join"
#define C_LEAVE                 "leave"
#define C_SEND                  "send"
#define C_LIST                  "list"
#define C_FIND                  "find"

// definition of the list mapping entry
// ([ channelname : ({ I_MEMBER, I_ACCESS, I_INFO, I_MASTER, I_NAME, I_TIMEOUT, I_INVITED }) ])
#define I_MEMBER                0
#define I_ACCESS                1
#define I_INFO                  2
#define I_MASTER                3
#define I_NAME                  4
#define I_TIMEOUT               5
#define I_INVITED               6

#endif // __DAEMON_CHANNEL_H__

// prototypes
#ifdef NEED_PROTOTYPES

#ifndef __CHANNEL_H_PROTO__
#define __CHANNEL_H_PROTO__

varargs int new(string ch, mixed pl, mixed info);
int join(string ch, mixed pl);
int leave(string ch, mixed pl);
varargs int send(string ch, mixed pl, string msg, int type);
mixed list(mixed pl);
varargs int send(string ch, object pl, string msg, int type);

#endif // __CHANNEL_H_PROTO__

#endif  // NEED_PROTOTYPES
