/*******************
** Eldarea MUDLib **
********************
**
** sys/daemon/intermud3.h - intermud3 daemon header
**
** CVS DATA
** $Date: 2001/02/06 08:58:24 $
** $Revision: 1.2 $
**
** Intermud3 developed by Skylight and friends 
**
** CVS History
**
** $Log: intermud3.h,v $
** Revision 1.2  2001/02/06 08:58:24  elatar
** applied strong_types requirements
**
** Revision 1.1.1.1  1999/11/05 12:30:48  elatar
** Preparing mudlib for cvs control
**
**
*/

#include <config.h> // MUDNAME MUDLIB MUDLIB_VERSION ADMIN_EMAIL

#ifndef __INTERMUD_3__
#define __INTERMUD_3__

#define INTERMUD3     "/global/daemon/intermud3"
#define IMUD3_BASE    "/global/daemon/"
#define IMUD3_TOOLS   "/global/daemon/intermud3/"
#define SAVE_INTERMUD "/global/daemon/intermud3"
#define MUDMODE_FILE  "/tmp/mudmode"

#define MUD_DRIVER "LPMud"
#define MUD_STATUS "Development"

#define PORT_OOB (query_imp_port() + 1) // probably 4247
#define PORT_UDP query_imp_port()

#define MAX_SEND 247 // nicht MAX_SEND_ERQ wegen nslookup

#define MAX_CONNECTIONS 10

// intermud3.c
void read_callback(mixed *data, int size);
void write_callback(mixed *data, int size);
void listen_callback(mixed *data, int size);
void oob_read_callback(mixed fd, mixed *data, int size);
void oob_write_callback(mixed fd, mixed *data, int size);
void flush();
void handle_data(mixed *lpc_data);
static void receive_auth_mud_reply(mixed *data);
static void receive_auth_mud_request(mixed *data);
static void receive_error(mixed *data);
void send_tcp(mixed arg);
void oob_flush(mixed fd);
void handle_oob_data(mixed fd, mixed *lpc_data);
static void set_me_up();
void connect();
void listen();
mapping get_services();

//auth.c
static void receive_auth_mud_request(mixed *data);                  

//channel.c
void local_channel_name(string arg);
void global_channel_name(string arg);
string receive_channel_message(mixed *data);
void send_channel_message(string name, string chan, string msg);
void write_emote(string name, string chan, string msg);
void receive_channel_emote(mixed *data);
void send_channel_emote(string name, string chan, string msg);
void receive_channel_target_emote(mixed *data);
void receive_channel_who_reply(mixed *data);
void receive_channel_who_request(mixed *data);
void send_channel_who_request(string chan, mixed where);
static void receive_channel_user_request(mixed *data);
void receive_channel_user_reply(mixed *data);
void receive_ucache_update(mixed *data);
void send_ucache_update(object ob);

//emoteto.c
void receive_emoteto(mixed *data);
void send_emoteto(string who, mixed where, string msg);

//error.c
void receive_error(mixed *data);

//file.c
static void receive_file_list_request(mixed *data);
static void receive_file_list_reply(mixed *data);
void send_file_list_request(mixed where, string arg);
static void receive_file_put_request(mixed *data);
static void receive_file_put_acknowledge(mixed *data, string mud);
void send_file_put_request(mixed where, string remote_fname, mixed contents, string local_fname);
static void receive_file_get_request(mixed *data);
static void receive_file_get_reply(mixed *data, string mud);
void send_file_get_request(mixed where, string remote_fname, string local_fname);

//finger.c
private mixed finger(string str);
void receive_finger_request(mixed data);
void receive_finger_reply(mixed data);
void send_finger_request(string who, string where);

//finger_d.c
mixed * finger(string str);

//locate.c
static void receive_locate_request(mixed *data);
static void receive_locate_reply(mixed *data);
void send_locate_request(string who);

//mail.c
void send_mail(string * bcc_list, string where, string * to, string * cc,
               string subject, string contents);
void receive_mail(mixed *data, string mud);
void receive_mail_acknowledge(mixed *data, string mud);

//mudmode_d.c
string to_mudmode(mixed arg);
mixed from_mudmode(string data);

//tell.c
void receive_tell(mixed data);
void send_tell(string who, string where, string msg);

//who.c
void receive_who_reply(mixed data);
private mixed who_data(object ob);
private static int is_greater(object a,object b);
void receive_who_request(mixed data);
void send_who_request(string where);

#endif // __INTERMUD_3__
