/*******************
** Eldarea MUDLib **
********************
**
** sys/daemon/namedb.h - namedb header
**
** CVS DATA
** $Date: 2001/08/20 14:10:22 $
** $Revision: 1.7 $
**
** CVS History
**
** $Log: namedb.h,v $
** Revision 1.7  2001/08/20 14:10:22  eldarea
** made sure that file is only included once
**
** Revision 1.6  2000/12/12 15:28:26  elatar
** typofixes (argl)
**
** Revision 1.5  2000/12/11 13:05:28  elatar
** renamed namehandler.h to namedb.h
**
** Revision 1.4  2000/12/04 14:50:58  elatar
** FreeName() prototype changed
**
** Revision 1.3  2000/01/31 21:26:27  elatar
** Mail Requests implemented
**
** Revision 1.2  2000/01/14 12:46:56  elatar
** namehandler moved to /global/handler/...
**
** Revision 1.1  1999/11/23 17:42:26  elatar
** first release
**
**
*/

#ifndef _NAMEDB_H_
#define _NAMEDB_H_

#define NAME_TRUSTEES ({"elatar","calanar"})
#define NAME_TRUSTED(x) -1!=member(NAME_TRUSTEES,x)

#define NAMEDB_DIR "/global/service"
#define NAMEDB NAMEDB_DIR"/namedb"

#define NAMES NAMEDB_DIR"/names"

#define FN_FREE 1
#define FN_USED 2
#define FN_REST 4
#define FN_ALL 7

#define GSTRING ({"n","m","f"})

#define NAME_SAVE(name,gender) NAMES+"/"+lower_case(name[0..0])+GSTRING[gender]
#define REQUESTS NAMES+"/REQUESTS"

#ifdef NEED_NAME_PROTO

int add_name(string name, mixed race, int gender);
int free_name(string name, int gender);
int remove_name(string name, mixed gender);
int used_name(string name, int gender);
int rest_name(string name, int gender);
int name_exists(string name, int gender);
varargs mixed name_info(string name, int gender);
private mixed _name_info(string name, int gender);
private mixed free_maps(mixed ret);
private int search_name(string name, int gender, int flag);  
varargs string *QueryNames(string start, string race, int gender);
private string * _QueryNames(string start, string race, int gender);
private int contains_val(string key, string *ar,int flag,string va);
private int is_free(string key, string *ar,int flag, string va);
int RegisterName(string name, int gender);
int RestrictName(string name);
int FreeName(string name);
int NameRequest(string name, int gender, string mail);

#undef NEED_NAME_PROTO
#endif // NEED_NAME_PROTO

#endif // _NAMEDB_H_

