/*******************
** Eldarea MUDLib **
********************
**
** sys/daemon/pmaster.h - pmaster header file
**
** CVS DATA
** $Date: 2001/08/20 14:22:32 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: pmaster.h,v $
** Revision 1.3  2001/08/20 14:22:32  eldarea
** made sure file is only included once
**
** Revision 1.2  2000/12/04 14:51:29  elatar
** new function prototypes
**
** Revision 1.1  2000/01/06 14:39:16  elatar
** Initial revision
**
**
*/

#ifndef _PMASTER_H_
#define _PMASTER_H_

#define PMASTER             "/secure/pmaster"
#define PMASTER_CONFIG_DIR  "/secure/ARCH/professions"
#define PM_ATTR 	          0	// Array der beiden Hauptattribute
#define PM_RACE 	          1 // Array der erlaubten Rassen
#define PM_NAME             2	// Name des Berufs
#define PM_TYPE             3	// Typ des Berufs (Spelluser etc.)
#define PM_ASPC             4 // Erlaubte Aspekte
#define PM_WEAP             5 // Erlaubte/Notwendige Weapons
#define PM_SPEL             6 // Zur Verfuegung stehende Spells

#define PT_NONSPELL         0
#define PT_SEMISPELL        1
#define PT_PURESPELL        2

#define PF_TYPE             1

//Vorlaeufig!!
#define P_PROFESSION        "profession"

// Konfigurarion

#define DP_PER_LEVEL    35
#define DP_FIRST_LEVEL  DP_PER_LEVEL

#ifdef PMASTER_NEED_PROTO
#undef PMASTER_NEED_PROTO

private mixed * filter_professions(string * ind, int flag);
varargs mixed * QueryProfessions(string race, int flag);
string * QueryAttributes(string profession);
string * QueryRaces(string profession);
mapping QuerySkills(string profession, mapping fws);
string * QueryName(string profession);
string * QueryAspects(string profession);
int * QuerySpellpoints(string profession);
mixed QueryWeapons(string profession);
int QueryType(string profession);
int AddProfession(mapping profession);
int valid_profession(string profession);
void SetSkillcosts(mapping skills, string profession, mapping fws);

static void _add_value();

#endif // PMASTER_NEED_PROTO

#endif // _PMASTER_H_
