/*******************
** Eldarea MUDLib **
********************
**
** /sys/living/fmoves.h - finishing moves header
**
** CVS DATA
** $Date: 2000/12/04 15:06:11 $
** $Revision: 1.1 $
**
** CVS History
**
** $Log: damage.h,v $
** Revision 1.1  2000/12/04 15:06:11  elatar
** initial release
**
**
*/

#ifndef __DAMAGE_MESSAGES_H__
#define __DAMAGE_MESSAGES_H__

#define P_DAMAGE_MESSAGES       "damage_messages"
#define P_EXCLUSIVE_MESSAGES    "exclusive_messages"
#define P_FINISHING_MOVES       "finishing_moves"
#define P_EXCLUSIVE_MOVES       "exclusive_moves"


#define WT_SMALL_CLAW           "small_claw"
#define WT_MEDIUM_CLAW          "medium_claw"
#define WT_LARGE_CLAW           "large_claw"
#define WT_SMALL_BITE           "small_bite"
#define WT_MEDIUM_BITE          "medium_bite"
#define WT_LARGE_BITE           "large_bite"
#define WT_SMALL_BASH           "small_bash"
#define WT_MEDIUM_BASH          "medium_bash"
#define WT_LARGE_BASH           "large_bash"
#define WT_SMALL_HORN           "small_horn"
#define WT_MEDIUM_HORN          "medium_horn"
#define WT_LARGE_HORN           "large_horn"
#define WT_SMALL_TRAMPLE        "small_trample"
#define WT_MEDIUM_TRAMPLE       "medium_trample"
#define WT_LARGE_TRAMPLE        "large_trample"

#endif // __DAMAGE_MESSAGES_H__

#ifdef NEED_DAMAGE_MESSAGES
#undef NEED_DAMAGE_MESSAGES

// Form der defines: ({Angreifer, Verteidiger, Raum}),({...

#define FM_MEDIUM_CLAW ({\
  ({"Ihr springt nach vorne und zerreisst mit einem kraftvollen Schlag Eurer Kralle "+ME->name(WESSEN)+" Halsschlagader."\
   ,"Schmerzen durchzucken Euch als "+enemy->name(WER,1)+" mit "+enemy->QueryPossPronoun(FEMALE,WESSEN,SINGULAR)+" Kralle nach Eurem Hals schlaegt und Eure Halsschlagader zerreisst."\
   ,enemy->Name(WER)+" schlaegt kraftvoll mit "+enemy->QueryPossPronoun(FEMALE,WESSEN,SINGULAR)+" Kralle nach "+ME->name(WESSEN)+" Hals und zerreisst seine Halsschlagader."}),\
  ({""\
   ,""\
   ,""}),\
  ({""\
   ,""\
   ,""}),\
  ({""\
   ,""\
   ,""}),\
  ({""\
   ,""\
   ,""})\
  })
  
#define FM_MEDIUM_BITE ({\
  ({"Euer gewaltiger Biss zerfleischt "+ME->name(WESSEN)+" Eingeweide."\
   ,"Unertraegliche Schmerzen durchfluten Euch als "+enemy->name(WESSEN)+" Zaehne Eure Eingeweide zerreissen."\
   ,enemy->Name(WESSEN)+" gewaltiger Biss zerfleischt "+ME->name(WESSEN)+" Eingeweide."}),\
  ({""\
   ,""\
   ,""}),\
  ({""\
   ,""\
   ,""}),\
  ({""\
   ,""\
   ,""})\
  })

#define FM_MEDIUM_HORN ({\
  ({"Ihr durchbohrt mit einem machtvollen Stoss Eures Hornes "+ME->name(WESSEN)+" Brustkorb."\
   ,"Blitzschnell stoesst "+enemy->name(WESSEN)+" Kopf herab und durchbohrt Euch mit "+enemy->QueryPossPronoun(NEUTER,WESSEN,SINGULAR)+" Horn."\
   ,enemy->Name(WER)+" stoesst mit "+enemy->QueryPossPronoun(NEUTER,WESSEN,SINGULAR)+" Horn herab und durchbohrt "+ME->name(WESSEN)+" Brustkorb."}),\
  ({""\
   ,""\
   ,""}),\
  ({""\
   ,""\
   ,""})\
  })

#define FM_FIST ({\
  ({"Mit einem machtvollen Schlag zertruemmert Ihr "+ME->name(WESSEN)+" Schaedel."\
   ,"Mit einem machtvollen Schlag zertruemmert "+enemy->name(WER)+" Euren Schaedel."\
   ,"Mit einem machtvollen Schlag zertruemmert "+enemy->name(WER)+" "+ME->name(WESSEN)+" Schaedel."}),\
  ({"Ihr holt aus und lasst Eure Faust hart in "+ME->name(WESSEN)+" Eingeweide sausen. "+ME->Name(WER)+" roechelt."\
   ,enemy->Name(WER)+" holt aus und laesst "+enemy->QueryPossPronoun(FEMALE,WESSEN,SINGULAR)+" Faust hart in Eure Eingeweide sausen. Ihr roechelt."\
   ,enemy->Name(WER)+" holt aus und laesst "+enemy->QueryPossPronoun(FEMALE,WESSEN,SINGULAR)+" Faust hart in "+ME->name(WESSEN)+" Eingeweide  saussen. "+ME->Name(WER)+" roechelt."})\
  })

#define FM_SWORD ({\
  ({"Mit einem maechtigen Streich durchtrennt Ihr "+ME->name(WESSEN)+" Kehle. Ein grosser Blutschwall dringt aus "+ME->QueryPossPronoun(MALE,WESSEN,SINGULAR)+" Hals und "+ME->QueryPronoun(WER)+" beginnt qualvoll zu roecheln."\
   ,"Mit einem maechtigen Streich durchtrennt "+enemy->name(WER)+" Eure Kehle. Ihr spuert, wie Euer Herzschlag das Blut durch die Wunde nach aussen und in Eure Lunge pumpt und beginnt zu roecheln."\
   ,"Mit einem maechtigen Streich durchtrennt "+enemy->name(WER)+" "++ME->name(WESSEN)+" Kehle. Ein grosser Blutschwall dringt aus "+ME->QueryPossPronoun(MALE,WESSEN,SINGULAR)+" Hals und "+ME->QueryPronoun(WER)+" beginnt qualvoll zu roecheln."})\
  })

#define DM_FIST ({\
  ({"Ihr schlagt "+ME->name(WEN)+" %s."\
   ,enemy->Name(WER)+" schlaegt Euch %s."\
   ,enemy->Name(WER)+" schlaegt "+ME->name(WEN)+" %s."})\
  })

#define DM_SWORD ({\
  ({"Ihr schlagt "+ME->name(WEN)+" %s."\
   ,enemy->Name(WER)+" schlaegt Euch %s."\
   ,enemy->Name(WER)+" schlaegt "+ME->name(WEN)+" %s."})\
  })

#define DAMAGE_MESSAGES ([WT_FIST:DM_FIST\
          ])

#define FINISHING_MOVES ([WT_MEDIUM_CLAW:FM_MEDIUM_CLAW\
         ,WT_MEDIUM_BITE:FM_MEDIUM_BITE\
         ,WT_MEDIUM_HORN:FM_MEDIUM_HORN\
                         ,WT_FIST:FM_FIST])
  
#endif // DAMAGE_MESSAGES