/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2000/12/04 14:42:37 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: doorroom.h,v $
** Revision 1.2  2000/12/04 14:42:37  elatar
** GetExits() prototype changed
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland MUDlib
//
// DOORROOM.H -- new doors, managed by doormaster
//
// basierend auf MorgenGrauen Mudlib
//
// $Date: 2000/12/04 14:42:37 $                      
// $Revision: 1.2 $       
/* $Log: doorroom.h,v $
/* Revision 1.2  2000/12/04 14:42:37  elatar
/* GetExits() prototype changed
/*
/* Revision 1.1.1.1  1999/11/05 12:30:47  elatar
/* Preparing mudlib for cvs control
/*
/* Revision 1.1.1.1  1999/11/04 12:48:15  en
/* MUDLib CVS Preperation
/*
 * Revision 1.2  1999/05/17 15:48:53  Fiona
 * Doormaster umgezogen
 *
 * Revision 1.1  1997/08/12 16:17:00  Mohammed
 * Initial revision
 *
 * Revision 1.2  1994/12/21  13:31:09  Troy
 * Added D_ADJECTIVES
 *
 * Revision 1.1  1994/12/21  10:44:09  Troy
 * Initial revision
 *
 */

#ifndef _DOORROOM_H_
#define _DOORROOM_H_

#define DOOR_MASTER "/global/service/doormaster"
#define P_DOOR_INFOS "door_infos"   // Informationen

#define DOOR_OPEN     0x01 // Tuer initial offen
#define DOOR_CLOSED   0x02 // Tuer initial zu
#define DOOR_NEEDKEY  0x08 // Man braucht einen Schluessel zum Oeffnen
#define DOOR_CLOSEKEY 0x10 // Man braucht einen Schluessel zum Schliessen
#define DOOR_RESET_CL 0x20 // Tuer schliesst sich bei jedem reset()
#define DOOR_RESET_OP 0x40 // Tuer oeffnet sich bei jedem reset()

#define D_DEST 0
#define D_CMDS 1
#define D_IDS 2

// properties
// Ab hier die aenderbaren Eigenschaften der Tuer
#define D_FLAGS 3
#define D_LONG 4
#define D_SHORT 5
#define D_NAME 6
#define D_GENDER 7
#define D_FUNC 8		// Funktion, die VOR dem Durchschreiten der Tuer aufgerufen 
				// wird (im Startraum)
#define D_MSGS 9		// Messages fuer Move
#define D_FUNC2 10		// Funktion, die NACH dem Durchschreiten der Tuer aufgerufen 
				// wird (im Zielraum)
#define D_TESTFUNC 11		// Funktion, die testet, ob die Tuer durchschritten werden darf 
				// (im Startraum)
#define D_ADJECTIVES 12		// Adjektive der Tuer.
#define D_PICKLOCK 13		// eine verschlossene Tuer darf anders geoeffnet werden

#define D_MINPROPS 3
#define D_MAXPROPS 13

#define D_STATUS_LOCKED -2
#define D_STATUS_CLOSED -1
#define D_STATUS_OPEN    1
#define D_STATUS_BROKEN  2

#endif /* _DOORROOM_H_ */

#ifdef NEED_PROTOTYPES

#ifndef __DOORROOM_H_PROTO__
#define __DOORROOM_H_PROTO__

// prototypes
mapping QueryAllDoors();
varargs int NewDoor(mixed cmds, string dest, mixed ids, mixed props);
void    init_doors ();
string  look_doors ();
void    reset_doors ();
varargs int go_door (string str);
varargs int oeffnen (string str, int silent);
varargs int schliessen (string str, int silent);
int     set_doors (string *cmds, int open);
varargs string GetExits(object viewer, int short); 

#endif /* __DOORROOM_H_PROTO__ */
#endif /* NEED_PROTOTYPES */
